/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.awt.Color;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.plugin.jei.IRecipeTooltipReplacement;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.fabric.JEITypes;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class AlloyRecipeCategory
implements IRecipeCategory<AlloyRecipe> {
    private static final class_2960 BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/alloy.png");
    private static final class_2561 TITLE = TConstruct.makeTranslation("jei", "alloy.title");
    private static final String KEY_TEMPERATURE = TConstruct.makeTranslationKey("jei", "temperature");
    private static final IRecipeTooltipReplacement FLUID_TOOLTIP = (slot, list) -> slot.getDisplayedIngredient(JEITypes.FLUID_STACK).ifPresent(stack -> FluidTooltipHandler.appendMaterial((FluidStack)stack, (List)list));
    public static final IRecipeTooltipReplacement FUEL_TOOLTIP = (slot, tooltip) -> slot.getDisplayedIngredient(JEITypes.FLUID_STACK).ifPresent(stack -> MeltingFuelHandler.getTemperature(stack.getFluid()).ifPresent(temperature -> tooltip.add(class_2561.method_43469((String)KEY_TEMPERATURE, (Object[])new Object[]{temperature}).method_27692(class_124.field_1080))));
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable tank;

    public AlloyRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 0, 172, 62);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799(TinkerSmeltery.smelteryController));
        this.arrow = helper.drawableBuilder(BACKGROUND_LOC, 172, 0, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tank = helper.createDrawable(BACKGROUND_LOC, 172, 17, 16, 16);
    }

    public RecipeType<AlloyRecipe> getRecipeType() {
        return TConstructJEIConstants.ALLOY;
    }

    public class_2561 getTitle() {
        return TITLE;
    }

    public void draw(AlloyRecipe recipe, IRecipeSlotsView slots, class_332 graphics, double mouseX, double mouseY) {
        this.arrow.draw(graphics, 90, 21);
        class_327 fontRenderer = class_310.method_1551().field_1772;
        String tempString = class_1074.method_4662((String)KEY_TEMPERATURE, (Object[])new Object[]{recipe.getTemperature()});
        int x = 102 - fontRenderer.method_1727(tempString) / 2;
        graphics.method_51433(fontRenderer, tempString, x, 5, Color.GRAY.getRGB(), false);
    }

    public static long drawVariableFluids(IRecipeLayoutBuilder builder, RecipeIngredientRole role, int x, int y, int totalWidth, int height, List<List<FluidStack>> fluids, long minAmount, IRecipeSlotTooltipCallback tooltip) {
        int count = fluids.size();
        long maxAmount = minAmount;
        if (count > 0) {
            for (List<FluidStack> list : fluids) {
                for (FluidStack input : list) {
                    if (input.getAmount() <= maxAmount) continue;
                    maxAmount = input.getAmount();
                }
            }
            int w = totalWidth / count;
            int max = count - 1;
            for (int i = 0; i < max; ++i) {
                int fluidX = x + i * w;
                builder.addSlot(role, fluidX, y).addTooltipCallback(tooltip).setFluidRenderer(maxAmount, false, w, height).addIngredients(JEITypes.FLUID_STACK, fluids.get(i));
            }
            int fluidX = x + max * w;
            builder.addSlot(role, fluidX, y).addTooltipCallback(tooltip).setFluidRenderer(maxAmount, false, totalWidth - w * max, height).addIngredients(JEITypes.FLUID_STACK, fluids.get(max));
        }
        return maxAmount;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlloyRecipe recipe, IFocusGroup focuses) {
        long maxAmount = AlloyRecipeCategory.drawVariableFluids(builder, RecipeIngredientRole.INPUT, 19, 11, 48, 32, recipe.getDisplayInputs(), recipe.getOutput().getAmount(), FLUID_TOOLTIP);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 137, 11).addTooltipCallback((IRecipeSlotTooltipCallback)FLUID_TOOLTIP).setFluidRenderer(maxAmount, false, 16, 32).addIngredient(JEITypes.FLUID_STACK, (Object)recipe.getOutput());
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 94, 43).addTooltipCallback((IRecipeSlotTooltipCallback)FUEL_TOOLTIP).setFluidRenderer(1L, false, 16, 16).setOverlay(this.tank, 0, 0).addIngredients(JEITypes.FLUID_STACK, MeltingFuelHandler.getUsableFuels(recipe.getTemperature()));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

