/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.gson.JsonObject;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import slimeknights.tconstruct.TConstruct;

public record ScalingValue(float flat, float leveling, float randomBonus) {
    public float computeValue(float level) {
        float value = this.flat + this.leveling * level;
        if (this.randomBonus > 0.0f && level > 0.0f) {
            value += TConstruct.RANDOM.method_43057() * level * this.randomBonus;
        }
        return value;
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        if (this.flat != 0.0f) {
            json.addProperty("flat", (Number)Float.valueOf(this.flat));
        }
        if (this.leveling != 0.0f) {
            json.addProperty("leveling", (Number)Float.valueOf(this.leveling));
        }
        if (this.randomBonus != 0.0f) {
            json.addProperty("random", (Number)Float.valueOf(this.randomBonus));
        }
        return json;
    }

    public static ScalingValue deserialize(JsonObject json) {
        float flat = class_3518.method_15277((JsonObject)json, (String)"flat", (float)0.0f);
        float leveling = class_3518.method_15277((JsonObject)json, (String)"leveling", (float)0.0f);
        float random = class_3518.method_15277((JsonObject)json, (String)"random", (float)0.0f);
        return new ScalingValue(flat, leveling, random);
    }

    public static ScalingValue get(JsonObject parent, String key) {
        return ScalingValue.deserialize(class_3518.method_15296((JsonObject)parent, (String)key));
    }

    public void toNetwork(class_2540 buffer) {
        buffer.writeFloat(this.flat);
        buffer.writeFloat(this.leveling);
        buffer.writeFloat(this.randomBonus);
    }

    public static ScalingValue fromNetwork(class_2540 buffer) {
        float flat = buffer.readFloat();
        float leveling = buffer.readFloat();
        float random = buffer.readFloat();
        return new ScalingValue(flat, leveling, random);
    }

    public static ScalingValue flat(float value) {
        return new ScalingValue(value, 0.0f, 0.0f);
    }

    public static ScalingValue leveling(float flat, float leveling) {
        return new ScalingValue(flat, leveling, 0.0f);
    }

    public static ScalingValue random(float flat, float random) {
        return new ScalingValue(flat, 0.0f, random);
    }
}

