/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.util.TierSortingRegistry;
import io.netty.handler.codec.DecoderException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1832;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.utils.HarvestTiers;
import slimeknights.tconstruct.library.utils.Util;

public class ToolTierStat
implements IToolStat<class_1832> {
    private final ToolStatId name;

    @Override
    public boolean supports(class_1792 item) {
        return RegistryHelper.contains(TinkerTags.Items.HARVEST, (class_1792)item);
    }

    @Override
    public class_1832 getDefaultValue() {
        return HarvestTiers.minTier();
    }

    @Override
    public Object makeBuilder() {
        return new TierBuilder(this.getDefaultValue());
    }

    @Override
    public class_1832 build(Object builder, class_1832 value) {
        return HarvestTiers.max(((TierBuilder)builder).value, value);
    }

    @Override
    public void update(ModifierStatsBuilder builder, class_1832 value) {
        builder.updateStat(this, b -> {
            b.value = HarvestTiers.max(b.value, value);
        });
    }

    @Override
    @Nullable
    public class_1832 read(class_2520 tag) {
        class_2960 tierId;
        if (tag.method_10711() == 8 && (tierId = class_2960.method_12829((String)tag.method_10714())) != null) {
            return TierSortingRegistry.byName((class_2960)tierId);
        }
        return null;
    }

    @Override
    public class_2520 write(class_1832 value) {
        class_2960 id = TierSortingRegistry.getName((class_1832)value);
        if (id != null) {
            return class_2519.method_23256((String)id.toString());
        }
        return null;
    }

    @Override
    public class_1832 deserialize(JsonElement json) {
        class_2960 id = JsonHelper.convertToResourceLocation((JsonElement)json, (String)this.getName().toString());
        class_1832 tier = TierSortingRegistry.byName((class_2960)id);
        if (tier != null) {
            return tier;
        }
        throw new JsonSyntaxException("Unknown tool tier " + id);
    }

    @Override
    public JsonElement serialize(class_1832 value) {
        return new JsonPrimitive(Objects.requireNonNull(TierSortingRegistry.getName((class_1832)value)).toString());
    }

    @Override
    public class_1832 fromNetwork(class_2540 buffer) {
        class_2960 id = buffer.method_10810();
        class_1832 tier = TierSortingRegistry.byName((class_2960)id);
        if (tier != null) {
            return tier;
        }
        throw new DecoderException("Unknown tool tier " + id);
    }

    @Override
    public void toNetwork(class_2540 buffer, class_1832 value) {
        buffer.method_10812(Objects.requireNonNull(TierSortingRegistry.getName((class_1832)value)));
    }

    @Override
    public class_2561 formatValue(class_1832 value) {
        return class_2561.method_43471((String)Util.makeTranslationKey("tool_stat", this.getName())).method_10852(HarvestTiers.getName(value));
    }

    public String toString() {
        return "ToolTierStat{" + this.name + "}";
    }

    @Override
    public ToolStatId getName() {
        return this.name;
    }

    public ToolTierStat(ToolStatId name) {
        this.name = name;
    }

    private static class TierBuilder {
        private class_1832 value;

        public TierBuilder(class_1832 value) {
            this.value = value;
        }
    }
}

