/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.part;

import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.utils.DomainDisplayName;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialItem
extends class_1792
implements IMaterialItem {
    private static final String ADDED_BY = TConstruct.makeTranslationKey("tooltip", "part.added_by");

    public MaterialItem(class_1792.class_1793 properties, @Nullable class_5321<class_1761> tab) {
        super(properties);
        if (tab != null) {
            ItemGroupEvents.modifyEntriesEvent(tab).register(this::fillItemCategory);
        }
    }

    private static MaterialVariantId getMaterialId(@Nullable class_2487 nbt) {
        MaterialVariantId id;
        String str;
        if (nbt != null && !(str = nbt.method_10558("Material")).isEmpty() && (id = MaterialVariantId.tryParse(str)) != null) {
            return id;
        }
        return IMaterial.UNKNOWN_ID;
    }

    @Override
    public MaterialVariantId getMaterial(class_1799 stack) {
        return MaterialItem.getMaterialId(stack.method_7969());
    }

    public void fillItemCategory(FabricItemGroupEntries items) {
        if (MaterialRegistry.isFullyLoaded()) {
            MaterialVariantId materialId;
            String showOnlyId = (String)Config.COMMON.showOnlyPartMaterial.get();
            boolean added = false;
            if (!showOnlyId.isEmpty() && (materialId = MaterialVariantId.tryParse(showOnlyId)) != null && this.canUseMaterial(materialId.getId())) {
                items.method_45420(this.withMaterialForDisplay(materialId));
                added = true;
            }
            if (!added) {
                for (IMaterial material : MaterialRegistry.getInstance().getVisibleMaterials()) {
                    MaterialId id = material.getIdentifier();
                    if (!this.canUseMaterial(id)) continue;
                    items.method_45420(this.withMaterial(id));
                    if (showOnlyId.isEmpty()) continue;
                    break;
                }
            }
        }
    }

    @Nullable
    private static class_2561 getName(String baseKey, MaterialVariantId material) {
        class_2960 location = material.getLocation('.');
        String fullKey = String.format("%s.%s.%s", baseKey, location.method_12836(), location.method_12832());
        if (Util.canTranslate(fullKey)) {
            return class_2561.method_43471((String)fullKey);
        }
        String materialKey = MaterialTooltipCache.getKey(material);
        String materialPrefix = materialKey + ".format";
        if (Util.canTranslate(materialPrefix)) {
            return class_2561.method_43469((String)materialPrefix, (Object[])new Object[]{class_2561.method_43471((String)baseKey)});
        }
        if (Util.canTranslate(materialKey)) {
            return class_2561.method_43469((String)TooltipUtil.KEY_FORMAT, (Object[])new Object[]{class_2561.method_43471((String)materialKey), class_2561.method_43471((String)baseKey)});
        }
        return null;
    }

    public class_2561 method_7864(class_1799 stack) {
        class_2561 component;
        MaterialVariantId material = this.getMaterial(stack);
        if (material.equals(IMaterial.UNKNOWN_ID)) {
            return super.method_7864(stack);
        }
        String key = this.method_7866(stack);
        if (material.hasVariant() && (component = MaterialItem.getName(key, material)) != null) {
            return component;
        }
        component = MaterialItem.getName(key, material.getId());
        if (component != null) {
            return component;
        }
        return class_2561.method_43471((String)key);
    }

    @Nullable
    public String getCreatorModId(class_1799 stack) {
        MaterialVariantId material = this.getMaterial(stack);
        if (!IMaterial.UNKNOWN_ID.equals(material)) {
            return material.getId().method_12836();
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)this);
        return id == null ? null : id.method_12836();
    }

    protected static void addModTooltip(IMaterial material, List<class_2561> tooltip) {
        if (material != IMaterial.UNKNOWN) {
            tooltip.add((class_2561)class_2561.method_43473());
            tooltip.add((class_2561)class_2561.method_43469((String)ADDED_BY, (Object[])new Object[]{DomainDisplayName.nameFor(material.getIdentifier().method_12836())}));
        }
    }

    public void method_7860(class_2487 nbt) {
        MaterialId resolved;
        MaterialId original;
        MaterialVariantId id = MaterialItem.getMaterialId(nbt);
        if (!id.equals(IMaterial.UNKNOWN_ID) && (original = id.getId()) != (resolved = MaterialRegistry.getInstance().resolve(original))) {
            nbt.method_10582("Material", MaterialVariantId.create(resolved, id.getVariant()).toString());
        }
    }
}

