/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_5134;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class ModifiableItemUtil {
    private static final UUID[] HELD_ARMOR_UUID = new UUID[]{UUID.fromString("00a1a5fe-43b5-4849-8660-de9aa497736a"), UUID.fromString("6776fd7e-4b22-4cdf-a0bc-bb8d2ad1f0bf")};

    private ModifiableItemUtil() {
    }

    public static Multimap<class_1320, class_1322> getMeleeAttributeModifiers(IToolStackView tool, class_1304 slot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (!tool.isBroken()) {
            StatsNBT statsNBT = tool.getStats();
            if (slot == class_1304.field_6173 && tool.hasTag(TinkerTags.Items.MELEE)) {
                builder.put((Object)class_5134.field_23721, (Object)new class_1322(class_1792.field_8006, "tconstruct.tool.attack_damage", (double)statsNBT.get(ToolStats.ATTACK_DAMAGE).floatValue(), class_1322.class_1323.field_6328));
                builder.put((Object)class_5134.field_23723, (Object)new class_1322(class_1792.field_8001, "tconstruct.tool.attack_speed", (double)statsNBT.get(ToolStats.ATTACK_SPEED).floatValue() - 4.0, class_1322.class_1323.field_6328));
            }
            if (slot.method_5925() == class_1304.class_1305.field_6177) {
                if (tool.hasTag(TinkerTags.Items.ARMOR)) {
                    UUID uuid = HELD_ARMOR_UUID[slot.method_5927()];
                    double value = statsNBT.get(ToolStats.ARMOR).floatValue();
                    if (value != 0.0) {
                        builder.put((Object)class_5134.field_23724, (Object)new class_1322(uuid, "tconstruct.held.armor", value, class_1322.class_1323.field_6328));
                    }
                    if ((value = (double)statsNBT.get(ToolStats.ARMOR_TOUGHNESS).floatValue()) != 0.0) {
                        builder.put((Object)class_5134.field_23725, (Object)new class_1322(uuid, "tconstruct.held.toughness", value, class_1322.class_1323.field_6328));
                    }
                    if ((value = (double)statsNBT.get(ToolStats.KNOCKBACK_RESISTANCE).floatValue()) != 0.0) {
                        builder.put((Object)class_5134.field_23718, (Object)new class_1322(uuid, "tconstruct.held.knockback_resistance", value, class_1322.class_1323.field_6328));
                    }
                }
                BiConsumer<class_1320, class_1322> attributeConsumer = (arg_0, arg_1) -> ((ImmutableMultimap.Builder)builder).put(arg_0, arg_1);
                for (ModifierEntry entry : tool.getModifierList()) {
                    entry.getHook(TinkerHooks.ATTRIBUTES).addAttributes(tool, entry, slot, attributeConsumer);
                }
            }
        }
        return builder.build();
    }

    public static boolean shouldCauseReequip(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
        if (oldStack == newStack) {
            return false;
        }
        if (slotChanged || oldStack.method_7909() != newStack.method_7909()) {
            return true;
        }
        ToolStack oldTool = ToolStack.from(oldStack);
        ToolStack newTool = ToolStack.from(newStack);
        if (!oldTool.getMaterials().equals(newTool.getMaterials())) {
            return true;
        }
        if (!oldTool.getModifierList().equals(newTool.getModifierList())) {
            return true;
        }
        Multimap attributesNew = newStack.method_7926(class_1304.field_6173);
        Multimap attributesOld = oldStack.method_7926(class_1304.field_6173);
        if (attributesNew.size() != attributesOld.size()) {
            return true;
        }
        for (class_1320 attribute : attributesOld.keySet()) {
            if (!attributesNew.containsKey((Object)attribute)) {
                return true;
            }
            Iterator iter1 = attributesNew.get((Object)attribute).iterator();
            Iterator iter2 = attributesOld.get((Object)attribute).iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                if (((class_1322)iter1.next()).equals(iter2.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static void heldInventoryTick(class_1799 stack, class_1937 worldIn, class_1297 entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof class_1309) {
            List<ModifierEntry> modifiers;
            ToolStack tool = ToolStack.from(stack);
            if (!worldIn.field_9236) {
                tool.ensureHasData();
            }
            if (!(modifiers = tool.getModifierList()).isEmpty()) {
                class_1309 living = (class_1309)entityIn;
                boolean isHeld = isSelected || living.method_6079() == stack;
                for (ModifierEntry entry : modifiers) {
                    entry.getModifier().onInventoryTick(tool, entry.getLevel(), worldIn, living, itemSlot, isSelected, isHeld, stack);
                }
            }
        }
    }
}

