/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;

public interface IToolModule
extends GenericLoaderRegistry.IHaveLoader<IToolModule> {
    public static final GenericLoaderRegistry<IToolModule> LOADER = new GenericLoaderRegistry();

    public static ModifierHookMap read(class_2540 buffer) {
        int size = buffer.method_10816();
        ModifierHookMap.Builder builder = new ModifierHookMap.Builder();
        for (int i = 0; i < size; ++i) {
            class_2960 hookName = buffer.method_10810();
            ModifierHook<?> hook = ModifierHooks.getHook(hookName);
            if (hook == null) {
                throw new DecoderException("Unknown hook from network, this likely indicates a broken or outdated mod: " + hookName);
            }
            IToolModule module = (IToolModule)LOADER.fromNetwork(buffer);
            builder.addHookChecked(module, hook);
        }
        return builder.build();
    }

    public static void write(ModifierHookMap modules, class_2540 buffer) {
        List<Map.Entry> entries = modules.getAllModules().entrySet().stream().filter(entry -> entry.getValue() instanceof IToolModule).toList();
        buffer.method_10804(entries.size());
        for (Map.Entry entry2 : entries) {
            buffer.method_10812(((ModifierHook)entry2.getKey()).getName());
            LOADER.toNetwork((GenericLoaderRegistry.IHaveLoader)((IToolModule)entry2.getValue()), buffer);
        }
    }

    public static enum Serializer implements JsonSerializer<ModifierHookMap>,
    JsonDeserializer<ModifierHookMap>
    {
        INSTANCE;


        public ModifierHookMap deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = class_3518.method_15295((JsonElement)element, (String)"modules");
            ModifierHookMap.Builder builder = new ModifierHookMap.Builder();
            for (Map.Entry entry : json.entrySet()) {
                class_2960 hookName = class_2960.method_12829((String)((String)entry.getKey()));
                if (hookName == null) {
                    throw new JsonSyntaxException("Invalid hook name " + (String)entry.getKey());
                }
                ModifierHook<?> hook = ModifierHooks.getHook(hookName);
                if (hook == null) {
                    throw new JsonSyntaxException("Unknown hook name " + hookName);
                }
                builder.addHookChecked(LOADER.deserialize((JsonElement)entry.getValue()), hook);
            }
            return builder.build();
        }

        public JsonElement serialize(ModifierHookMap src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            for (Map.Entry<ModifierHook<?>, Object> entry : src.getAllModules().entrySet()) {
                Object object = entry.getValue();
                if (!(object instanceof IToolModule)) continue;
                IToolModule module = (IToolModule)object;
                json.add(entry.getKey().getName().toString(), LOADER.serialize((GenericLoaderRegistry.IHaveLoader)module));
            }
            return json;
        }
    }
}

