/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.aoe;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3518;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.tools.definition.aoe.BoxAOEIterator;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.aoe.IBoxExpansion;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class CircleAOEIterator
implements IAreaOfEffectIterator {
    public static final Loader LOADER = new Loader();
    @VisibleForTesting
    protected final int diameter;
    @VisibleForTesting
    protected final boolean is3D;

    public GenericLoaderRegistry.IGenericLoader<? extends IAreaOfEffectIterator> getLoader() {
        return LOADER;
    }

    @Override
    public Iterable<class_2338> getBlocks(IToolStackView tool, class_1799 stack, class_1657 player, class_2680 state, class_1937 world, class_2338 origin, class_2350 sideHit, IAreaOfEffectIterator.AOEMatchType matchType) {
        int expanded = tool.getModifierLevel(TinkerModifiers.expanded.getId());
        return CircleAOEIterator.calculate(tool, stack, world, player, origin, sideHit, this.diameter + expanded, this.is3D, matchType);
    }

    public static Iterable<class_2338> calculate(IToolStackView tool, class_1799 stack, class_1937 world, class_1657 player, class_2338 origin, class_2350 sideHit, int diameter, boolean is3D, IAreaOfEffectIterator.AOEMatchType matchType) {
        if (diameter == 1) {
            return Collections.emptyList();
        }
        int radiusSq = diameter * diameter / 4;
        Predicate<class_2338> posPredicate = IAreaOfEffectIterator.defaultBlockPredicate(tool, stack, world, origin, matchType);
        IBoxExpansion.ExpansionDirections directions = IBoxExpansion.SIDE_HIT.getDirections(player, sideHit);
        return () -> new CircleIterator(origin, directions.width(), directions.height(), directions.traverseDown(), directions.depth(), radiusSq, diameter / 2, is3D, posPredicate);
    }

    public CircleAOEIterator(int diameter, boolean is3D) {
        this.diameter = diameter;
        this.is3D = is3D;
    }

    public int getDiameter() {
        return this.diameter;
    }

    public boolean is3D() {
        return this.is3D;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<CircleAOEIterator> {
        private Loader() {
        }

        public CircleAOEIterator deserialize(JsonObject json) {
            int diameter = JsonUtils.getIntMin(json, "diameter", 1);
            boolean is3D = class_3518.method_15258((JsonObject)json, (String)"3D", (boolean)false);
            return new CircleAOEIterator(diameter, is3D);
        }

        public CircleAOEIterator fromNetwork(class_2540 buffer) {
            int diameter = buffer.method_10816();
            boolean is3D = buffer.readBoolean();
            return new CircleAOEIterator(diameter, is3D);
        }

        public void serialize(CircleAOEIterator object, JsonObject json) {
            json.addProperty("diameter", (Number)object.diameter);
            json.addProperty("3D", Boolean.valueOf(object.is3D));
        }

        public void toNetwork(CircleAOEIterator object, class_2540 buffer) {
            buffer.method_10804(object.diameter);
            buffer.writeBoolean(object.is3D);
        }
    }

    private static class CircleIterator
    extends BoxAOEIterator.RectangleIterator {
        private final int radiusSq;

        private CircleIterator(class_2338 origin, class_2350 widthDir, class_2350 heightDir, boolean traverseDown, class_2350 depthDir, int radiusSq, int extra, boolean is3D, Predicate<class_2338> posPredicate) {
            super(origin, widthDir, extra, heightDir, extra, traverseDown, depthDir, is3D ? extra : 0, posPredicate);
            this.radiusSq = radiusSq;
        }

        private int distanceSq() {
            int dx = this.origin.method_10263() - this.mutablePos.method_10263();
            int dy = this.origin.method_10264() - this.mutablePos.method_10264();
            int dz = this.origin.method_10260() - this.mutablePos.method_10260();
            return dx * dx + dy * dy + dz * dz;
        }

        @Override
        protected class_2338 computeNext() {
            this.mutablePos.method_10103(this.lastX, this.lastY, this.lastZ);
            while (this.incrementPosition()) {
                if (this.mutablePos.equals((Object)this.origin) || this.distanceSq() > this.radiusSq || !this.posPredicate.test(this.mutablePos)) continue;
                this.lastX = this.mutablePos.method_10263();
                this.lastY = this.mutablePos.method_10264();
                this.lastZ = this.mutablePos.method_10260();
                return this.mutablePos;
            }
            return (class_2338)this.endOfData();
        }
    }
}

