/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipeBuilder;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRecipeBuilder
extends AbstractModifierRecipeBuilder<ModifierRecipeBuilder> {
    protected final List<SizedIngredient> inputs = new ArrayList<SizedIngredient>();

    protected ModifierRecipeBuilder(ModifierEntry result) {
        super(result);
    }

    public static ModifierRecipeBuilder modifier(ModifierEntry modifier) {
        return new ModifierRecipeBuilder(modifier);
    }

    public static ModifierRecipeBuilder modifier(ModifierId modifier) {
        return ModifierRecipeBuilder.modifier(new ModifierEntry(modifier, 1));
    }

    public static ModifierRecipeBuilder modifier(LazyModifier modifier) {
        return ModifierRecipeBuilder.modifier(modifier.getId());
    }

    public ModifierRecipeBuilder addInput(SizedIngredient ingredient) {
        this.inputs.add(ingredient);
        return this;
    }

    public ModifierRecipeBuilder addInput(class_1856 ingredient) {
        return this.addInput(SizedIngredient.of((class_1856)ingredient));
    }

    public ModifierRecipeBuilder addInput(class_1935 item, int amount) {
        return this.addInput(SizedIngredient.fromItems((int)amount, (class_1935[])new class_1935[]{item}));
    }

    public ModifierRecipeBuilder addInput(class_1935 item) {
        return this.addInput(item, 1);
    }

    public ModifierRecipeBuilder addInput(class_6862<class_1792> tag, int amount) {
        return this.addInput(SizedIngredient.fromTag(tag, (int)amount));
    }

    public ModifierRecipeBuilder addInput(class_6862<class_1792> tag) {
        return this.addInput(tag, 1);
    }

    public void save(Consumer<class_2444> consumer, class_2960 id) {
        if (this.inputs.isEmpty() && !this.allowCrystal) {
            throw new IllegalStateException("Must have at least 1 input");
        }
        class_2960 advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((class_2444)new FinishedAdding(id, advancementId, this.includeUnarmed));
    }

    @Override
    public ModifierRecipeBuilder saveSalvage(Consumer<class_2444> consumer, class_2960 id) {
        if (this.salvageMaxLevel != 0 && this.salvageMaxLevel < this.salvageMinLevel) {
            throw new IllegalStateException("Max level must be greater than min level");
        }
        class_2960 advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((class_2444)new AbstractModifierRecipeBuilder.SalvageFinishedRecipe(id, advancementId));
        return this;
    }

    protected class FinishedAdding
    extends AbstractModifierRecipeBuilder.ModifierFinishedRecipe {
        public FinishedAdding(@Nullable class_2960 ID, class_2960 advancementID, boolean withUnarmed) {
            super(ID, advancementID, withUnarmed);
        }

        @Override
        public void method_10416(JsonObject json) {
            JsonArray array = new JsonArray();
            for (SizedIngredient ingredient : ModifierRecipeBuilder.this.inputs) {
                array.add((JsonElement)ingredient.serialize());
            }
            json.add("inputs", (JsonElement)array);
            super.method_10416(json);
        }

        public class_1865<?> method_17800() {
            return (class_1865)TinkerModifiers.modifierSerializer.get();
        }
    }
}

