/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.container.ISingleStackContainer;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.material.IMaterialValue;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tables.TinkerTables;

public class MaterialRecipe
implements ICustomOutputRecipe<ISingleStackContainer>,
IMaterialValue {
    public static final float INGOTS_PER_REPAIR = 3.0f;
    protected final class_2960 id;
    protected final String group;
    protected final class_1856 ingredient;
    protected final int value;
    protected final int needed;
    protected final MaterialVariant material;
    protected final ItemOutput leftover;
    @Nullable
    private Float repairPerItem;
    private List<class_1799> displayItems = null;

    public MaterialRecipe(class_2960 id, String group, class_1856 ingredient, int value, int needed, MaterialVariantId materialId, ItemOutput leftover) {
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.value = value;
        this.needed = needed;
        this.material = MaterialVariant.of(materialId);
        this.leftover = leftover;
    }

    public class_3956<?> method_17716() {
        return (class_3956)TinkerRecipeTypes.MATERIAL.get();
    }

    public class_1799 method_17447() {
        return new class_1799(TinkerTables.partBuilder);
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerTables.materialRecipeSerializer.get();
    }

    @Override
    public class_1799 getLeftover() {
        return this.leftover.get().method_7972();
    }

    public boolean matches(ISingleStackContainer inv, class_1937 worldIn) {
        return !this.material.isUnknown() && this.ingredient.method_8093(inv.getStack());
    }

    public class_2371<class_1856> method_8117() {
        return class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{this.ingredient});
    }

    public List<class_1799> getDisplayItems() {
        if (this.displayItems == null) {
            this.displayItems = this.needed > 1 ? Arrays.stream(this.ingredient.method_8105()).map(stack -> ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)this.needed)).collect(Collectors.toList()) : Arrays.asList(this.ingredient.method_8105());
        }
        return this.displayItems;
    }

    public float getRepairPerItem(ToolDefinitionData data, @Nullable MaterialStatsId statsId) {
        if (this.repairPerItem == null) {
            this.repairPerItem = Float.valueOf((float)(this.getValue() * MaterialRecipe.getRepairDurability(data, this.material.getId(), statsId)) / 3.0f / (float)this.getNeeded());
        }
        return this.repairPerItem.floatValue();
    }

    public static int getRepairDurability(ToolDefinitionData toolData, MaterialId materialId, @Nullable MaterialStatsId statsId) {
        Optional<IMaterialStats> optional = statsId != null ? MaterialRegistry.getInstance().getMaterialStats(materialId, statsId).filter(stats -> stats instanceof IRepairableMaterialStats) : MaterialRegistry.getInstance().getAllStats(materialId).stream().filter(stats -> stats instanceof IRepairableMaterialStats).findFirst();
        return optional.map(stats -> ((IRepairableMaterialStats)stats).getDurability()).orElseGet(() -> toolData.getBaseStat(ToolStats.DURABILITY).intValue());
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public String method_8112() {
        return this.group;
    }

    public class_1856 getIngredient() {
        return this.ingredient;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public int getNeeded() {
        return this.needed;
    }

    @Override
    public MaterialVariant getMaterial() {
        return this.material;
    }
}

