/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.netty.handler.codec.DecoderException;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import slimeknights.mantle.recipe.helper.ItemOutput;

public abstract class RandomItem {
    public static RandomItem range(ItemOutput result, int minCount) {
        return new Range(result, minCount);
    }

    public static RandomItem range(ItemOutput result) {
        return RandomItem.range(result, 0);
    }

    public static RandomItem chance(ItemOutput result, float chance) {
        return new Chance(result, chance);
    }

    public static RandomItem constant(ItemOutput result) {
        return RandomItem.chance(result, 1.0f);
    }

    public abstract class_1799 get(Random var1);

    public abstract JsonElement serialize();

    public abstract void write(class_2540 var1);

    public static RandomItem fromJson(JsonElement element, String name) {
        JsonObject object;
        if (element.isJsonObject() && (object = element.getAsJsonObject()).has("max")) {
            object.addProperty("count", (Number)class_3518.method_15260((JsonObject)object, (String)"max"));
            object.remove("max");
        }
        ItemOutput result = ItemOutput.fromJson((JsonElement)element);
        if (element.isJsonPrimitive()) {
            return RandomItem.constant(result);
        }
        if (!element.isJsonObject()) {
            throw new JsonSyntaxException("Invalid RandomItem at '" + name + "', must be a string or an object");
        }
        JsonObject object2 = element.getAsJsonObject();
        if (object2.has("min")) {
            return RandomItem.range(result, class_3518.method_15260((JsonObject)object2, (String)"min"));
        }
        if (object2.has("chance")) {
            return RandomItem.chance(result, class_3518.method_15259((JsonObject)object2, (String)"chance"));
        }
        return RandomItem.constant(result);
    }

    public static RandomItem read(class_2540 buffer) {
        ItemOutput result = ItemOutput.read((class_2540)buffer);
        RandomType type = (RandomType)buffer.method_10818(RandomType.class);
        switch (type) {
            case RANGE: {
                int min = buffer.method_10816();
                return RandomItem.range(result, min);
            }
            case CHANCE: {
                float chance = buffer.readFloat();
                return RandomItem.chance(result, chance);
            }
        }
        throw new DecoderException("Invalid random type " + type + " for RandomItem");
    }

    private static class Range
    extends RandomItem {
        private final ItemOutput result;
        private final int minCount;

        @Override
        public class_1799 get(Random random) {
            class_1799 result = this.result.get();
            int newCount = result.method_7947();
            if (result.method_7947() > this.minCount && (newCount = this.minCount + random.nextInt(result.method_7947() - this.minCount)) <= 0) {
                return class_1799.field_8037;
            }
            return ItemHandlerHelper.copyStackWithSize((class_1799)result, (int)newCount);
        }

        @Override
        public JsonElement serialize() {
            JsonObject object;
            JsonElement resultElement = this.result.serialize();
            if (resultElement.isJsonPrimitive()) {
                object = new JsonObject();
                object.add("item", resultElement);
            } else {
                object = resultElement.getAsJsonObject();
            }
            object.addProperty("min", (Number)this.minCount);
            object.addProperty("max", (Number)class_3518.method_15282((JsonObject)object, (String)"count", (int)1));
            object.remove("count");
            return object;
        }

        @Override
        public void write(class_2540 buffer) {
            this.result.write(buffer);
            buffer.method_10817((Enum)RandomType.RANGE);
            buffer.method_10804(this.minCount);
        }

        public Range(ItemOutput result, int minCount) {
            this.result = result;
            this.minCount = minCount;
        }
    }

    private static class Chance
    extends RandomItem {
        private final ItemOutput result;
        private final float chance;

        @Override
        public class_1799 get(Random random) {
            if (this.chance >= 1.0f || random.nextFloat() < this.chance) {
                return this.result.get().method_7972();
            }
            return class_1799.field_8037;
        }

        @Override
        public JsonElement serialize() {
            JsonObject object;
            JsonElement resultElement = this.result.serialize();
            if (this.chance >= 1.0f) {
                return resultElement;
            }
            if (resultElement.isJsonPrimitive()) {
                object = new JsonObject();
                object.add("item", resultElement);
            } else {
                object = resultElement.getAsJsonObject();
            }
            object.addProperty("chance", (Number)Float.valueOf(this.chance));
            return object;
        }

        @Override
        public void write(class_2540 buffer) {
            this.result.write(buffer);
            buffer.method_10817((Enum)RandomType.CHANCE);
            buffer.writeFloat(this.chance);
        }

        public Chance(ItemOutput result, float chance) {
            this.result = result;
            this.chance = chance;
        }
    }

    private static enum RandomType {
        RANGE,
        CHANCE;

    }
}

