/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.spilling.effects;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.shared.TinkerDamageTypes;

public record DamageSpillingEffect(DamageType type, float damage) implements ISpillingEffect
{
    public static final class_2960 ID = TConstruct.getResource("damage");
    public static JsonDeserializer<DamageSpillingEffect> LOADER = (element, classType, context) -> {
        JsonObject json = element.getAsJsonObject();
        String typeName = class_3518.method_15265((JsonObject)json, (String)"damage_type");
        DamageType type = DamageType.byName(typeName);
        if (type == null) {
            throw new JsonSyntaxException("Unknown damage type '" + typeName + "'");
        }
        float damage = class_3518.method_15259((JsonObject)json, (String)"damage_amount");
        return new DamageSpillingEffect(type, damage);
    };

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        class_1282 source = this.type.apply(context);
        ToolAttackUtil.attackEntitySecondary(source, this.damage * scale, context.getTarget(), context.getLivingTarget(), true);
    }

    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = JsonUtils.withType(ID);
        json.addProperty("damage_type", this.type.getName());
        json.addProperty("damage_amount", (Number)Float.valueOf(this.damage));
        return json;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DamageType {
        NORMAL{

            @Override
            public class_1282 apply(ToolAttackContext context) {
                class_1657 player = context.getPlayerAttacker();
                if (player != null) {
                    return player.method_48923().method_48802(player);
                }
                return player.method_48923().method_48812(context.getAttacker());
            }
        }
        ,
        FIRE{

            @Override
            public class_1282 apply(ToolAttackContext context) {
                class_1657 player = context.getPlayerAttacker();
                if (player != null) {
                    return player.method_48923().method_48796(TinkerDamageTypes.PLAYER_ATTACK_FIRE, (class_1297)player);
                }
                return player.method_48923().method_48796(TinkerDamageTypes.MOB_ATTACK_FIRE, (class_1297)context.getAttacker());
            }
        }
        ,
        MAGIC{

            @Override
            public class_1282 apply(ToolAttackContext context) {
                class_1657 player = context.getPlayerAttacker();
                if (player != null) {
                    return player.method_48923().method_48796(TinkerDamageTypes.PLAYER_ATTACK_MAGIC, (class_1297)player);
                }
                return player.method_48923().method_48796(TinkerDamageTypes.MOB_ATTACK_MAGIC, (class_1297)context.getAttacker());
            }
        }
        ,
        EXPLOSION{

            @Override
            public class_1282 apply(ToolAttackContext context) {
                class_1657 player = context.getPlayerAttacker();
                if (player != null) {
                    return player.method_48923().method_48796(TinkerDamageTypes.PLAYER_ATTACK_EXPLOSION, (class_1297)player);
                }
                return player.method_48923().method_48796(TinkerDamageTypes.MOB_ATTACK_EXPLOSION, (class_1297)context.getAttacker());
            }
        }
        ,
        PIERCING{

            @Override
            public class_1282 apply(ToolAttackContext context) {
                class_1657 player = context.getPlayerAttacker();
                if (player != null) {
                    return player.method_48923().method_48796(TinkerDamageTypes.PLAYER_ATTACK_BYPASS_ARMOR, (class_1297)player);
                }
                return player.method_48923().method_48796(TinkerDamageTypes.MOB_ATTACK_BYPASS_ARMOR, (class_1297)context.getAttacker());
            }
        };

        private final String name = this.name().toLowerCase(Locale.US);

        public abstract class_1282 apply(ToolAttackContext var1);

        @Nullable
        public static DamageType byName(String name) {
            for (DamageType type : DamageType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }
}

