/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_3966;
import net.minecraft.class_7923;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.DamageTakenModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.utils.ScalingValue;

public record MobEffectModule(IJsonPredicate<class_1309> predicate, class_1291 effect, ScalingValue level, ScalingValue time) implements DamageTakenModifierHook,
MeleeHitModifierHook,
ProjectileLaunchModifierHook,
ProjectileHitModifierHook,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.DAMAGE_TAKEN, TinkerHooks.MELEE_HIT, TinkerHooks.PROJECTILE_LAUNCH, TinkerHooks.PROJECTILE_HIT);
    public static final GenericLoaderRegistry.IGenericLoader<MobEffectModule> LOADER = new GenericLoaderRegistry.IGenericLoader<MobEffectModule>(){

        public MobEffectModule deserialize(JsonObject json) {
            IJsonPredicate predicate = (IJsonPredicate)LivingEntityPredicate.LOADER.getAndDeserialize(json, "entity");
            class_1291 effect = (class_1291)JsonHelper.getAsEntry((class_2378)class_7923.field_41174, (JsonObject)json, (String)"effect");
            ScalingValue level = ScalingValue.get(json, "level");
            ScalingValue time = ScalingValue.get(json, "time");
            return new MobEffectModule((IJsonPredicate<class_1309>)predicate, effect, level, time);
        }

        public void serialize(MobEffectModule object, JsonObject json) {
            json.add("entity", LivingEntityPredicate.LOADER.serialize(object.predicate));
            json.addProperty("effect", Objects.requireNonNull(class_7923.field_41174.method_10221((Object)object.effect)).toString());
            json.add("level", (JsonElement)object.level.serialize());
            json.add("time", (JsonElement)object.time.serialize());
        }

        public MobEffectModule fromNetwork(class_2540 buffer) {
            IJsonPredicate predicate = (IJsonPredicate)LivingEntityPredicate.LOADER.fromNetwork(buffer);
            class_1291 effect = (class_1291)class_7923.field_41174.method_10200(buffer.method_10816());
            ScalingValue level = ScalingValue.fromNetwork(buffer);
            ScalingValue time = ScalingValue.fromNetwork(buffer);
            return new MobEffectModule((IJsonPredicate<class_1309>)predicate, effect, level, time);
        }

        public void toNetwork(MobEffectModule object, class_2540 buffer) {
            LivingEntityPredicate.LOADER.toNetwork(object.predicate, buffer);
            buffer.method_10804(class_7923.field_41174.method_10206((Object)object.effect));
            object.level.toNetwork(buffer);
            object.time.toNetwork(buffer);
        }
    };

    public static Builder builder(class_1291 effect) {
        return new Builder(effect);
    }

    private void applyEffect(@Nullable class_1309 target, float scaledLevel) {
        if (target == null || !this.predicate.matches((Object)target)) {
            return;
        }
        int level = Math.round(this.level.computeValue(scaledLevel)) - 1;
        if (level < 0) {
            return;
        }
        float duration = this.time.computeValue(scaledLevel);
        if (duration > 0.0f) {
            target.method_6092(new class_1293(this.effect, (int)duration, level));
        }
    }

    @Override
    public void onDamageTaken(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, class_1304 slotType, class_1282 source, float amount, boolean isDirectDamage) {
        class_1297 attacker = source.method_5529();
        if (isDirectDamage && attacker instanceof class_1309) {
            class_1309 living = (class_1309)attacker;
            float scaledLevel = modifier.getEffectiveLevel(tool);
            if (TConstruct.RANDOM.method_43057() < scaledLevel * 0.25f) {
                this.applyEffect(living, scaledLevel);
                ToolDamageUtil.damageAnimated(tool, 1, context.getEntity(), slotType);
            }
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        this.applyEffect(context.getLivingTarget(), modifier.getEffectiveLevel(tool));
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, class_1309 shooter, class_1676 projectile, @Nullable class_1665 arrow, NamespacedNBT persistentData, boolean primary) {
        persistentData.putFloat(modifier.getId(), modifier.getEffectiveLevel(tool));
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, class_1676 projectile, class_3966 hit, @Nullable class_1309 attacker, @Nullable class_1309 target) {
        this.applyEffect(target, persistentData.getFloat(modifier.getId()));
        return false;
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static class Builder {
        private final class_1291 effect;
        private IJsonPredicate<class_1309> entity = LivingEntityPredicate.ANY;
        private ScalingValue level = ScalingValue.flat(1.0f);
        private ScalingValue time = ScalingValue.flat(0.0f);

        public MobEffectModule build() {
            return new MobEffectModule(this.entity, this.effect, this.level, this.time);
        }

        private Builder(class_1291 effect) {
            this.effect = effect;
        }

        public Builder entity(IJsonPredicate<class_1309> entity) {
            this.entity = entity;
            return this;
        }

        public Builder level(ScalingValue level) {
            this.level = level;
            return this;
        }

        public Builder time(ScalingValue time) {
            this.time = time;
            return this;
        }
    }
}

