/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import net.minecraft.class_6862;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;

public class ModifierEntry
implements Comparable<ModifierEntry> {
    public static final Serializer SERIALIZER = new Serializer();
    private final LazyModifier modifier;
    private final int level;

    public ModifierEntry(ModifierId id, int level) {
        this(new LazyModifier(id), level);
    }

    public ModifierEntry(Modifier modifier, int level) {
        this(new LazyModifier(modifier), level);
    }

    public boolean isBound() {
        return this.modifier.isBound();
    }

    public ModifierId getId() {
        return this.modifier.getId();
    }

    public Modifier getModifier() {
        return this.modifier.get();
    }

    public LazyModifier getLazyModifier() {
        return this.modifier;
    }

    public float getEffectiveLevel(IToolContext tool) {
        return this.modifier.get().getEffectiveLevel(tool, this.level);
    }

    public final <T> T getHook(ModifierHook<T> hook) {
        return this.modifier.get().getHook(hook);
    }

    public boolean matches(ModifierId id) {
        return this.modifier.getId().equals((Object)id);
    }

    public boolean matches(Modifier modifier) {
        return this.matches(modifier.getId());
    }

    public boolean matches(class_6862<Modifier> tag) {
        return this.modifier.is(tag);
    }

    @Override
    public int compareTo(ModifierEntry other) {
        int priority2;
        Modifier mod1 = this.getModifier();
        Modifier mod2 = other.getModifier();
        int priority1 = mod1.getPriority();
        if (priority1 != (priority2 = mod2.getPriority())) {
            return Integer.compare(priority2, priority1);
        }
        return mod1.getId().method_12832().compareTo(mod2.getId().method_12832());
    }

    public static ModifierEntry fromJson(JsonObject json) {
        return new ModifierEntry(ModifierId.getFromJson(json, "name"), class_3518.method_15282((JsonObject)json, (String)"level", (int)1));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getId().toString());
        json.addProperty("level", (Number)this.level);
        return json;
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        tag.method_10582("name", this.getId().toString());
        tag.method_10569("level", this.level);
        return tag;
    }

    public static ModifierEntry fromNbt(class_2487 tag) {
        return new ModifierEntry(ModifierId.getFromNbt(tag, "name"), tag.method_10550("level"));
    }

    public static ModifierEntry read(class_2540 buffer) {
        return new ModifierEntry(ModifierId.fromNetwork(buffer), buffer.method_10816());
    }

    public void write(class_2540 buffer) {
        this.getId().toNetwork(buffer);
        buffer.method_10804(this.level);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifierEntry entry = (ModifierEntry)o;
        return this.matches(entry.getId()) && this.level == entry.level;
    }

    public int hashCode() {
        return 31 * this.modifier.hashCode() + Objects.hash(this.level);
    }

    public String toString() {
        return "ModifierEntry{" + this.modifier.getId() + ",level=" + this.level + "}";
    }

    public ModifierEntry(LazyModifier modifier, int level) {
        this.modifier = modifier;
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public ModifierEntry withLevel(int level) {
        return this.level == level ? this : new ModifierEntry(this.modifier, level);
    }

    private static class Serializer
    implements JsonDeserializer<ModifierEntry>,
    JsonSerializer<ModifierEntry> {
        private Serializer() {
        }

        public ModifierEntry deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return ModifierEntry.fromJson(class_3518.method_15295((JsonElement)json, (String)"modifier"));
        }

        public JsonElement serialize(ModifierEntry entry, Type type, JsonSerializationContext context) {
            return entry.toJson();
        }
    }
}

