/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5819;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.RandomMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerTools;

public class AddToolDataFunction
extends class_120 {
    public static final class_2960 ID = TConstruct.getResource("add_tool_data");
    public static final Serializer SERIALIZER = new Serializer();
    private final float damage;
    private final List<RandomMaterial> materials;

    protected AddToolDataFunction(class_5341[] conditionsIn, float damage, List<RandomMaterial> materials) {
        super(conditionsIn);
        this.damage = damage;
        this.materials = materials;
    }

    public static Builder builder() {
        return new Builder();
    }

    public class_5339 method_29321() {
        return (class_5339)TinkerTools.lootAddToolData.get();
    }

    protected class_1799 method_522(class_1799 stack, class_47 context) {
        if (stack.method_31573(TinkerTags.Items.MODIFIABLE)) {
            ToolStack tool = ToolStack.from(stack);
            tool.ensureSlotsBuilt();
            if (tool.getDefinition().isMultipart() && !this.materials.isEmpty()) {
                MaterialNBT.Builder builder = MaterialNBT.builder();
                class_5819 random = context.method_294();
                for (RandomMaterial material : this.materials) {
                    builder.add(material.getMaterial(random));
                }
                tool.setMaterials(builder.build());
            } else {
                tool.rebuildStats();
            }
            if (this.damage > 0.0f) {
                tool.setDamage((int)(tool.getStats().get(ToolStats.DURABILITY).floatValue() * this.damage));
            }
        }
        return stack;
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        private final ImmutableList.Builder<RandomMaterial> materials = ImmutableList.builder();
        private float damage = 0.0f;

        protected Builder() {
        }

        protected Builder getThis() {
            return this;
        }

        public void setDamage(float damage) {
            if (damage < 0.0f || damage > 1.0f) {
                throw new IllegalArgumentException("Damage must be between 0 and 1, given " + damage);
            }
            this.damage = damage;
        }

        public Builder addMaterial(RandomMaterial mat) {
            this.materials.add((Object)mat);
            return this;
        }

        public Builder addMaterial(MaterialId mat) {
            return this.addMaterial(RandomMaterial.fixed(mat));
        }

        public class_117 method_515() {
            return new AddToolDataFunction(this.method_526(), this.damage, (List<RandomMaterial>)this.materials.build());
        }
    }

    private static class Serializer
    extends class_120.class_123<AddToolDataFunction> {
        private Serializer() {
        }

        public void serialize(JsonObject json, AddToolDataFunction loot, JsonSerializationContext context) {
            super.method_529(json, (class_120)loot, context);
            if (loot.damage > 0.0f) {
                json.addProperty("damage_percent", (Number)Float.valueOf(loot.damage));
            }
            if (!loot.materials.isEmpty()) {
                JsonArray array = new JsonArray();
                for (RandomMaterial material : loot.materials) {
                    array.add((JsonElement)material.serialize());
                }
                json.add("materials", (JsonElement)array);
            }
        }

        public AddToolDataFunction deserialize(JsonObject object, JsonDeserializationContext context, class_5341[] conditions) {
            float damage = class_3518.method_15277((JsonObject)object, (String)"damage_percent", (float)0.0f);
            if (damage < 0.0f || damage > 1.0f) {
                throw new JsonSyntaxException("damage_percent must be between 0 and 1, given " + damage);
            }
            List materials = Collections.emptyList();
            if (object.has("materials")) {
                materials = JsonHelper.parseList((JsonObject)object, (String)"materials", RandomMaterial::deserialize);
            }
            return new AddToolDataFunction(conditions, damage, materials);
        }
    }
}

