/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data;

import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.impl.datagen.FabricTagBuilder;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3495;
import net.minecraft.class_3497;
import net.minecraft.class_6862;
import net.minecraft.class_7403;
import net.minecraft.class_7475;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import slimeknights.mantle.data.GenericDataProvider;

public abstract class AbstractTagProvider<T>
extends GenericDataProvider {
    private static final org.apache.logging.log4j.Logger log = LogManager.getLogger(AbstractTagProvider.class);
    private final String modId;
    private final Predicate<class_2960> staticValuePredicate;
    private final Function<T, class_2960> keyGetter;
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;
    protected final Map<class_2960, class_3495> builders = Maps.newLinkedHashMap();

    protected AbstractTagProvider(FabricDataOutput output, String modId, String folder, Function<T, class_2960> keyGetter, Predicate<class_2960> staticValuePredicate, ExistingFileHelper existingFileHelper) {
        super(output, class_3264.field_14190, folder);
        this.modId = modId;
        this.keyGetter = keyGetter;
        this.staticValuePredicate = staticValuePredicate;
        this.existingFileHelper = existingFileHelper;
        this.resourceType = new ExistingFileHelper.ResourceType(class_3264.field_14190, ".json", folder);
    }

    protected abstract void addTags();

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.builders.clear();
        this.addTags();
        ArrayList futures = new ArrayList();
        this.builders.forEach((id, builder) -> {
            List tags = builder.method_26782();
            List<class_3497> list = tags.stream().filter(value -> !value.method_32832(this.staticValuePredicate, this.builders::containsKey)).filter(this::missing).toList();
            futures.add(this.saveThing(cache, (class_2960)id, class_7475.field_39269.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new class_7475(tags, false)).getOrThrow(false, arg_0 -> ((Logger)field_40831).error(arg_0))));
        });
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private boolean missing(class_3497 entry) {
        return !this.existingFileHelper.exists(entry.field_15584, this.resourceType);
    }

    protected TagAppender<T> tag(class_6862<T> pTag) {
        return new TagAppender<T>(this.modId, this.getOrCreateRawBuilder(pTag), this.keyGetter);
    }

    protected class_3495 getOrCreateRawBuilder(class_6862<T> pTag) {
        return this.builders.computeIfAbsent(pTag.comp_327(), location -> {
            this.existingFileHelper.trackGenerated(location, this.resourceType);
            return class_3495.method_26778();
        });
    }

    public record TagAppender<T>(String modID, class_3495 internalBuilder, Function<T, class_2960> keyGetter) {
        public TagAppender<T> add(T value) {
            this.internalBuilder.method_26784(this.keyGetter.apply(value));
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> add(T ... values) {
            Stream.of(values).map(this.keyGetter).forEach(arg_0 -> ((class_3495)this.internalBuilder).method_26784(arg_0));
            return this;
        }

        public TagAppender<T> add(class_2960 ... ids) {
            for (class_2960 id : ids) {
                this.internalBuilder.method_26784(id);
            }
            return this;
        }

        public TagAppender<T> addOptional(class_2960 ... ids) {
            for (class_2960 id : ids) {
                this.internalBuilder.method_34891(id);
            }
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> addTag(class_6862<T> ... tags) {
            for (class_6862<T> tag : tags) {
                this.internalBuilder.method_26787(tag.comp_327());
            }
            return this;
        }

        public TagAppender<T> addOptionalTag(class_2960 ... tags) {
            for (class_2960 tag : tags) {
                this.internalBuilder.method_34892(tag);
            }
            return this;
        }

        public TagAppender<T> replace() {
            return this.replace(true);
        }

        public TagAppender<T> replace(boolean value) {
            ((FabricTagBuilder)this.internalBuilder).fabric_setReplace(value);
            return this;
        }

        public TagAppender<T> remove(T entry) {
            return this.remove(this.keyGetter.apply(entry));
        }

        @SafeVarargs
        public final TagAppender<T> remove(T first, T ... entries) {
            this.remove(first);
            for (T entry : entries) {
                this.remove(entry);
            }
            return this;
        }

        public TagAppender<T> remove(class_2960 location) {
            throw new RuntimeException("TODO: Port unsupported!");
        }

        public TagAppender<T> remove(class_2960 first, class_2960 ... locations) {
            this.remove(first);
            for (class_2960 location : locations) {
                this.remove(location);
            }
            return this;
        }

        public TagAppender<T> remove(class_6862<T> tag) {
            throw new RuntimeException("TODO: Port unsupported!");
        }

        @SafeVarargs
        public final TagAppender<T> remove(class_6862<T> first, class_6862<T> ... tags) {
            this.remove(first);
            for (class_6862<T> tag : tags) {
                this.remove(tag);
            }
            return this;
        }
    }
}

