/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import io.github.fabricators_of_create.porting_lib.event.client.TextureStitchCallback;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4730;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DynamicTextureLoader {
    private static final Logger log = LogManager.getLogger(DynamicTextureLoader.class);
    private static final Map<class_2960, Boolean> EXISTING_TEXTURES = new HashMap<class_2960, Boolean>();
    private static final Set<class_2960> SKIPPED_TEXTURES = new HashSet<class_2960>();

    public static void clearCache() {
        EXISTING_TEXTURES.clear();
        SKIPPED_TEXTURES.clear();
    }

    public static void init() {
        TextureStitchCallback.POST.register(e -> DynamicTextureLoader.clearCache());
    }

    public static boolean textureExists(class_3300 manager, class_2960 location) {
        Boolean found = EXISTING_TEXTURES.get(location);
        if (found == null) {
            found = manager.method_14486(new class_2960(location.method_12836(), "textures/" + location.method_12832() + ".png")).isPresent();
            EXISTING_TEXTURES.put(location, found);
        }
        return found;
    }

    public static void logMissingTexture(class_2960 location) {
        if (!SKIPPED_TEXTURES.contains(location)) {
            SKIPPED_TEXTURES.add(location);
            log.debug("Skipping loading texture '{}' as it does not exist in the resource pack", (Object)location);
        }
    }

    public static Predicate<class_4730> getTextureAdder(Collection<class_4730> allTextures, boolean logMissingTextures) {
        class_3300 manager = class_310.method_1551().method_1478();
        return mat -> {
            class_2960 loc = mat.method_24147();
            if (!class_1723.field_21668.equals((Object)mat.method_24144()) || DynamicTextureLoader.textureExists(manager, loc)) {
                allTextures.add((class_4730)mat);
                return true;
            }
            if (logMissingTextures) {
                DynamicTextureLoader.logMissingTexture(loc);
            }
            return false;
        };
    }
}

