/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.fluids.util;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;

public class ConstantFluidContainerWrapper
extends SnapshotParticipant<Boolean>
implements SingleSlotStorage<FluidVariant> {
    private final FluidStack fluid;
    private boolean empty = false;
    @Nonnull
    protected class_1799 container;
    @Nonnull
    protected ContainerItemContext context;

    public ConstantFluidContainerWrapper(FluidStack fluid, class_1799 container, ContainerItemContext context) {
        this.fluid = fluid;
        this.container = container;
        this.context = context;
    }

    public long getCapacity() {
        return this.fluid.getAmount();
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return 0L;
    }

    public long extract(FluidVariant resource, long maxDrain, TransactionContext transaction) {
        if (this.empty || maxDrain < this.fluid.getAmount()) {
            return 0L;
        }
        this.updateSnapshots(transaction);
        if (this.context.exchange(ItemVariant.of((class_1799)this.container.getRecipeRemainder()), 1L, transaction) == 1L) {
            this.empty = true;
            return this.fluid.getAmount();
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.empty ? true : this.fluid.getType().isBlank();
    }

    public FluidVariant getResource() {
        return this.empty ? FluidVariant.blank() : this.fluid.getType();
    }

    public long getAmount() {
        return this.empty ? 0L : this.fluid.getAmount();
    }

    protected Boolean createSnapshot() {
        return this.empty;
    }

    protected void readSnapshot(Boolean snapshot) {
        this.empty = snapshot;
    }

    @Nonnull
    public class_1799 getContainer() {
        return this.container;
    }

    @Nonnull
    public ContainerItemContext getContext() {
        return this.context;
    }
}

