/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class FormationsBlockAgeProcessor
extends class_3491
implements FormationsStructureProcessor {
    public static final Codec<FormationsBlockAgeProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("mossy_chance", (Object)Float.valueOf(0.3f)).forGetter(p -> Float.valueOf(p.mossiness)), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("degradation_chance", (Object)Float.valueOf(0.15f)).forGetter(p -> Float.valueOf(p.degradation)), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("disintegration_chance", (Object)Float.valueOf(0.05f)).forGetter(p -> Float.valueOf(p.disintegration))).apply((Applicative)instance, FormationsBlockAgeProcessor::new));
    private static final Set<class_2248> DISINTEGRATABLE_BLOCKS = Set.of(class_2246.field_10056, class_2246.field_10392, class_2246.field_10131, class_2246.field_10252, class_2246.field_10416, class_2246.field_10552, class_2246.field_10445, class_2246.field_10596, class_2246.field_10351, class_2246.field_10625, class_2246.field_10065, class_2246.field_10173, class_2246.field_10024, class_2246.field_9989, class_2246.field_10207, class_2246.field_10405, class_2246.field_9990, class_2246.field_9979, class_2246.field_10142, class_2246.field_10007, class_2246.field_10630, class_2246.field_10361, class_2246.field_10292, class_2246.field_10344, class_2246.field_10420, class_2246.field_10624, class_2246.field_10413, class_2246.field_10518, class_2246.field_10117);
    private static final Map<class_2248, class_2248> BLOCK_TO_STAIR = Map.of(class_2246.field_10056, class_2246.field_10392, class_2246.field_10445, class_2246.field_10596, class_2246.field_9979, class_2246.field_10142, class_2246.field_10344, class_2246.field_10142, class_2246.field_28900, class_2246.field_28901);
    private static final Map<class_2248, class_2248> STAIR_TO_SLAB = Map.of(class_2246.field_10392, class_2246.field_10131, class_2246.field_10596, class_2246.field_10351, class_2246.field_10142, class_2246.field_10007, class_2246.field_10420, class_2246.field_10624, class_2246.field_28901, class_2246.field_28902);
    private static final Map<class_2248, List<class_2248>> BLOCK_TO_MOSSINESS = Map.of(class_2246.field_10056, List.of(class_2246.field_10065, class_2246.field_10416), class_2246.field_10392, List.of(class_2246.field_10173), class_2246.field_10131, List.of(class_2246.field_10024), class_2246.field_10252, List.of(class_2246.field_10059), class_2246.field_10445, List.of(class_2246.field_9989), class_2246.field_10596, List.of(class_2246.field_10207), class_2246.field_10351, List.of(class_2246.field_10405), class_2246.field_10625, List.of(class_2246.field_9990), class_2246.field_28900, List.of(class_2246.field_29222), class_2246.field_23874, List.of(class_2246.field_23875));
    private final float mossiness;
    private final float degradation;
    private final float disintegration;

    public FormationsBlockAgeProcessor(float mossiness, float degradation, float disintegration) {
        this.mossiness = mossiness;
        this.degradation = degradation;
        this.disintegration = disintegration;
    }

    public FormationsBlockAgeProcessor() {
        this(0.3f, 0.15f, 0.05f);
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, class_2338 pos, class_4538 level, class_2338 piecePosition, class_2338 structurePosition, class_3492 placeSettings, Map<class_2338, BlockInstance> pieceBlocks) {
        class_5819 random = placeSettings.method_15115(pos);
        class_2680 state = block.state();
        if (DISINTEGRATABLE_BLOCKS.contains(state.method_26204()) && random.method_43057() < this.disintegration) {
            return BlockInstance.NOTHING;
        }
        if (BLOCK_TO_STAIR.containsKey(state.method_26204()) && random.method_43057() < this.degradation) {
            if ((state = BLOCK_TO_STAIR.get(state.method_26204()).method_34725(state)).method_28498((class_2769)class_2741.field_12481)) {
                state = (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.class_2353.field_11062.method_10183(random));
            }
            if (state.method_28498((class_2769)class_2741.field_12518)) {
                state = (class_2680)state.method_11657((class_2769)class_2741.field_12518, (Comparable)(random.method_43056() ? class_2760.field_12619 : class_2760.field_12617));
            }
        }
        if (STAIR_TO_SLAB.containsKey(state.method_26204()) && random.method_43057() < this.degradation) {
            boolean topHalf = state.method_28498((class_2769)class_2741.field_12518) ? state.method_11654((class_2769)class_2741.field_12518) == class_2760.field_12619 : random.method_43056();
            state = STAIR_TO_SLAB.get(state.method_26204()).method_34725(state);
            if (state.method_28498((class_2769)class_2741.field_12485)) {
                state = (class_2680)state.method_11657((class_2769)class_2741.field_12485, (Comparable)(topHalf ? class_2771.field_12679 : class_2771.field_12681));
            }
        }
        if (BLOCK_TO_MOSSINESS.containsKey(state.method_26204()) && random.method_43057() < this.mossiness) {
            List<class_2248> options = BLOCK_TO_MOSSINESS.get(state.method_26204());
            state = options.get(random.method_43048(options.size())).method_34725(state);
        }
        if (state == block.state()) {
            return block;
        }
        return new BlockInstance(state, state.method_27852(block.state().method_26204()) ? block.nbt() : null);
    }

    protected class_3828<?> method_16772() {
        return FormationsStructures.BLOCK_AGE_PROCESSOR;
    }
}

