/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hexnowloading.dungeonnowloading.registry.DNLProcessors;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class WeightedListProcessor
extends class_3491 {
    public static final Codec<WeightedListProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("input_block").forGetter(config -> config.input_block), (App)Codec.mapPair((MapCodec)class_2680.field_24734.fieldOf("blockstate"), (MapCodec)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight")).codec().listOf().fieldOf("weighted_list_of_replacement_blocks").forGetter(processor -> processor.weightedReplacementBlocks)).apply((Applicative)instance, instance.stable(WeightedListProcessor::new)));
    private final List<Pair<class_2680, Integer>> weightedReplacementBlocks;
    private final class_2248 input_block;

    public WeightedListProcessor(class_2248 input_block, List<Pair<class_2680, Integer>> weightedReplacementBlocks) {
        this.input_block = input_block;
        this.weightedReplacementBlocks = weightedReplacementBlocks;
    }

    @Nullable
    public class_3499.class_3501 method_15110(class_4538 levelReader, class_2338 jigsawPiecePos, class_2338 jigsawPieceBottomCenterPos, class_3499.class_3501 blockInfoLocal, class_3499.class_3501 blockInfoGlobal, class_3492 settings) {
        if (blockInfoGlobal.comp_1342().method_26204() == this.input_block) {
            class_2680 replacementBlock;
            double totalWeight = 0.0;
            class_5819 randomSource = settings.method_15115(blockInfoGlobal.comp_1341());
            if (this.weightedReplacementBlocks.size() == 1) {
                replacementBlock = (class_2680)this.weightedReplacementBlocks.get(0).getFirst();
            } else {
                int index;
                for (Pair<class_2680, Integer> pair : this.weightedReplacementBlocks) {
                    totalWeight += (double)((Integer)pair.getSecond()).intValue();
                }
                double randomWeightPicked = (double)randomSource.method_43057() * totalWeight;
                for (index = 0; index < this.weightedReplacementBlocks.size() - 1 && !((randomWeightPicked -= (double)((Integer)this.weightedReplacementBlocks.get(index).getSecond()).intValue()) <= 0.0); ++index) {
                }
                replacementBlock = (class_2680)this.weightedReplacementBlocks.get(index).getFirst();
            }
            blockInfoGlobal = new class_3499.class_3501(blockInfoGlobal.comp_1341(), replacementBlock, blockInfoGlobal.comp_1343());
        }
        return blockInfoGlobal;
    }

    protected class_3828<?> method_16772() {
        return DNLProcessors.WEIGHTED_LIST_PROCESSOR.get();
    }
}

