/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.registration.util;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2405;
import net.minecraft.class_5321;
import net.minecraft.class_6328;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7655;
import net.minecraft.class_7784;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@class_6328
public class DatapackRegistryGenerator
implements class_2405 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_7784 output;
    private final CompletableFuture<class_7225.class_7874> registries;
    private final Predicate<class_7655.class_7657<?>> predicate;

    public DatapackRegistryGenerator(class_7784 output, CompletableFuture<class_7225.class_7874> lookup, Predicate<class_7655.class_7657<?>> predicate) {
        this.registries = lookup;
        this.output = output;
        this.predicate = predicate;
    }

    public CompletableFuture<?> method_10319(class_7403 output) {
        return this.registries.thenCompose(lookup -> {
            class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)lookup);
            return CompletableFuture.allOf((CompletableFuture[])class_7655.field_39968.stream().filter(this.predicate).flatMap(arg_0 -> this.lambda$run$0(output, lookup, (DynamicOps)ops, arg_0)).toArray(CompletableFuture[]::new));
        });
    }

    private <T> Optional<CompletableFuture<?>> dumpRegistryCap(class_7403 output, class_7225.class_7874 lookup, DynamicOps<JsonElement> ops, class_7655.class_7657<T> data) {
        class_5321 registryKey = data.comp_985();
        return lookup.method_46759(registryKey).map(registry -> {
            class_7784.class_7489 pathProvider = this.output.method_45973(class_7784.class_7490.field_39367, registryKey.method_29177().method_12832());
            return CompletableFuture.allOf((CompletableFuture[])registry.method_42017().map(value -> DatapackRegistryGenerator.dumpValue(pathProvider.method_44107(value.method_40237().method_29177()), output, ops, data.comp_986(), value.comp_349())).toArray(CompletableFuture[]::new));
        });
    }

    private static <E> CompletableFuture<?> dumpValue(Path path, class_7403 output, DynamicOps<JsonElement> ops, Encoder<E> codec, E value) {
        Optional encoded = codec.encodeStart(ops, value).resultOrPartial(error -> LOGGER.error("Couldn't serialize element {}: {}", (Object)path, error));
        return encoded.isPresent() ? class_2405.method_10320((class_7403)output, (JsonElement)((JsonElement)encoded.get()), (Path)path) : CompletableFuture.completedFuture(null);
    }

    public String method_10321() {
        return this.predicate + " registry";
    }

    private /* synthetic */ Stream lambda$run$0(class_7403 output, class_7225.class_7874 lookup, DynamicOps ops, class_7655.class_7657 data) {
        return this.dumpRegistryCap(output, lookup, (DynamicOps<JsonElement>)ops, data).stream();
    }
}

