/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.boss;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.logging.LogUtils;
import dev.hexnowloading.dungeonnowloading.block.ChaosSpawnerBarrierCenterBlock;
import dev.hexnowloading.dungeonnowloading.block.ChaosSpawnerBarrierEdgeBlock;
import dev.hexnowloading.dungeonnowloading.block.ChaosSpawnerBarrierVertexBlock;
import dev.hexnowloading.dungeonnowloading.block.ChaosSpawnerEdgeBlock;
import dev.hexnowloading.dungeonnowloading.block.ChaosSpawnerVertexBlock;
import dev.hexnowloading.dungeonnowloading.config.BossConfig;
import dev.hexnowloading.dungeonnowloading.entity.ai.ChaosSpawnerLookAtPlayerGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.ChaosSpawnerPlayerTargetGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.ChaosSpawnerPushGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.ChaosSpawnerRandomLookAroundGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.ChaosSpawnerResetGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.ChaosSpawnerShootGhostBulletGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.ChaosSpawnerSummonMobGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.EntityBodyRotationControl;
import dev.hexnowloading.dungeonnowloading.entity.misc.SpecialItemEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.util.EntityScale;
import dev.hexnowloading.dungeonnowloading.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.util.PlayerSupporterEntity;
import dev.hexnowloading.dungeonnowloading.util.UniqueDeathAnimationEntity;
import dev.hexnowloading.dungeonnowloading.util.WeightedRandomBag;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1330;
import net.minecraft.class_1352;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_7094;
import net.minecraft.class_8103;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ChaosSpawnerEntity
extends class_1588
implements class_1569,
UniqueDeathAnimationEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2940<Boolean> DATA_FLAGS_ID = class_2945.method_12791(ChaosSpawnerEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<State> DATA_STATE;
    private static final class_2940<class_2338> SPAWN_POINT;
    private static final class_2940<Integer> PHASE;
    private static final class_2940<Integer> AWAKENING_TICKS;
    private static final class_2940<Integer> ATTACK_TICK;
    private static final class_2940<Integer> ACTIVE_RANGE;
    private static final class_2940<Integer> PLAYER_COUNT;
    private static final class_2940<Integer> BARRIER_NORTH_TICK;
    private static final class_2940<Integer> BARRIER_EAST_TICK;
    private static final class_2940<Integer> BARRIER_SOUTH_TICK;
    private static final class_2940<Integer> BARRIER_WEST_TICK;
    private static final class_2940<Integer> BARRIER_UP_TICK;
    private static final class_2940<Integer> BARRIER_DOWN_TICK;
    private static final class_2940<Optional<UUID>> PLAYER_UUID;
    private static final byte TRIGGER_SLEEP_ANIMATION_BYTE = 70;
    private static final byte TRIGGER_WAKE_UP_ANIMATION_BYTE = 71;
    private static final byte TRIGGER_SMASH_ATTACK_ANIMATION_BYTE = 72;
    private static final byte TRIGGER_RANGE_ATTACK_ANIMATION_BYTE = 73;
    private static final byte TRIGGER_RANGE_BURST_ATTACK_ANIMATION_BYTE = 74;
    private static final byte TRIGGER_SUMMON_ANIMATION_BYTE = 75;
    private static final byte TRIGGER_DEATH_ANIMATION_BYTE = 76;
    private static final byte TRIGGER_ANIMATION_STOP_BYTE = 77;
    protected int attackTickCount;
    private int contactAttackTickCount;
    private int deathAnimationTickCount;
    private int barrierCheckTickCount;
    private Set<UUID> playerUUIDs;
    private UUID currentPlayerUUID;
    private List<class_1657> pushTargets;
    public final class_7094 awakeningAnimationState = new class_7094();
    public final class_7094 sleepingAnimationState = new class_7094();
    public final class_7094 smashAttackAnimationState = new class_7094();
    public final class_7094 rangeAttackAnimationState = new class_7094();
    public final class_7094 summonAnimationState = new class_7094();
    public final class_7094 rangeBurstAttackAnimationState = new class_7094();
    public final class_7094 deathAnimationState = new class_7094();
    private final class_3213 bossEvent;
    private class_1282 killedDamageSource;
    private static final ImmutableList<class_2338> FRAME_POSITIONS;
    private ImmutableList<class_2338> FRAME_POS_NORTH = ImmutableList.of((Object)new class_2338(0, 2, -2), (Object)new class_2338(-1, 2, -2), (Object)new class_2338(-2, 2, -2), (Object)new class_2338(-2, 1, -2), (Object)new class_2338(-2, 0, -2), (Object)new class_2338(-2, -1, -2), (Object)new class_2338(-2, -2, -2), (Object)new class_2338(-1, -2, -2), (Object)new class_2338(0, -2, -2), (Object)new class_2338(1, -2, -2), (Object)new class_2338(2, -2, -2), (Object)new class_2338(2, -1, -2), (Object[])new class_2338[]{new class_2338(2, 0, -2), new class_2338(2, 1, -2), new class_2338(2, 2, -2), new class_2338(1, 2, -2)});
    private ImmutableList<class_2338> FRAME_POS_EAST = ImmutableList.of((Object)new class_2338(2, 2, 0), (Object)new class_2338(2, 2, -1), (Object)new class_2338(2, 2, -2), (Object)new class_2338(2, 1, -2), (Object)new class_2338(2, 0, -2), (Object)new class_2338(2, -1, -2), (Object)new class_2338(2, -2, -2), (Object)new class_2338(2, -2, -1), (Object)new class_2338(2, -2, 0), (Object)new class_2338(2, -2, 1), (Object)new class_2338(2, -2, 2), (Object)new class_2338(2, -1, 2), (Object[])new class_2338[]{new class_2338(2, 0, 2), new class_2338(2, 1, 2), new class_2338(2, 2, 2), new class_2338(2, 2, 1)});
    private ImmutableList<class_2338> FRAME_POS_SOUTH = ImmutableList.of((Object)new class_2338(0, 2, 2), (Object)new class_2338(1, 2, 2), (Object)new class_2338(2, 2, 2), (Object)new class_2338(2, 1, 2), (Object)new class_2338(2, 0, 2), (Object)new class_2338(2, -1, 2), (Object)new class_2338(2, -2, 2), (Object)new class_2338(1, -2, 2), (Object)new class_2338(0, -2, 2), (Object)new class_2338(-1, -2, 2), (Object)new class_2338(-2, -2, 2), (Object)new class_2338(-2, -1, 2), (Object[])new class_2338[]{new class_2338(-2, 0, 2), new class_2338(-2, 1, 2), new class_2338(-2, 2, 2), new class_2338(-1, 2, 2)});
    private ImmutableList<class_2338> FRAME_POS_WEST = ImmutableList.of((Object)new class_2338(-2, 2, 0), (Object)new class_2338(-2, 2, 1), (Object)new class_2338(-2, 2, 2), (Object)new class_2338(-2, 1, 2), (Object)new class_2338(-2, 0, 2), (Object)new class_2338(-2, -1, 2), (Object)new class_2338(-2, -2, 2), (Object)new class_2338(-2, -2, 1), (Object)new class_2338(-2, -2, 0), (Object)new class_2338(-2, -2, -1), (Object)new class_2338(-2, -2, -2), (Object)new class_2338(-2, -1, -2), (Object[])new class_2338[]{new class_2338(-2, 0, -2), new class_2338(-2, 1, -2), new class_2338(-2, 2, -2), new class_2338(-2, 2, -1)});
    private ImmutableList<class_2338> FRAME_POS_UP = ImmutableList.of((Object)new class_2338(0, 2, -2), (Object)new class_2338(1, 2, -2), (Object)new class_2338(2, 2, -2), (Object)new class_2338(2, 2, -1), (Object)new class_2338(2, 2, 0), (Object)new class_2338(2, 2, 1), (Object)new class_2338(2, 2, 2), (Object)new class_2338(1, 2, 2), (Object)new class_2338(0, 2, 2), (Object)new class_2338(-1, 2, 2), (Object)new class_2338(-2, 2, 2), (Object)new class_2338(-2, 2, 1), (Object[])new class_2338[]{new class_2338(-2, 2, 0), new class_2338(-2, 2, -1), new class_2338(-2, 2, -2), new class_2338(-1, 2, -2)});
    private ImmutableList<class_2338> FRAME_POS_DOWN = ImmutableList.of((Object)new class_2338(0, -2, -2), (Object)new class_2338(1, -2, -2), (Object)new class_2338(2, -2, -2), (Object)new class_2338(2, -2, -1), (Object)new class_2338(2, -2, 0), (Object)new class_2338(2, -2, 1), (Object)new class_2338(2, -2, 2), (Object)new class_2338(1, -2, 2), (Object)new class_2338(0, -2, 2), (Object)new class_2338(-1, -2, 2), (Object)new class_2338(-2, -2, 2), (Object)new class_2338(-2, -2, 1), (Object[])new class_2338[]{new class_2338(-2, -2, 0), new class_2338(-2, -2, -1), new class_2338(-2, -2, -2), new class_2338(-1, -2, -2)});

    public ChaosSpawnerEntity(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5971();
        this.bossEvent = (class_3213)new class_3213(this.method_5476(), class_1259.class_1260.field_5783, class_1259.class_1261.field_5795).method_5406(true);
        this.field_6194 = 500;
        this.playerUUIDs = Sets.newHashSet();
        this.currentPlayerUUID = UUID.randomUUID();
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 300.0).method_26868(class_5134.field_23717, 35.0).method_26867(class_5134.field_23720).method_26868(class_5134.field_23719, (double)0.23f).method_26868(class_5134.field_23721, 20.0).method_26868(class_5134.field_23725, 8.0).method_26868(class_5134.field_23718, 1.0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new ChaosSpawnerResetGoal(this, this.getFollowDistance()));
        this.field_6201.method_6277(2, (class_1352)new ChaosSpawnerSummonMobGoal(this));
        this.field_6201.method_6277(2, (class_1352)new ChaosSpawnerShootGhostBulletGoal(this));
        this.field_6201.method_6277(2, (class_1352)new ChaosSpawnerPushGoal(this));
        this.field_6201.method_6277(2, (class_1352)new ChaosSpawnerLookAtPlayerGoal(this, class_1657.class, 30.0f, 1.0f, false));
        this.field_6201.method_6277(8, (class_1352)new ChaosSpawnerRandomLookAroundGoal(this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new ChaosSpawnerPlayerTargetGoal(this, this.getFollowDistance()));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1308.class, 5, false, false, c -> c instanceof PlayerSupporterEntity));
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        return super.method_5965(level);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SPAWN_POINT, (Object)class_2338.field_10980);
        this.field_6011.method_12784(DATA_STATE, (Object)State.IDLE);
        this.field_6011.method_12784(PHASE, (Object)0);
        this.field_6011.method_12784(DATA_FLAGS_ID, (Object)false);
        this.field_6011.method_12784(AWAKENING_TICKS, (Object)0);
        this.field_6011.method_12784(ATTACK_TICK, (Object)0);
        this.field_6011.method_12784(PLAYER_COUNT, (Object)0);
        this.field_6011.method_12784(BARRIER_NORTH_TICK, (Object)-1);
        this.field_6011.method_12784(BARRIER_EAST_TICK, (Object)-1);
        this.field_6011.method_12784(BARRIER_SOUTH_TICK, (Object)-1);
        this.field_6011.method_12784(BARRIER_WEST_TICK, (Object)-1);
        this.field_6011.method_12784(BARRIER_UP_TICK, (Object)-1);
        this.field_6011.method_12784(BARRIER_DOWN_TICK, (Object)-1);
    }

    public void method_5652(@NotNull class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10569("SpawnPointX", this.getSpawnPointPos().method_10263());
        compoundTag.method_10569("SpawnPointY", this.getSpawnPointPos().method_10264());
        compoundTag.method_10569("SpawnPointZ", this.getSpawnPointPos().method_10260());
        compoundTag.method_10569("Phase", ((Integer)this.field_6011.method_12789(PHASE)).intValue());
        compoundTag.method_10569("AwakeningTicks", ((Integer)this.field_6011.method_12789(AWAKENING_TICKS)).intValue());
        compoundTag.method_10569("AttackTicks", this.attackTickCount);
        compoundTag.method_10569("PlayerCount", ((Integer)this.field_6011.method_12789(PLAYER_COUNT)).intValue());
        compoundTag.method_10569("BarrierNorthTicks", ((Integer)this.field_6011.method_12789(BARRIER_NORTH_TICK)).intValue());
        compoundTag.method_10569("BarrierEastTicks,", ((Integer)this.field_6011.method_12789(BARRIER_EAST_TICK)).intValue());
        compoundTag.method_10569("BarrierSouthTicks,", ((Integer)this.field_6011.method_12789(BARRIER_SOUTH_TICK)).intValue());
        compoundTag.method_10569("BarrierWestTicks,", ((Integer)this.field_6011.method_12789(BARRIER_WEST_TICK)).intValue());
        compoundTag.method_10569("BarrierUpTicks,", ((Integer)this.field_6011.method_12789(BARRIER_UP_TICK)).intValue());
        compoundTag.method_10569("BarrierDownTicks,", ((Integer)this.field_6011.method_12789(BARRIER_DOWN_TICK)).intValue());
        class_2499 listTag = new class_2499();
        class_2487 uuidCompoundTag = new class_2487();
        Iterator<UUID> var = this.playerUUIDs.iterator();
        int i = 0;
        while (var.hasNext()) {
            listTag.add((Object)uuidCompoundTag);
            uuidCompoundTag.method_25927("PlayerUUID" + i, var.next());
            ++i;
        }
        compoundTag.method_10566("PlayerUUIDs", (class_2520)listTag);
        System.out.println(this.playerUUIDs);
    }

    public void method_5749(@NotNull class_2487 compoundTag) {
        super.method_5749(compoundTag);
        int i = compoundTag.method_10550("SpawnPointX");
        int j = compoundTag.method_10550("SpawnPointY");
        int k = compoundTag.method_10550("SpawnPointZ");
        this.field_6011.method_12778(SPAWN_POINT, (Object)new class_2338(i, j, k));
        this.field_6011.method_12778(AWAKENING_TICKS, (Object)compoundTag.method_10550("AwakeningTicks"));
        this.field_6011.method_12778(PLAYER_COUNT, (Object)compoundTag.method_10550("PlayerCount"));
        this.field_6011.method_12778(BARRIER_NORTH_TICK, (Object)compoundTag.method_10550("BarrierNorthTicks"));
        this.field_6011.method_12778(BARRIER_EAST_TICK, (Object)compoundTag.method_10550("BarrierEastTicks"));
        this.field_6011.method_12778(BARRIER_SOUTH_TICK, (Object)compoundTag.method_10550("BarrierSouthTicks"));
        this.field_6011.method_12778(BARRIER_WEST_TICK, (Object)compoundTag.method_10550("BarrierWestTicks"));
        this.field_6011.method_12778(BARRIER_UP_TICK, (Object)compoundTag.method_10550("BarrierUpTicks"));
        this.field_6011.method_12778(BARRIER_DOWN_TICK, (Object)compoundTag.method_10550("BarrierDownTicks"));
        this.attackTickCount = compoundTag.method_10550("AttackTicks");
        int phase = compoundTag.method_10550("Phase");
        if (phase < 1) {
            this.field_6011.method_12778(DATA_STATE, (Object)State.SLEEPING);
            this.field_6011.method_12778(PHASE, (Object)0);
        } else {
            this.field_6011.method_12778(PHASE, (Object)phase);
        }
        if (this.method_16914()) {
            this.bossEvent.method_5413(this.method_5476());
        }
        if (compoundTag.method_10573("PlayerUUIDs", 9)) {
            class_2499 listTag = compoundTag.method_10554("PlayerUUIDs", 10);
            for (int a = 0; a < listTag.size(); ++a) {
                class_2487 compoundTag1 = listTag.method_10602(a);
                this.playerUUIDs.add(compoundTag1.method_25926("PlayerUUID" + a));
            }
        }
    }

    public void method_31471(@NotNull class_2604 clientboundAddEntityPacket) {
        super.method_31471(clientboundAddEntityPacket);
        this.field_6283 = 0.0f;
        this.field_6220 = 0.0f;
    }

    @NotNull
    protected class_1330 method_5963() {
        return new EntityBodyRotationControl((class_1308)this);
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossEvent.method_5413(this.method_5476());
    }

    public boolean method_5740() {
        return true;
    }

    public class_243 method_18798() {
        return class_243.field_1353;
    }

    public void method_5837(@NotNull class_3222 player) {
        super.method_5837(player);
        this.bossEvent.method_14088(player);
        if ((Integer)this.field_6011.method_12789(PHASE) == 0) {
            this.disableBossBar();
        }
    }

    public void method_5742(@NotNull class_3222 player) {
        super.method_5742(player);
        this.bossEvent.method_14089(player);
    }

    public void startBossFight() {
        if (this.method_5805() && (Integer)this.field_6011.method_12789(PHASE) < 1 && this.getState() != State.AWAKENING) {
            class_238 bossArena = new class_238(this.method_24515()).method_1014(this.getFollowDistance());
            List players = this.method_37908().method_18467(class_3222.class, bossArena);
            for (class_3222 p : players) {
                this.playerUUIDs.add(p.method_5667());
            }
            int playerCount = players.size();
            EntityScale.scaleBossHealth((class_1309)this, playerCount);
            EntityScale.scaleBossAttack((class_1309)this, playerCount);
            this.field_6011.method_12778(PLAYER_COUNT, (Object)playerCount);
            this.field_6011.method_12778(AWAKENING_TICKS, (Object)160);
            this.field_6011.method_12778(DATA_STATE, (Object)State.AWAKENING);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        if (this.method_5805() && (Integer)this.field_6011.method_12789(PHASE) < 1 && this.getState() != State.AWAKENING) {
            player.method_7353((class_2561)class_2561.method_43471((String)"entity.dungeonnowloading.chaos_spawner.right_click"), true);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, interactionHand);
    }

    protected void method_5958() {
        if (this.getAwakeningTick() > 0) {
            int k1 = this.getAwakeningTick() - 1;
            if (k1 == 99) {
                this.triggerWakeUpAnimation();
                this.method_5783(DNLSounds.CHAOS_SPAWNER_CHAIN_BREAK.get(), 3.0f, 1.0f);
            }
            if (k1 == 60) {
                this.method_5783(DNLSounds.CHAOS_SPAWNER_LAUGHTER.get(), 3.0f, 1.0f);
            }
            if (k1 <= 0) {
                this.setPhase(1);
                this.setDataState(State.IDLE);
            }
            this.setAwakeningTick(k1);
            if (k1 == 0) {
                for (int i = 0; i < 50; ++i) {
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11240, this.method_23322(0.9), this.method_23319(), this.method_23325(0.9), 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.fillBarriers();
                this.fillFrames();
                this.enableBossBar();
            }
        }
        if (this.getPhase() > 0 && !this.getState().equals((Object)State.DEATH)) {
            this.abilitySelectionTick();
            this.damageContactPlayer();
            this.checkBarrierTick();
            this.phaseUpdateTick();
        }
        if (this.getState().equals((Object)State.DEATH)) {
            ++this.deathAnimationTickCount;
            if (this.deathAnimationTickCount >= 160) {
                this.method_6078(this.method_48923().method_48830());
            }
        }
        if (this.getPhase() == 0 && this.getState().equals((Object)State.IDLE)) {
            this.setDataState(State.SLEEPING);
        }
        super.method_5958();
        this.bossEvent.method_5408(this.method_6032() / this.method_6063());
    }

    private void phaseUpdateTick() {
        if (this.getPhase() == 1 && (double)this.method_6032() < (double)this.method_6063() * 0.5) {
            this.setPhase(2);
        }
    }

    private void damageContactPlayer() {
        if (this.contactAttackTickCount > 0) {
            --this.contactAttackTickCount;
        } else {
            this.contactAttackTickCount = 20;
            class_238 aabb = new class_238(this.method_24515()).method_1014(2.0);
            List targets = this.method_37908().method_18467(class_1657.class, aabb);
            for (class_1657 player : targets) {
                this.method_6121((class_1297)player);
            }
        }
    }

    private void abilitySelectionTick() {
        if (this.method_5968() != null) {
            if (this.attackTickCount > 0) {
                --this.attackTickCount;
            } else if (this.field_6011.method_12789(DATA_STATE) == State.IDLE) {
                WeightedRandomBag<State> attackPool = new WeightedRandomBag<State>();
                class_238 aabb = new class_238(this.method_24515()).method_1014(10.0);
                this.pushTargets = this.method_37908().method_18467(class_1657.class, aabb);
                if (!this.pushTargets.isEmpty()) {
                    attackPool.addEntry(State.PUSH, 3.0);
                    attackPool.addEntry(State.SHOOT_GHOST_BULLET_SINGLE, 3.0);
                    attackPool.addEntry(State.SHOOT_GHOST_BULLET_BURST, 2.0);
                    attackPool.addEntry(State.SUMMON_MOB, 1.0);
                } else {
                    attackPool.addEntry(State.SHOOT_GHOST_BULLET_SINGLE, 3.0);
                    attackPool.addEntry(State.SHOOT_GHOST_BULLET_BURST, 2.0);
                    attackPool.addEntry(State.SUMMON_MOB, 1.0);
                }
                this.field_6011.method_12778(DATA_STATE, (Object)((State)((Object)attackPool.getRandom())));
            }
        }
    }

    private void checkBarrierTick() {
        if (this.barrierCheckTickCount > 0) {
            --this.barrierCheckTickCount;
        } else {
            this.barrierCheckTickCount = 20;
            class_2338 cageCenterPos = ((class_2338)this.field_6011.method_12789(SPAWN_POINT)).method_10086(1);
            this.checkBarrierIsBroken(cageCenterPos.method_10069(0, 0, -2), BARRIER_NORTH_TICK);
            this.checkBarrierIsBroken(cageCenterPos.method_10069(2, 0, 0), BARRIER_EAST_TICK);
            this.checkBarrierIsBroken(cageCenterPos.method_10069(0, 0, 2), BARRIER_SOUTH_TICK);
            this.checkBarrierIsBroken(cageCenterPos.method_10069(-2, 0, 0), BARRIER_WEST_TICK);
            this.checkBarrierIsBroken(cageCenterPos.method_10069(0, 2, 0), BARRIER_UP_TICK);
            this.checkBarrierIsBroken(cageCenterPos.method_10069(0, -2, 0), BARRIER_DOWN_TICK);
        }
        this.regenerateBarrierTick(this.FRAME_POS_NORTH, BARRIER_NORTH_TICK, ((class_2338)this.field_6011.method_12789(SPAWN_POINT)).method_10086(1).method_10069(0, 0, -2), 0);
        this.regenerateBarrierTick(this.FRAME_POS_EAST, BARRIER_EAST_TICK, ((class_2338)this.field_6011.method_12789(SPAWN_POINT)).method_10086(1).method_10069(2, 0, 0), 1);
        this.regenerateBarrierTick(this.FRAME_POS_SOUTH, BARRIER_SOUTH_TICK, ((class_2338)this.field_6011.method_12789(SPAWN_POINT)).method_10086(1).method_10069(0, 0, 2), 2);
        this.regenerateBarrierTick(this.FRAME_POS_WEST, BARRIER_WEST_TICK, ((class_2338)this.field_6011.method_12789(SPAWN_POINT)).method_10086(1).method_10069(-2, 0, 0), 3);
        this.regenerateBarrierTick(this.FRAME_POS_UP, BARRIER_UP_TICK, ((class_2338)this.field_6011.method_12789(SPAWN_POINT)).method_10086(1).method_10069(0, 2, 0), 4);
        this.regenerateBarrierTick(this.FRAME_POS_DOWN, BARRIER_DOWN_TICK, ((class_2338)this.field_6011.method_12789(SPAWN_POINT)).method_10086(1).method_10069(0, -2, 0), 5);
    }

    private void checkBarrierIsBroken(class_2338 blockPos, class_2940<Integer> entityDataAccessor) {
        if (!this.method_37908().method_8320(blockPos).method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get()) && (Integer)this.field_6011.method_12789(entityDataAccessor) < 0) {
            this.field_6011.method_12778(entityDataAccessor, (Object)100);
        }
    }

    private void regenerateBarrierTick(ImmutableList<class_2338> framePositions, class_2940<Integer> entityDataAccessor, class_2338 barrierCenterPos, int barrierDirection) {
        if ((Integer)this.field_6011.method_12789(entityDataAccessor) > 0) {
            int barrierRegenerateTickCount = (Integer)this.field_6011.method_12789(entityDataAccessor) - 1;
            this.field_6011.method_12778(entityDataAccessor, (Object)barrierRegenerateTickCount);
        } else if ((Integer)this.field_6011.method_12789(entityDataAccessor) != -1) {
            class_2338 cageCenterPos = ((class_2338)this.field_6011.method_12789(SPAWN_POINT)).method_10086(1);
            UnmodifiableIterator iterator = framePositions.iterator();
            int fixedFrame = 0;
            while (iterator.hasNext()) {
                class_2338 framePos = cageCenterPos.method_10081((class_2382)iterator.next());
                class_2680 frameState = this.method_37908().method_8320(framePos);
                if (frameState.method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_EDGE.get()) || frameState.method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_DIAMOND_EDGE.get()) || frameState.method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_DIAMOND_VERTEX.get())) {
                    ++fixedFrame;
                    continue;
                }
                if (frameState.method_26204() instanceof ChaosSpawnerEdgeBlock) {
                    this.method_37908().method_8396(null, framePos, class_3417.field_19197, this.method_5634(), 3.0f, 1.0f);
                    ChaosSpawnerEdgeBlock.fixFrame(this.method_37908(), framePos, frameState);
                } else if (frameState.method_26204() instanceof ChaosSpawnerVertexBlock) {
                    this.method_37908().method_8396(null, framePos, class_3417.field_19197, this.method_5634(), 3.0f, 1.0f);
                    ChaosSpawnerVertexBlock.fixFrame(this.method_37908(), framePos, frameState);
                }
                this.field_6011.method_12778(entityDataAccessor, (Object)20);
                break;
            }
            if (fixedFrame == 16) {
                this.field_6011.method_12778(entityDataAccessor, (Object)-1);
                this.placeFullBarrier(barrierCenterPos, barrierDirection);
            }
        }
    }

    private void placeFullBarrier(class_2338 barrierCenterPos, int barrierDirection) {
        this.method_37908().method_8396(null, barrierCenterPos, class_3417.field_14981, this.method_5634(), 1.0f, 2.0f);
        ChaosSpawnerBarrierCenterBlock.placeBarrier(this.method_37908(), barrierCenterPos, barrierDirection);
        ChaosSpawnerBarrierEdgeBlock.placeBarrier(this.method_37908(), barrierCenterPos, barrierDirection);
        ChaosSpawnerBarrierVertexBlock.placeBarrier(this.method_37908(), barrierCenterPos, barrierDirection);
    }

    private void fillFrames() {
        UnmodifiableIterator iterator = FRAME_POSITIONS.iterator();
        class_2338 cageCenterPos = ((class_2338)this.field_6011.method_12789(SPAWN_POINT)).method_10086(1);
        while (iterator.hasNext()) {
            class_2338 framePos = cageCenterPos.method_10081((class_2382)((class_2338)iterator.next()));
            class_2680 frameState = this.method_37908().method_8320(framePos);
            if (frameState.method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_BROKEN_DIAMOND_EDGE.get()) || frameState.method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_BROKEN_EDGE.get())) {
                ChaosSpawnerEdgeBlock.fixFrame(this.method_37908(), framePos, frameState);
                continue;
            }
            if (!frameState.method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_BROKEN_DIAMOND_VERTEX.get())) continue;
            ChaosSpawnerVertexBlock.fixFrame(this.method_37908(), framePos, frameState);
        }
    }

    private void fillBarriers() {
        class_2338 cageCenterPos = ((class_2338)this.field_6011.method_12789(SPAWN_POINT)).method_10086(1);
        class_1937 level = this.method_37908();
        if (!level.method_8320(cageCenterPos.method_10069(0, 0, -2)).method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get())) {
            this.placeFullBarrier(cageCenterPos.method_10069(0, 0, -2), 0);
        }
        if (!level.method_8320(cageCenterPos.method_10069(2, 0, 0)).method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get())) {
            this.placeFullBarrier(cageCenterPos.method_10069(2, 0, 0), 1);
        }
        if (!level.method_8320(cageCenterPos.method_10069(0, 0, 2)).method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get())) {
            this.placeFullBarrier(cageCenterPos.method_10069(0, 0, 2), 2);
        }
        if (!level.method_8320(cageCenterPos.method_10069(-2, 0, 0)).method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get())) {
            this.placeFullBarrier(cageCenterPos.method_10069(-2, 0, 0), 3);
        }
        if (!level.method_8320(cageCenterPos.method_10069(0, 2, 0)).method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get())) {
            this.placeFullBarrier(cageCenterPos.method_10069(0, 2, 0), 4);
        }
        if (!level.method_8320(cageCenterPos.method_10069(0, -2, 0)).method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get())) {
            this.placeFullBarrier(cageCenterPos.method_10069(0, -2, 0), 5);
        }
    }

    public void method_5711(byte b) {
        this.resetAnimations();
        switch (b) {
            case 3: {
                class_3414 soundEvent = this.method_6002();
                if (soundEvent != null) {
                    this.method_5783(soundEvent, this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
                }
                this.deathAnimationState.method_41322(this.field_6012);
                this.method_6033(0.0f);
                this.setDataState(State.DEATH);
            }
            case 71: {
                this.sleepingAnimationState.method_41325();
                this.awakeningAnimationState.method_41322(this.field_6012);
                break;
            }
            case 72: {
                this.smashAttackAnimationState.method_41322(this.field_6012);
                break;
            }
            case 73: {
                this.rangeAttackAnimationState.method_41322(this.field_6012);
                break;
            }
            case 74: {
                this.rangeBurstAttackAnimationState.method_41322(this.field_6012);
                break;
            }
            case 75: {
                this.summonAnimationState.method_41322(this.field_6012);
                break;
            }
            case 76: {
                this.deathAnimationState.method_41322(this.field_6012);
                break;
            }
            case 70: {
                this.sleepingAnimationState.method_41322(this.field_6012);
            }
            case 77: {
                this.resetAnimations();
            }
            default: {
                super.method_5711(b);
            }
        }
    }

    private void resetAnimations() {
        this.sleepingAnimationState.method_41325();
        this.awakeningAnimationState.method_41325();
        this.smashAttackAnimationState.method_41325();
        this.summonAnimationState.method_41325();
        this.rangeAttackAnimationState.method_41325();
        this.rangeBurstAttackAnimationState.method_41325();
        this.deathAnimationState.method_41325();
    }

    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, class_1315 spawnGroupData, class_2487 compoundTag) {
        this.field_6011.method_12778(SPAWN_POINT, (Object)this.method_24515());
        this.field_6011.method_12778(DATA_STATE, (Object)State.SLEEPING);
        this.triggerSleepAnimation();
        return super.method_5943(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public boolean method_5643(class_1282 damageSource, float damage) {
        if (!(damageSource.method_48789(class_8103.field_42242) || damageSource.method_5530() || this.field_6011.method_12789(DATA_STATE) != State.SLEEPING && this.field_6011.method_12789(DATA_STATE) != State.AWAKENING)) {
            return false;
        }
        return super.method_5643(damageSource, damage);
    }

    protected void method_6108() {
        ++this.field_6213;
        if (this.field_6213 == 1) {
            this.method_36457(0.0f);
        }
        if (this.field_6213 >= 160 && !this.method_37908().method_8608() && !this.method_31481()) {
            class_1937 level = this.method_37908();
            class_1297 entity = this.killedDamageSource.method_5529();
            class_1309 livingEntity = this.method_6124();
            if (this.field_6232 >= 0 && livingEntity != null) {
                livingEntity.method_5716((class_1297)this, this.field_6232, this.killedDamageSource);
            }
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                if (entity == null || entity.method_5874(serverLevel, (class_1309)this)) {
                    this.method_16080(this.killedDamageSource);
                    this.method_23733(livingEntity);
                }
                this.method_37908().method_8421((class_1297)this, (byte)3);
            }
            this.method_37908().method_8421((class_1297)this, (byte)60);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public void method_6078(class_1282 damageSource) {
        class_1937 level;
        if (this.method_31481() || this.field_6272) {
            return;
        }
        this.killedDamageSource = damageSource;
        class_1297 entity = this.killedDamageSource.method_5529();
        if (this.method_6113()) {
            this.method_18400();
        }
        if (!this.method_37908().field_9236 && this.method_16914()) {
            LOGGER.info("Named entity {} died: {}", (Object)this, (Object)this.method_6066().method_5548().getString());
        }
        if ((level = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (entity == null || entity.method_5874(serverLevel, (class_1309)this)) {
                this.method_32876(class_5712.field_37676);
            }
            this.method_37908().method_8421((class_1297)this, (byte)3);
        }
        this.field_6272 = true;
        this.method_6066().method_5539();
        this.method_18380(class_4050.field_18082);
    }

    protected void method_6099(class_1282 damageSource, int a, boolean b) {
        if (((Boolean)BossConfig.TOGGLE_MULTIPLAYER_LOOT.get()).booleanValue() && !this.playerUUIDs.isEmpty()) {
            Iterator<UUID> iterator = this.playerUUIDs.iterator();
            while (iterator.hasNext()) {
                UUID playerUUID;
                this.currentPlayerUUID = playerUUID = iterator.next();
                this.spawnLootTableItems(damageSource, true);
            }
        } else {
            super.method_6099(damageSource, a, b);
        }
    }

    protected void method_16077(class_1282 $$0, boolean $$1) {
        if (!((Boolean)BossConfig.TOGGLE_MULTIPLAYER_LOOT.get()).booleanValue()) {
            super.method_16077($$0, $$1);
        }
    }

    public void spawnLootTableItems(class_1282 damageSource, boolean b) {
        class_2960 resourceLocation = this.method_5989();
        class_52 lootTable = this.method_37908().method_8503().method_3857().getLootTable(resourceLocation);
        class_8567.class_8568 lootparams$builder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1231, (Object)damageSource).method_51877(class_181.field_1230, (Object)damageSource.method_5529()).method_51877(class_181.field_1227, (Object)damageSource.method_5526());
        if (b && this.field_6258 != null) {
            lootparams$builder = lootparams$builder.method_51874(class_181.field_1233, (Object)this.field_6258).method_51871(this.field_6258.method_7292());
        }
        class_8567 lootParams = lootparams$builder.method_51875(class_173.field_1173);
        lootTable.method_51880(lootParams, this.method_51851(), this::spawnSpecialItemAtLocation);
    }

    public SpecialItemEntity spawnSpecialItemAtLocation(class_1799 itemStack) {
        return this.spawnSpecialItemEntity(itemStack, 0.0f, this.currentPlayerUUID);
    }

    public SpecialItemEntity spawnSpecialItemEntity(class_1799 itemStack, float i, UUID uuid) {
        if (itemStack.method_7960()) {
            return null;
        }
        if (this.method_37908().field_9236) {
            return null;
        }
        SpecialItemEntity specialItemEntity = new SpecialItemEntity(this.method_37908(), this.method_23317(), this.method_23318() + (double)i, this.method_23321(), itemStack);
        specialItemEntity.setPickerUUID(uuid);
        specialItemEntity.method_6988();
        this.method_37908().method_8649((class_1297)specialItemEntity);
        return specialItemEntity;
    }

    public void method_5697(class_1297 entity) {
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected float method_18394(class_4050 $$0, class_4048 $$1) {
        return 1.0f;
    }

    protected boolean method_5876() {
        return false;
    }

    protected class_3414 method_6011(class_1282 $$0) {
        return DNLSounds.CHAOS_SPAWNER_HURT.get();
    }

    protected class_3414 method_6002() {
        return DNLSounds.CHAOS_SPAWNER_DEATH.get();
    }

    private class_3414 getChainBreakSound() {
        return DNLSounds.CHAOS_SPAWNER_CHAIN_BREAK.get();
    }

    public class_3414 getScreechSound() {
        return DNLSounds.CHAOS_SPAWNER_LAUGHTER.get();
    }

    public boolean isAwakening() {
        return this.field_6011.method_12789(DATA_STATE) == State.AWAKENING;
    }

    public boolean method_6113() {
        return this.field_6011.method_12789(DATA_STATE) == State.SLEEPING;
    }

    public boolean isAttacking(State attackState) {
        return this.field_6011.method_12789(DATA_STATE) == attackState;
    }

    public State getState() {
        return (State)((Object)this.field_6011.method_12789(DATA_STATE));
    }

    public int getAwakeningTick() {
        return (Integer)this.field_6011.method_12789(AWAKENING_TICKS);
    }

    public int getAttackTick() {
        return this.attackTickCount;
    }

    public int getPhase() {
        return (Integer)this.field_6011.method_12789(PHASE);
    }

    public class_2338 getSpawnPointPos() {
        return (class_2338)this.field_6011.method_12789(SPAWN_POINT);
    }

    public Set<UUID> getParticipatingPlayerUUIDs() {
        return this.playerUUIDs;
    }

    public int getParticipatingPlayerCount() {
        return this.playerUUIDs.size();
    }

    public List<class_1657> getPushTargets() {
        return this.pushTargets;
    }

    public double getAttackDamage() {
        return this.method_26825(class_5134.field_23721);
    }

    public double getFollowDistance() {
        return this.method_26825(class_5134.field_23717);
    }

    public void triggerWakeUpAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)71);
    }

    public void triggerRangeAttackAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)73);
    }

    public void triggerRangeBurstAttackAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)74);
    }

    public void triggerSmashAttackAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)72);
    }

    public void triggerSummonAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)75);
    }

    public void triggerDeathAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)76);
    }

    public void triggerSleepAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)70);
    }

    public void triggerAnimationStop() {
        this.method_37908().method_8421((class_1297)this, (byte)77);
    }

    public void clearParticipatingPlayers() {
        this.playerUUIDs.clear();
    }

    public void setDataState(State state) {
        this.field_6011.method_12778(DATA_STATE, (Object)state);
    }

    public void setAwakeningTick(int tick) {
        this.field_6011.method_12778(AWAKENING_TICKS, (Object)tick);
    }

    public void setAttackTick(int tick) {
        this.attackTickCount = tick;
    }

    public void setPhase(int phase) {
        this.field_6011.method_12778(PHASE, (Object)phase);
    }

    public void setBarrierNorthTick(int tick) {
        this.field_6011.method_12778(BARRIER_NORTH_TICK, (Object)tick);
    }

    public void setBarrierEastTick(int tick) {
        this.field_6011.method_12778(BARRIER_EAST_TICK, (Object)tick);
    }

    public void setBarrierSouthTick(int tick) {
        this.field_6011.method_12778(BARRIER_SOUTH_TICK, (Object)tick);
    }

    public void setBarrierWestTick(int tick) {
        this.field_6011.method_12778(BARRIER_WEST_TICK, (Object)tick);
    }

    public void setBarrierUpTick(int tick) {
        this.field_6011.method_12778(BARRIER_UP_TICK, (Object)tick);
    }

    public void setBarrierDownTick(int tick) {
        this.field_6011.method_12778(BARRIER_DOWN_TICK, (Object)tick);
    }

    public void enableBossBar() {
        this.bossEvent.method_14091(true);
    }

    public void disableBossBar() {
        this.bossEvent.method_14091(false);
    }

    public void stopAttacking(int cooldown) {
        this.field_6011.method_12778(DATA_STATE, (Object)State.IDLE);
        this.setAttackTick(cooldown);
    }

    static {
        SPAWN_POINT = class_2945.method_12791(ChaosSpawnerEntity.class, (class_2941)class_2943.field_13324);
        PHASE = class_2945.method_12791(ChaosSpawnerEntity.class, (class_2941)class_2943.field_13327);
        AWAKENING_TICKS = class_2945.method_12791(ChaosSpawnerEntity.class, (class_2941)class_2943.field_13327);
        ATTACK_TICK = class_2945.method_12791(ChaosSpawnerEntity.class, (class_2941)class_2943.field_13327);
        ACTIVE_RANGE = class_2945.method_12791(ChaosSpawnerEntity.class, (class_2941)class_2943.field_13327);
        PLAYER_COUNT = class_2945.method_12791(ChaosSpawnerEntity.class, (class_2941)class_2943.field_13327);
        BARRIER_NORTH_TICK = class_2945.method_12791(ChaosSpawnerEntity.class, (class_2941)class_2943.field_13327);
        BARRIER_EAST_TICK = class_2945.method_12791(ChaosSpawnerEntity.class, (class_2941)class_2943.field_13327);
        BARRIER_SOUTH_TICK = class_2945.method_12791(ChaosSpawnerEntity.class, (class_2941)class_2943.field_13327);
        BARRIER_WEST_TICK = class_2945.method_12791(ChaosSpawnerEntity.class, (class_2941)class_2943.field_13327);
        BARRIER_UP_TICK = class_2945.method_12791(ChaosSpawnerEntity.class, (class_2941)class_2943.field_13327);
        BARRIER_DOWN_TICK = class_2945.method_12791(ChaosSpawnerEntity.class, (class_2941)class_2943.field_13327);
        PLAYER_UUID = class_2945.method_12791(ChaosSpawnerEntity.class, (class_2941)class_2943.field_13313);
        DATA_STATE = class_2945.method_12791(ChaosSpawnerEntity.class, EntityStates.CHAOS_SPAWNER_STATE);
        FRAME_POSITIONS = ImmutableList.of((Object)new class_2338(2, 2, 2), (Object)new class_2338(2, 2, 1), (Object)new class_2338(2, 2, 0), (Object)new class_2338(2, 2, -1), (Object)new class_2338(2, 2, -2), (Object)new class_2338(-2, 2, 2), (Object)new class_2338(-2, 2, 1), (Object)new class_2338(-2, 2, 0), (Object)new class_2338(-2, 2, -1), (Object)new class_2338(-2, 2, -2), (Object)new class_2338(1, 2, 2), (Object)new class_2338(0, 2, 2), (Object[])new class_2338[]{new class_2338(-1, 2, 2), new class_2338(1, 2, -2), new class_2338(0, 2, -2), new class_2338(-1, 2, -2), new class_2338(2, -2, 2), new class_2338(2, -2, 1), new class_2338(2, -2, 0), new class_2338(2, -2, -1), new class_2338(2, -2, -2), new class_2338(-2, -2, 2), new class_2338(-2, -2, 1), new class_2338(-2, -2, 0), new class_2338(-2, -2, -1), new class_2338(-2, -2, -2), new class_2338(1, -2, 2), new class_2338(0, -2, 2), new class_2338(-1, -2, 2), new class_2338(1, -2, -2), new class_2338(0, -2, -2), new class_2338(-1, -2, -2), new class_2338(2, 1, 2), new class_2338(2, 0, 2), new class_2338(2, -1, 2), new class_2338(2, 1, -2), new class_2338(2, 0, -2), new class_2338(2, -1, -2), new class_2338(-2, 1, -2), new class_2338(-2, 0, -2), new class_2338(-2, -1, -2), new class_2338(-2, -1, 2), new class_2338(-2, 0, 2), new class_2338(-2, -1, 2)});
    }

    public static enum State {
        SLEEPING,
        AWAKENING,
        IDLE,
        SUMMON_MOB,
        SHOOT_GHOST_BULLET_SINGLE,
        SHOOT_GHOST_BULLET_BURST,
        PUSH,
        DEATH;

    }
}

