/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import com.google.common.collect.ImmutableList;
import dev.hexnowloading.dungeonnowloading.entity.boss.ChaosSpawnerEntity;
import dev.hexnowloading.dungeonnowloading.util.WeightedRandomBag;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1613;
import net.minecraft.class_1628;
import net.minecraft.class_1642;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5425;

public class ChaosSpawnerSummonMobGoal
extends class_1352 {
    private final ChaosSpawnerEntity chaosSpawnerEntity;
    private int summonCount;
    private int maxSummonLimit;
    private static final ImmutableList<class_2338> MOB_SUMMON_POS = ImmutableList.of((Object)new class_2338(5, 1, 0), (Object)new class_2338(-5, 1, 0), (Object)new class_2338(0, 1, 5), (Object)new class_2338(0, 1, -5), (Object)new class_2338(5, 1, 2), (Object)new class_2338(-5, 1, 2), (Object)new class_2338(2, 1, 5), (Object)new class_2338(2, 1, -5), (Object)new class_2338(5, 1, -2), (Object)new class_2338(-5, 1, -2), (Object)new class_2338(-2, 1, 5), (Object)new class_2338(-2, 1, -5), (Object[])new class_2338[0]);

    public ChaosSpawnerSummonMobGoal(ChaosSpawnerEntity chaosSpawnerEntity) {
        this.chaosSpawnerEntity = chaosSpawnerEntity;
    }

    public boolean method_6264() {
        if (this.chaosSpawnerEntity.isAttacking(ChaosSpawnerEntity.State.SUMMON_MOB) && this.chaosSpawnerEntity.method_5968() != null) {
            if (this.withinSummonLimit()) {
                return true;
            }
            this.chaosSpawnerEntity.stopAttacking(0);
            return false;
        }
        return false;
    }

    public boolean method_6266() {
        return this.chaosSpawnerEntity.isAttacking(ChaosSpawnerEntity.State.SUMMON_MOB) && this.chaosSpawnerEntity.method_5968() != null;
    }

    public void method_6269() {
        super.method_6269();
        this.chaosSpawnerEntity.triggerSummonAnimation();
        this.chaosSpawnerEntity.setAttackTick(100);
    }

    public void method_6268() {
        if (this.chaosSpawnerEntity.getAttackTick() == 100) {
            this.chaosSpawnerEntity.method_5783(this.chaosSpawnerEntity.getScreechSound(), 2.0f, 1.0f);
            this.summonCount = Math.max(0, this.maxSummonLimit);
            double d = this.chaosSpawnerEntity.method_23317();
            double e = this.chaosSpawnerEntity.method_23318();
            double f = this.chaosSpawnerEntity.method_23321();
            ((class_3218)this.chaosSpawnerEntity.method_37908()).method_14199((class_2394)class_2398.field_11240, d, e, f, 20, 3.0, 3.0, 3.0, 0.0);
            for (int i = 0; i < this.summonCount; ++i) {
                WeightedRandomBag<String> mobWeightBag = new WeightedRandomBag<String>();
                if (this.chaosSpawnerEntity.getPhase() == 1) {
                    mobWeightBag.addEntry("Zombie", 3.0);
                    mobWeightBag.addEntry("Skeleton", 2.0);
                    mobWeightBag.addEntry("Spider", 2.0);
                } else if (this.chaosSpawnerEntity.getPhase() == 2) {
                    mobWeightBag.addEntry("Zombie", 9.0);
                    mobWeightBag.addEntry("Skeleton", 6.0);
                    mobWeightBag.addEntry("Spider", 6.0);
                    mobWeightBag.addEntry("Diamond Zombie", 2.0);
                    mobWeightBag.addEntry("Diamond Skeleton", 2.0);
                    mobWeightBag.addEntry("Invisible Spider", 2.0);
                    mobWeightBag.addEntry("Spider Jokey", 1.0);
                    mobWeightBag.addEntry("Baby Zombie", 1.0);
                }
                this.summonMob((String)mobWeightBag.getRandom(), this.chaosSpawnerEntity.method_24515().method_10081((class_2382)MOB_SUMMON_POS.get(Math.min(i, MOB_SUMMON_POS.size() - 1))));
            }
        }
        if (this.chaosSpawnerEntity.getAttackTick() == 0) {
            this.chaosSpawnerEntity.stopAttacking(60);
        }
    }

    private boolean withinSummonLimit() {
        List mobList = this.chaosSpawnerEntity.method_37908().method_18467(class_1588.class, this.chaosSpawnerEntity.method_5829().method_1014(this.chaosSpawnerEntity.getFollowDistance() / 2.0));
        this.maxSummonLimit = Math.min(2 + this.chaosSpawnerEntity.getParticipatingPlayerCount() * 2, 12);
        return mobList.size() < this.maxSummonLimit;
    }

    private void summonMob(String summoningMob, class_2338 summonPos) {
        class_1937 level = this.chaosSpawnerEntity.method_37908();
        double d = summonPos.method_10263();
        double e = (double)summonPos.method_10264() + 1.0;
        double f = summonPos.method_10260();
        ((class_3218)this.chaosSpawnerEntity.method_37908()).method_14199((class_2394)class_2398.field_11204, d, e, f, 10, 0.5, 0.5, 0.5, 0.0);
        switch (summoningMob) {
            case "Zombie": {
                class_1642 zombie = (class_1642)class_1299.field_6051.method_5883(level);
                if (zombie == null) break;
                zombie.method_5725(summonPos, 0.0f, 0.0f);
                zombie.method_5943((class_5425)((class_3218)level), level.method_8404(summonPos), class_3730.field_16471, null, null);
                this.noDropChance((class_1588)zombie);
                level.method_8649((class_1297)zombie);
                break;
            }
            case "Skeleton": {
                class_1613 skeleton = (class_1613)class_1299.field_6137.method_5883(level);
                if (skeleton == null) break;
                skeleton.method_5725(summonPos, 0.0f, 0.0f);
                skeleton.method_5943((class_5425)((class_3218)level), level.method_8404(summonPos), class_3730.field_16471, null, null);
                this.noDropChance((class_1588)skeleton);
                level.method_8649((class_1297)skeleton);
                break;
            }
            case "Spider": {
                class_1628 spider = (class_1628)class_1299.field_6079.method_5883(level);
                if (spider == null) break;
                spider.method_5725(summonPos, 0.0f, 0.0f);
                spider.method_5943((class_5425)((class_3218)level), level.method_8404(summonPos), class_3730.field_16471, null, null);
                level.method_8649((class_1297)spider);
                break;
            }
            case "Diamond Zombie": {
                class_1642 zombie = (class_1642)class_1299.field_6051.method_5883(level);
                if (zombie == null) break;
                zombie.method_5725(summonPos, 0.0f, 0.0f);
                zombie.method_5943((class_5425)((class_3218)level), level.method_8404(summonPos), class_3730.field_16471, null, null);
                zombie.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8805));
                zombie.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8802));
                zombie.method_6118(class_1304.field_6173).method_7978(class_1893.field_9118, 2);
                this.noDropChance((class_1588)zombie);
                level.method_8649((class_1297)zombie);
                break;
            }
            case "Diamond Skeleton": {
                class_1613 skeleton = (class_1613)class_1299.field_6137.method_5883(level);
                if (skeleton == null) break;
                skeleton.method_5725(summonPos, 0.0f, 0.0f);
                skeleton.method_5943((class_5425)((class_3218)level), level.method_8404(summonPos), class_3730.field_16471, null, null);
                skeleton.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8805));
                skeleton.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
                skeleton.method_6118(class_1304.field_6173).method_7978(class_1893.field_9103, 2);
                this.noDropChance((class_1588)skeleton);
                level.method_8649((class_1297)skeleton);
                break;
            }
            case "Invisible Spider": {
                class_1628 spider = (class_1628)class_1299.field_6079.method_5883(level);
                if (spider == null) break;
                spider.method_5725(summonPos, 0.0f, 0.0f);
                spider.method_5943((class_5425)((class_3218)level), level.method_8404(summonPos), class_3730.field_16471, null, null);
                spider.method_6092(new class_1293(class_1294.field_5905, -1));
                level.method_8649((class_1297)spider);
                break;
            }
            case "Spider Jokey": {
                class_1628 spider = (class_1628)class_1299.field_6079.method_5883(level);
                if (spider == null) break;
                spider.method_5725(summonPos, 0.0f, 0.0f);
                spider.method_5943((class_5425)((class_3218)level), level.method_8404(summonPos), class_3730.field_16471, null, null);
                class_1613 skeleton = (class_1613)class_1299.field_6137.method_5883(level);
                if (skeleton == null) break;
                skeleton.method_5725(summonPos, 0.0f, 0.0f);
                skeleton.method_5943((class_5425)((class_3218)level), level.method_8404(summonPos), class_3730.field_16471, null, null);
                skeleton.method_5804((class_1297)spider);
                this.noDropChance((class_1588)skeleton);
                level.method_8649((class_1297)spider);
                level.method_8649((class_1297)skeleton);
                break;
            }
            case "Baby Zombie": {
                class_1642 zombie = (class_1642)class_1299.field_6051.method_5883(level);
                if (zombie == null) break;
                zombie.method_5725(summonPos, 0.0f, 0.0f);
                zombie.method_5943((class_5425)((class_3218)level), level.method_8404(summonPos), class_3730.field_16471, null, null);
                zombie.method_7217(true);
                zombie.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8805));
                zombie.method_5673(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8058));
                zombie.method_5673(class_1304.field_6172, new class_1799((class_1935)class_1802.field_8348));
                zombie.method_5673(class_1304.field_6166, new class_1799((class_1935)class_1802.field_8285));
                zombie.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8556));
                zombie.method_6118(class_1304.field_6173).method_7978(class_1893.field_9118, 4);
                this.noDropChance((class_1588)zombie);
                level.method_8649((class_1297)zombie);
            }
        }
    }

    private void noDropChance(class_1588 monster) {
        monster.method_5946(class_1304.field_6169, 0.0f);
        monster.method_5946(class_1304.field_6174, 0.0f);
        monster.method_5946(class_1304.field_6172, 0.0f);
        monster.method_5946(class_1304.field_6166, 0.0f);
        monster.method_5946(class_1304.field_6173, 0.0f);
        monster.method_5946(class_1304.field_6171, 0.0f);
    }
}

