/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.boss.ChaosSpawnerEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.ChaosSpawnerProjectileEntity;
import dev.hexnowloading.dungeonnowloading.util.WeightedRandomBag;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_243;
import net.minecraft.class_3417;

public class ChaosSpawnerShootGhostBulletGoal
extends class_1352 {
    private final ChaosSpawnerEntity chaosSpawnerEntity;
    private final int DURATION = 126;
    private String type;

    public ChaosSpawnerShootGhostBulletGoal(ChaosSpawnerEntity chaosSpawnerEntity) {
        this.chaosSpawnerEntity = chaosSpawnerEntity;
    }

    public boolean method_6264() {
        return (this.chaosSpawnerEntity.isAttacking(ChaosSpawnerEntity.State.SHOOT_GHOST_BULLET_SINGLE) || this.chaosSpawnerEntity.isAttacking(ChaosSpawnerEntity.State.SHOOT_GHOST_BULLET_BURST)) && this.chaosSpawnerEntity.method_5968() != null;
    }

    public void method_6269() {
        super.method_6269();
        this.chaosSpawnerEntity.setAttackTick(126);
        WeightedRandomBag<String> bulletPatterns = new WeightedRandomBag<String>();
        if (this.chaosSpawnerEntity.getState() == ChaosSpawnerEntity.State.SHOOT_GHOST_BULLET_SINGLE) {
            this.chaosSpawnerEntity.triggerRangeAttackAnimation();
            if (this.chaosSpawnerEntity.getPhase() == 1) {
                bulletPatterns.addEntry("Single", 1.0);
                bulletPatterns.addEntry("Arc", 1.0);
            } else if (this.chaosSpawnerEntity.getPhase() == 2) {
                bulletPatterns.addEntry("Rapid", 1.0);
                bulletPatterns.addEntry("Strong Arc", 1.0);
            }
        } else {
            this.chaosSpawnerEntity.triggerRangeBurstAttackAnimation();
            if (this.chaosSpawnerEntity.getPhase() == 1) {
                bulletPatterns.addEntry("Burst", 1.0);
            } else if (this.chaosSpawnerEntity.getPhase() == 2) {
                bulletPatterns.addEntry("Strong Burst", 1.0);
            }
        }
        this.type = (String)bulletPatterns.getRandom();
    }

    public void method_6268() {
        switch (this.type) {
            case "Single": {
                for (int i = 0; i < 5; ++i) {
                    if (this.chaosSpawnerEntity.getAttackTick() != 100 - i * 20) continue;
                    this.performSingleShot();
                }
                break;
            }
            case "Rapid": {
                for (int j = 0; j < 3; ++j) {
                    for (int i = 0; i < 5; ++i) {
                        if (this.chaosSpawnerEntity.getAttackTick() != 100 - 30 * j - i * 4) continue;
                        this.performSingleShot();
                    }
                }
                break;
            }
            case "Arc": {
                for (int i = 0; i < 3; ++i) {
                    if (this.chaosSpawnerEntity.getAttackTick() != 100 - i * 30) continue;
                    this.performArcShot();
                }
                break;
            }
            case "Strong Arc": {
                for (int i = 0; i < 3; ++i) {
                    if (this.chaosSpawnerEntity.getAttackTick() != 100 - i * 30) continue;
                    this.performStrongArcShot();
                }
                break;
            }
            case "Burst": {
                for (int i = 0; i < 3; ++i) {
                    if (this.chaosSpawnerEntity.getAttackTick() != 100 - i * 30) continue;
                    this.performBurstShot((float)(i % 2) * 22.5f);
                }
                break;
            }
            case "Strong Burst": {
                for (int i = 0; i < 3; ++i) {
                    if (this.chaosSpawnerEntity.getAttackTick() != 100 - i * 30) continue;
                    this.performStrongBurstShot((float)(i % 2) * 11.5f);
                }
                break;
            }
        }
        if (this.chaosSpawnerEntity.getAttackTick() == 0) {
            this.chaosSpawnerEntity.stopAttacking(60);
        }
    }

    private void performSingleShot() {
        class_1309 targetEntity = this.chaosSpawnerEntity.method_5968();
        if (targetEntity != null && (double)targetEntity.method_5739((class_1297)this.chaosSpawnerEntity) < this.chaosSpawnerEntity.getFollowDistance()) {
            this.chaosSpawnerEntity.method_37908().method_43128(null, this.chaosSpawnerEntity.method_23317(), this.chaosSpawnerEntity.method_23318(), this.chaosSpawnerEntity.method_23321(), class_3417.field_14588, this.chaosSpawnerEntity.method_5634(), 3.0f, 1.0f + (this.chaosSpawnerEntity.method_6051().method_43057() - this.chaosSpawnerEntity.method_6051().method_43057()) * 0.2f);
            this.vecFromCenterToFrontOfFace(0.0f);
        }
    }

    private void performArcShot() {
        class_1309 targetEntity = this.chaosSpawnerEntity.method_5968();
        if (targetEntity != null && (double)targetEntity.method_5739((class_1297)this.chaosSpawnerEntity) < this.chaosSpawnerEntity.getFollowDistance()) {
            this.chaosSpawnerEntity.method_37908().method_43128(null, this.chaosSpawnerEntity.method_23317(), this.chaosSpawnerEntity.method_23318(), this.chaosSpawnerEntity.method_23321(), class_3417.field_14588, this.chaosSpawnerEntity.method_5634(), 3.0f, 1.0f + (this.chaosSpawnerEntity.method_6051().method_43057() - this.chaosSpawnerEntity.method_6051().method_43057()) * 0.2f);
            this.vecFromCenterToFrontOfFace(0.0f);
            this.vecFromCenterToFrontOfFace(-10.0f);
            this.vecFromCenterToFrontOfFace(10.0f);
        }
    }

    private void performStrongArcShot() {
        class_1309 targetEntity = this.chaosSpawnerEntity.method_5968();
        if (targetEntity != null && (double)targetEntity.method_5739((class_1297)this.chaosSpawnerEntity) < this.chaosSpawnerEntity.getFollowDistance()) {
            this.chaosSpawnerEntity.method_37908().method_43128(null, this.chaosSpawnerEntity.method_23317(), this.chaosSpawnerEntity.method_23318(), this.chaosSpawnerEntity.method_23321(), class_3417.field_14588, this.chaosSpawnerEntity.method_5634(), 3.0f, 1.0f + (this.chaosSpawnerEntity.method_6051().method_43057() - this.chaosSpawnerEntity.method_6051().method_43057()) * 0.2f);
            this.vecFromCenterToFrontOfFace(0.0f);
            this.vecFromCenterToFrontOfFace(-10.0f);
            this.vecFromCenterToFrontOfFace(10.0f);
            this.vecFromCenterToFrontOfFace(-20.0f);
            this.vecFromCenterToFrontOfFace(20.0f);
        }
    }

    private void performBurstShot(float angle) {
        float offset = (float)Math.toRadians(angle);
        class_243 vec3 = this.chaosSpawnerEntity.method_5828(1.0f);
        vec3 = vec3.method_1024(offset);
        this.chaosSpawnerEntity.method_37908().method_43128(null, this.chaosSpawnerEntity.method_23317(), this.chaosSpawnerEntity.method_23318(), this.chaosSpawnerEntity.method_23321(), class_3417.field_14588, this.chaosSpawnerEntity.method_5634(), 3.0f, 1.0f + (this.chaosSpawnerEntity.method_6051().method_43057() - this.chaosSpawnerEntity.method_6051().method_43057()) * 0.2f);
        for (int i = 0; i < 8; ++i) {
            vec3 = vec3.method_1024((float)Math.toRadians(45.0) * (float)i);
            ChaosSpawnerProjectileEntity chaosSpawnerProjectileEntity = new ChaosSpawnerProjectileEntity((class_1309)this.chaosSpawnerEntity, vec3.field_1352, vec3.field_1351, vec3.field_1350);
            chaosSpawnerProjectileEntity.method_5814(chaosSpawnerProjectileEntity.method_23317() + vec3.field_1352, chaosSpawnerProjectileEntity.method_23323(0.5) + vec3.field_1351, chaosSpawnerProjectileEntity.method_23321() + vec3.field_1350);
            this.chaosSpawnerEntity.method_37908().method_8649((class_1297)chaosSpawnerProjectileEntity);
        }
    }

    private void performStrongBurstShot(float angle) {
        float offset = (float)Math.toRadians(angle);
        class_243 vec3 = this.chaosSpawnerEntity.method_5828(1.0f);
        vec3 = vec3.method_1024(offset);
        this.chaosSpawnerEntity.method_37908().method_43128(null, this.chaosSpawnerEntity.method_23317(), this.chaosSpawnerEntity.method_23318(), this.chaosSpawnerEntity.method_23321(), class_3417.field_14588, this.chaosSpawnerEntity.method_5634(), 3.0f, 1.0f + (this.chaosSpawnerEntity.method_6051().method_43057() - this.chaosSpawnerEntity.method_6051().method_43057()) * 0.2f);
        for (int i = 0; i < 16; ++i) {
            vec3 = vec3.method_1024((float)Math.toRadians(22.5) * (float)i);
            ChaosSpawnerProjectileEntity chaosSpawnerProjectileEntity = new ChaosSpawnerProjectileEntity((class_1309)this.chaosSpawnerEntity, vec3.field_1352, vec3.field_1351, vec3.field_1350);
            chaosSpawnerProjectileEntity.method_5814(chaosSpawnerProjectileEntity.method_23317() + vec3.field_1352, chaosSpawnerProjectileEntity.method_23323(0.5) + vec3.field_1351, chaosSpawnerProjectileEntity.method_23321() + vec3.field_1350);
            this.chaosSpawnerEntity.method_37908().method_8649((class_1297)chaosSpawnerProjectileEntity);
        }
    }

    private void vecFromCenterToFrontOfFace(float angle) {
        double viewDistance = 2.0;
        class_243 viewVector = this.chaosSpawnerEntity.method_5828(1.0f);
        if (angle != 0.0f) {
            float offset = (float)Math.toRadians(angle);
            viewVector = viewVector.method_1024(offset);
        }
        double d0 = viewVector.field_1352 * viewDistance;
        double d1 = viewVector.field_1351 * viewDistance;
        double d2 = viewVector.field_1350 * viewDistance;
        ChaosSpawnerProjectileEntity chaosSpawnerProjectileEntity = new ChaosSpawnerProjectileEntity((class_1309)this.chaosSpawnerEntity, d0, d1, d2);
        chaosSpawnerProjectileEntity.method_5814(chaosSpawnerProjectileEntity.method_23317() + d0, chaosSpawnerProjectileEntity.method_23323(0.5) + d1, chaosSpawnerProjectileEntity.method_23321() + d2);
        this.chaosSpawnerEntity.method_37908().method_8649((class_1297)chaosSpawnerProjectileEntity);
    }
}

