/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class ChaosSpawnerBarrierCenterBlock
extends class_2248
implements class_3737 {
    public static final class_2753 FACING = class_2741.field_12525;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected static final class_265 NORTH_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final class_265 SOUTH_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)15.0);
    protected static final class_265 EAST_AABB = class_2248.method_9541((double)14.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final class_265 WEST_AABB = class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final class_265 UP_AABB = class_2248.method_9541((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final class_265 DOWN_AABB = class_2248.method_9541((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final ImmutableList<class_2338> BLOCK_LOCATIONS_X = ImmutableList.of((Object)new class_2338(0, 2, 0), (Object)new class_2338(0, 2, 2), (Object)new class_2338(0, 0, 2), (Object)new class_2338(0, -2, 2), (Object)new class_2338(0, -2, 0), (Object)new class_2338(0, -2, -2), (Object)new class_2338(0, 0, -2), (Object)new class_2338(0, 2, -2));
    private static final ImmutableList<class_2338> BLOCK_LOCATIONS_Y = ImmutableList.of((Object)new class_2338(2, 0, 0), (Object)new class_2338(2, 0, 2), (Object)new class_2338(0, 0, 2), (Object)new class_2338(-2, 0, 2), (Object)new class_2338(-2, 0, 0), (Object)new class_2338(-2, 0, -2), (Object)new class_2338(0, 0, -2), (Object)new class_2338(2, 0, -2));
    private static final ImmutableList<class_2338> BLOCK_LOCATIONS_Z = ImmutableList.of((Object)new class_2338(0, 2, 0), (Object)new class_2338(2, 2, 0), (Object)new class_2338(2, 0, 0), (Object)new class_2338(2, -2, 0), (Object)new class_2338(0, -2, 0), (Object)new class_2338(-2, -2, 0), (Object)new class_2338(-2, 0, 0), (Object)new class_2338(-2, 2, 0));
    private static final ImmutableList<class_2338> BARRIER_LOCATIONS_X = ImmutableList.of((Object)new class_2338(0, 1, 0), (Object)new class_2338(0, 1, -1), (Object)new class_2338(0, 0, -1), (Object)new class_2338(0, -1, -1), (Object)new class_2338(0, -1, 0), (Object)new class_2338(0, -1, 1), (Object)new class_2338(0, 0, 1), (Object)new class_2338(0, 1, 1));
    private static final ImmutableList<class_2338> BARRIER_LOCATIONS_Y = ImmutableList.of((Object)new class_2338(1, 0, 0), (Object)new class_2338(1, 0, -1), (Object)new class_2338(0, 0, -1), (Object)new class_2338(-1, 0, -1), (Object)new class_2338(-1, 0, 0), (Object)new class_2338(-1, 0, 1), (Object)new class_2338(0, 0, 1), (Object)new class_2338(1, 0, 1));
    private static final ImmutableList<class_2338> BARRIER_LOCATIONS_Z = ImmutableList.of((Object)new class_2338(0, 1, 0), (Object)new class_2338(-1, 1, 0), (Object)new class_2338(-1, 0, 0), (Object)new class_2338(-1, -1, 0), (Object)new class_2338(0, -1, 0), (Object)new class_2338(1, -1, 0), (Object)new class_2338(1, 0, 0), (Object)new class_2338(1, 1, 0));

    public ChaosSpawnerBarrierCenterBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateBuilder) {
        stateBuilder.method_11667(new class_2769[]{FACING, WATERLOGGED});
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        switch ((class_2350)blockState.method_11654((class_2769)FACING)) {
            default: {
                return NORTH_AABB;
            }
            case field_11034: {
                return EAST_AABB;
            }
            case field_11035: {
                return SOUTH_AABB;
            }
            case field_11039: {
                return WEST_AABB;
            }
            case field_11036: {
                return UP_AABB;
            }
            case field_11033: 
        }
        return DOWN_AABB;
    }

    public class_2680 method_9598(class_2680 blockState, class_2470 rotation) {
        return (class_2680)blockState.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)blockState.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 blockState, class_2415 mirror) {
        return blockState.method_26186(mirror.method_10345((class_2350)blockState.method_11654((class_2769)FACING)));
    }

    @NotNull
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9605(class_1750 blockPlaceContext) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)blockPlaceContext.method_7715().method_10153());
    }

    public static void checkBarrierCondition(class_1937 level, class_2338 blockPos, class_2350.class_2351 direction) {
        if (level.method_8320(blockPos).method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get())) {
            class_2338 offsetAmount;
            UnmodifiableIterator iterator = null;
            if (direction == class_2350.class_2351.field_11048) {
                iterator = BLOCK_LOCATIONS_X.iterator();
            } else if (direction == class_2350.class_2351.field_11052) {
                iterator = BLOCK_LOCATIONS_Y.iterator();
            } else if (direction == class_2350.class_2351.field_11051) {
                iterator = BLOCK_LOCATIONS_Z.iterator();
            }
            int brokenFrame = 0;
            while (iterator.hasNext() && !level.method_8320(blockPos.method_10081((class_2382)(offsetAmount = (class_2338)iterator.next()))).method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_DIAMOND_EDGE.get()) && !level.method_8320(blockPos.method_10081((class_2382)offsetAmount)).method_27852((class_2248)DNLBlocks.CHAOS_SPAWNER_DIAMOND_VERTEX.get())) {
                ++brokenFrame;
            }
            if (brokenFrame == 8) {
                level.method_22352(blockPos, false);
                UnmodifiableIterator barrierIterator = null;
                if (direction == class_2350.class_2351.field_11048) {
                    barrierIterator = BARRIER_LOCATIONS_X.iterator();
                } else if (direction == class_2350.class_2351.field_11052) {
                    barrierIterator = BARRIER_LOCATIONS_Y.iterator();
                } else if (direction == class_2350.class_2351.field_11051) {
                    barrierIterator = BARRIER_LOCATIONS_Z.iterator();
                }
                while (barrierIterator.hasNext()) {
                    class_2338 breakPos = blockPos.method_10081((class_2382)((class_2338)barrierIterator.next()));
                    level.method_22352(breakPos, false);
                }
            }
        }
    }

    public static void placeBarrier(class_1937 level, class_2338 blockPos, int direction) {
        if (direction == 0) {
            level.method_8652(blockPos, (class_2680)((class_2680)((class_2248)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get()).method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (direction == 1) {
            level.method_8652(blockPos, (class_2680)((class_2680)((class_2248)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get()).method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11034)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (direction == 2) {
            level.method_8652(blockPos, (class_2680)((class_2680)((class_2248)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get()).method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11035)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (direction == 3) {
            level.method_8652(blockPos, (class_2680)((class_2680)((class_2248)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get()).method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11039)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (direction == 4) {
            level.method_8652(blockPos, (class_2680)((class_2680)((class_2248)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get()).method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11036)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (direction == 5) {
            level.method_8652(blockPos, (class_2680)((class_2680)((class_2248)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get()).method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11033)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }
}

