/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import dev.xylonity.knightlib.compat.registry.KnightLibParticles;
import dev.xylonity.knightquest.common.entity.entities.EldBombEntity;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestEntities;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EldKnightEntity
extends class_1588
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final class_1937 serverWorld;
    private boolean summoned = false;
    private int counter;

    public EldKnightEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.serverWorld = world;
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23716, 90.0).method_26868(class_5134.field_23721, 12.0).method_26868(class_5134.field_23723, (double)0.4f).method_26868(class_5134.field_23719, (double)0.55f).method_26868(class_5134.field_23718, (double)0.8f);
    }

    @Nullable
    public class_1315 method_5943(class_5425 pLevel, class_1266 pDifficulty, class_3730 pReason, @Nullable class_1315 pSpawnData, @Nullable class_2487 pDataTag) {
        class_1324 maxHealth = this.method_5996(class_5134.field_23716);
        if (maxHealth != null) {
            maxHealth.method_6192(KQConfigValues.ELDKNIGHT_MAX_HEALTH);
            this.method_6033((float)KQConfigValues.ELDKNIGHT_MAX_HEALTH);
        }
        return super.method_5943(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)this, 0.45, false));
        this.field_6201.method_6277(2, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackcontroller", 0, this::attackPredicate)});
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        if (this.field_6252 && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            this.field_6252 = false;
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    protected class_3414 method_5737() {
        return class_3417.field_28293;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15055;
    }

    protected class_3414 method_6011(@NotNull class_1282 pDamageSource) {
        return class_3417.field_14959;
    }

    protected void method_5712(@NotNull class_2338 pPos, @NotNull class_2680 pState) {
        this.method_5783(class_3417.field_15233, 0.15f, 1.0f);
    }

    public void method_5773() {
        super.method_5773();
        ++this.counter;
        if (!this.summoned && (double)this.method_6032() < (double)this.method_6063() * 0.5) {
            this.summoned = true;
            this.summonMinions();
        }
        if (this.summoned && this.counter > 80) {
            if (KQConfigValues.POISON_ELDKNIGHT) {
                this.summonParticle();
                this.poisonNearbyPlayers();
            }
            if ((double)this.method_6032() < (double)this.method_6063() * 0.75) {
                this.method_6025(KQConfigValues.HEAL_ELDKNIGHT);
            }
            this.counter = 0;
        }
    }

    public boolean method_5643(class_1282 pSource, float pAmount) {
        if (pSource.method_49708(class_8111.field_42332) || pSource.method_49708(class_8111.field_42331)) {
            return super.method_5643(pSource, pAmount * 0.15f);
        }
        if (pSource.method_49708(class_8111.field_42321)) {
            return super.method_5643(pSource, pAmount * 0.1f);
        }
        return super.method_5643(pSource, pAmount);
    }

    private void summonMinions() {
        double distance = 3.0;
        double angle = KQConfigValues.HEAL_ELDKNIGHT != 0.0f ? Math.toRadians(360.0 / (double)KQConfigValues.NUM_ELDBOMB_ELDKNIGHT) : Math.toRadians(120.0);
        boolean punch = false;
        for (int i = 0; i < KQConfigValues.NUM_ELDBOMB_ELDKNIGHT; ++i) {
            double xOffset = distance * Math.cos(angle * (double)i);
            double zOffset = distance * Math.sin(angle * (double)i);
            EldBombEntity entity = (EldBombEntity)KnightQuestEntities.ELDBOMB.method_5883(this.serverWorld);
            if (entity == null) continue;
            class_2338 spawnPos = this.method_24515().method_10069((int)xOffset, 0, (int)zOffset);
            if (!this.serverWorld.method_8320(spawnPos).method_26215()) {
                int d = 1;
                while ((double)d <= distance) {
                    class_2338 adjustedPos = this.method_24515().method_10069((int)(xOffset / (double)d), 0, (int)(zOffset / (double)d));
                    if (this.serverWorld.method_8320(adjustedPos).method_26215()) {
                        spawnPos = adjustedPos;
                        break;
                    }
                    ++d;
                }
            }
            entity.method_5725(spawnPos, 0.0f, 0.0f);
            this.serverWorld.method_8649((class_1297)entity);
            for (int j = 0; j < 20; ++j) {
                this.serverWorld.method_8406((class_2394)class_2398.field_11245, (double)spawnPos.method_10263() + 0.5 + this.serverWorld.field_9229.method_43058() - 0.5, (double)spawnPos.method_10264() + 0.5 + this.serverWorld.field_9229.method_43058() - 0.5, (double)spawnPos.method_10260() + 0.5 + this.serverWorld.field_9229.method_43058() - 0.5, 0.0, 0.0, 0.0);
            }
            if (punch) continue;
            this.serverWorld.method_18467(class_1657.class, entity.method_5829().method_1014(5.0)).forEach(player -> {
                class_243 direction = player.method_19538().method_1020(this.method_19538()).method_1029().method_1021(1.5);
                player.method_5762(direction.field_1352, direction.field_1351 + 0.5, direction.field_1350);
            });
            punch = true;
        }
        int particleCount = 120;
        double particleRadius = 4.0;
        for (int i = 0; i < particleCount; ++i) {
            double angleOffset = Math.PI * 2 / (double)particleCount * (double)i;
            double xParticleOffset = particleRadius * Math.cos(angleOffset);
            double zParticleOffset = particleRadius * Math.sin(angleOffset);
            this.serverWorld.method_8406((class_2394)class_2398.field_11204, this.method_23317() + xParticleOffset, this.method_23318() - 0.1, this.method_23321() + zParticleOffset, 0.0, 0.05, 0.0);
        }
        this.serverWorld.method_8396(null, this.method_24515(), class_3417.field_15193, class_3419.field_15245, 1.0f, 1.0f);
    }

    private void poisonNearbyPlayers() {
        this.serverWorld.method_18467(class_1657.class, this.method_5829().method_1014(3.5)).forEach(player -> player.method_6092(new class_1293(class_1294.field_5899, 200, 0)));
    }

    private void summonParticle() {
        this.serverWorld.method_8406((class_2394)KnightLibParticles.STARSET_PARTICLE, this.method_23317(), this.method_23318() - 0.48, this.method_23321(), 4.0, 0.0, 0.0);
    }
}

