/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_174;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2668;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class AbstractSwampmanAxeEntity
extends class_1676 {
    private static final class_2940<Byte> ID_FLAGS = class_2945.method_12791(AbstractSwampmanAxeEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Byte> PIERCE_LEVEL = class_2945.method_12791(AbstractSwampmanAxeEntity.class, (class_2941)class_2943.field_13319);
    @Nullable
    private class_2680 lastState;
    protected boolean inGround;
    protected int inGroundTime;
    public class_1665.class_1666 pickup = class_1665.class_1666.field_7592;
    public int shakeTime;
    private int life;
    private double baseDamage = 2.0;
    private int knockback;
    private class_3414 soundEvent = this.getDefaultHitGroundSoundEvent();
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<class_1297> piercedAndKilledEntities;
    private final IntOpenHashSet ignoredEntities = new IntOpenHashSet();

    protected AbstractSwampmanAxeEntity(class_1299<? extends AbstractSwampmanAxeEntity> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
    }

    protected AbstractSwampmanAxeEntity(class_1299<? extends AbstractSwampmanAxeEntity> pEntityType, double pX, double pY, double pZ, class_1937 pLevel) {
        this(pEntityType, pLevel);
        this.method_5814(pX, pY, pZ);
    }

    protected AbstractSwampmanAxeEntity(class_1299<? extends AbstractSwampmanAxeEntity> pEntityType, class_1309 pShooter, class_1937 pLevel) {
        this(pEntityType, pShooter.method_23317(), pShooter.method_23320() - (double)0.1f, pShooter.method_23321(), pLevel);
        this.method_7432((class_1297)pShooter);
    }

    public void setSoundEvent(class_3414 pSoundEvent) {
        this.soundEvent = pSoundEvent;
    }

    public boolean method_5640(double pDistance) {
        double d0 = this.method_5829().method_995() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return pDistance < (d0 *= 64.0 * AbstractSwampmanAxeEntity.method_5824()) * d0;
    }

    protected void method_5693() {
        this.field_6011.method_12784(ID_FLAGS, (Object)0);
        this.field_6011.method_12784(PIERCE_LEVEL, (Object)0);
    }

    public void method_7485(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        super.method_7485(pX, pY, pZ, pVelocity, pInaccuracy);
        this.life = 0;
    }

    public void method_5759(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
        this.method_5814(pX, pY, pZ);
        this.method_5710(pYaw, pPitch);
    }

    public void method_5750(double pX, double pY, double pZ) {
        super.method_5750(pX, pY, pZ);
        this.life = 0;
    }

    public void method_5773() {
        class_265 voxelShape;
        super.method_5773();
        boolean noClip = this.isNoPhysics();
        class_243 motion = this.method_18798();
        if (this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            double horizontalDistance = motion.method_37267();
            this.method_36456((float)(class_3532.method_15349((double)motion.field_1352, (double)motion.field_1350) * 57.29577951308232));
            this.method_36457((float)(class_3532.method_15349((double)motion.field_1351, (double)horizontalDistance) * 57.29577951308232));
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        }
        if (!this.inGround) {
            this.field_6004 = this.method_36455() + 60.0f;
        }
        class_2338 blockPos = this.method_24515();
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        if (!(blockState.method_26215() || noClip || (voxelShape = blockState.method_26220((class_1922)this.method_37908(), blockPos)).method_1110())) {
            class_243 position = this.method_19538();
            for (class_238 aabb : voxelShape.method_1090()) {
                if (!aabb.method_996(blockPos).method_1006(position)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.method_5721() || blockState.method_27852(class_2246.field_27879)) {
            this.method_5646();
        }
        if (this.inGround && !noClip) {
            if (this.lastState != blockState && this.shouldFall()) {
                this.startFalling();
            } else if (!this.method_37908().method_8608()) {
                this.tickDespawn();
            }
            ++this.inGroundTime;
        } else {
            this.inGroundTime = 0;
            class_243 position = this.method_19538();
            class_243 nextPosition = position.method_1019(motion);
            class_3965 hitResult = this.method_37908().method_17742(new class_3959(position, nextPosition, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            if (hitResult.method_17783() != class_239.class_240.field_1333) {
                nextPosition = hitResult.method_17784();
            }
            while (!this.method_31481()) {
                class_3966 entityHitResult = this.findHitEntity(position, nextPosition);
                if (entityHitResult != null) {
                    hitResult = entityHitResult;
                }
                if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1331) {
                    class_1297 entity = ((class_3966)hitResult).method_17782();
                    class_1297 owner = this.method_24921();
                    if (entity instanceof class_1657 && owner instanceof class_1657 && !((class_1657)owner).method_7256((class_1657)entity)) {
                        hitResult = null;
                        entityHitResult = null;
                    }
                }
                if (hitResult != null && !noClip) {
                    this.method_7488((class_239)hitResult);
                    this.field_6007 = true;
                }
                if (entityHitResult == null || this.getPierceLevel() <= 0) break;
                hitResult = null;
            }
            motion = this.method_18798();
            double dX = motion.field_1352;
            double dY = motion.field_1351;
            double dZ = motion.field_1350;
            if (this.isCritArrow()) {
                for (int i = 0; i < 4; ++i) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11205, this.method_23317() + dX * (double)i / 4.0, this.method_23318() + dY * (double)i / 4.0, this.method_23321() + dZ * (double)i / 4.0, -dX, -dY + 0.2, -dZ);
                }
            }
            double nextX = this.method_23317() + dX;
            double nextY = this.method_23318() + dY;
            double nextZ = this.method_23321() + dZ;
            double horizontalDistance = motion.method_37267();
            if (noClip) {
                this.method_36456((float)(class_3532.method_15349((double)(-dX), (double)(-dZ)) * 57.29577951308232));
            } else {
                this.method_36456((float)(class_3532.method_15349((double)dX, (double)dZ) * 57.29577951308232));
            }
            this.method_36457((float)(class_3532.method_15349((double)dY, (double)horizontalDistance) * 57.29577951308232));
            this.method_36457(AbstractSwampmanAxeEntity.method_26960((float)this.field_6004, (float)this.method_36455()));
            this.method_36456(AbstractSwampmanAxeEntity.method_26960((float)this.field_5982, (float)this.method_36454()));
            float drag = 0.99f;
            if (this.method_5799()) {
                for (int j = 0; j < 4; ++j) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11247, nextX - dX * 0.25, nextY - dY * 0.25, nextZ - dZ * 0.25, dX, dY, dZ);
                }
                drag = this.getWaterInertia();
            }
            this.method_18799(motion.method_18805((double)drag, (double)drag, (double)drag));
            if (!this.method_5740() && !noClip) {
                class_243 newMotion = this.method_18798();
                this.method_18800(newMotion.field_1352, newMotion.field_1351 - 0.05, newMotion.field_1350);
            }
            this.method_5814(nextX, nextY, nextZ);
            this.method_5852();
        }
    }

    private boolean shouldFall() {
        return this.inGround && this.method_37908().method_18026(new class_238(this.method_19538(), this.method_19538()).method_1014(0.06));
    }

    private void startFalling() {
        this.inGround = false;
        class_243 vec3 = this.method_18798();
        this.method_18799(vec3.method_18805((double)(this.field_5974.method_43057() * 0.2f), (double)(this.field_5974.method_43057() * 0.2f), (double)(this.field_5974.method_43057() * 0.2f)));
        this.life = 0;
    }

    public void method_5784(@NotNull class_1313 pType, @NotNull class_243 pPos) {
        super.method_5784(pType, pPos);
        if (pType != class_1313.field_6308 && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        ++this.life;
        if (this.life >= 1200) {
            this.method_31472();
        }
    }

    private void resetPiercedEntities() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    protected void method_7454(@NotNull class_3966 pResult) {
        class_1282 damagesource;
        class_1297 entity1;
        super.method_7454(pResult);
        class_1297 entity = pResult.method_17782();
        float f = (float)this.method_18798().method_1033();
        this.method_36457(0.0f);
        this.field_6004 = 0.0f;
        int i = class_3532.method_15384((double)class_3532.method_15350((double)((double)f * this.baseDamage), (double)0.0, (double)2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
                this.method_31472();
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.method_5628());
        }
        if (this.isCritArrow()) {
            long j = this.field_5974.method_43048(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if ((entity1 = this.method_24921()) == null) {
            damagesource = this.method_48923().method_48830();
        } else {
            damagesource = this.method_48923().method_48830();
            if (entity1 instanceof class_1309) {
                ((class_1309)entity1).method_6114(entity);
            }
        }
        boolean flag = entity.method_5864() == class_1299.field_6091;
        int k = entity.method_20802();
        if (this.method_5809() && !flag) {
            entity.method_5639(5);
        }
        if (entity.method_5643(damagesource, (float)i)) {
            if (flag) {
                return;
            }
            if (entity instanceof class_1309) {
                class_1309 livingentity = (class_1309)entity;
                if (this.knockback > 0) {
                    double d0 = Math.max(0.0, 1.0 - livingentity.method_26825(class_5134.field_23718));
                    class_243 vec3 = this.method_18798().method_18805(1.0, 0.0, 1.0).method_1029().method_1021((double)this.knockback * 0.6 * d0);
                    if (vec3.method_1027() > 0.0) {
                        livingentity.method_5762(vec3.field_1352, 0.1, vec3.field_1350);
                    }
                }
                if (!this.method_37908().field_9236 && entity1 instanceof class_1309) {
                    class_1890.method_8210((class_1309)livingentity, (class_1297)entity1);
                    class_1890.method_8213((class_1309)((class_1309)entity1), (class_1297)livingentity);
                }
                this.doPostHurtEffects(livingentity);
                if (livingentity != entity1 && livingentity instanceof class_1657 && entity1 instanceof class_3222 && !this.method_5701()) {
                    ((class_3222)entity1).field_13987.method_14364((class_2596)new class_2668(class_2668.field_25651, 0.0f));
                }
                if (!entity.method_5805() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add((class_1297)livingentity);
                }
                if (!this.method_37908().field_9236 && entity1 instanceof class_3222) {
                    class_3222 serverplayer = (class_3222)entity1;
                    if (this.piercedAndKilledEntities != null && this.shotFromCrossbow()) {
                        class_174.field_1197.method_8980(serverplayer, this.piercedAndKilledEntities);
                    } else if (!entity.method_5805() && this.shotFromCrossbow()) {
                        class_174.field_1197.method_8980(serverplayer, List.of(entity));
                    }
                }
            }
            this.method_5783(this.soundEvent, 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.method_31472();
            }
        } else {
            entity.method_20803(k);
            this.method_18799(this.method_18798().method_1021(-0.1));
            this.method_36456(this.method_36454() + 180.0f);
            this.field_5982 += 180.0f;
            if (!this.method_37908().field_9236 && this.method_18798().method_1027() < 1.0E-7) {
                this.method_31472();
            }
        }
    }

    protected void method_24920(class_3965 pResult) {
        this.lastState = this.method_37908().method_8320(pResult.method_17777());
        super.method_24920(pResult);
        class_243 vec3 = pResult.method_17784().method_1023(this.method_23317(), this.method_23318(), this.method_23321());
        this.method_18799(vec3);
        class_243 vec31 = vec3.method_1029().method_1021((double)0.05f);
        this.method_23327(this.method_23317() - vec31.field_1352, this.method_23318() - vec31.field_1351, this.method_23321() - vec31.field_1350);
        this.method_5783(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
        this.inGround = true;
        this.shakeTime = 7;
        this.setCritArrow(false);
        this.setPierceLevel((byte)0);
        this.setSoundEvent(class_3417.field_15151);
        this.setShotFromCrossbow(false);
        this.resetPiercedEntities();
    }

    protected class_3414 getDefaultHitGroundSoundEvent() {
        return class_3417.field_15151;
    }

    protected final class_3414 getHitGroundSoundEvent() {
        return this.soundEvent;
    }

    protected void doPostHurtEffects(class_1309 pTarget) {
    }

    @Nullable
    protected class_3966 findHitEntity(class_243 pStartVec, class_243 pEndVec) {
        return class_1675.method_18077((class_1937)this.method_37908(), (class_1297)this, (class_243)pStartVec, (class_243)pEndVec, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), this::method_26958);
    }

    protected boolean method_26958(@NotNull class_1297 pEntity) {
        return super.method_26958(pEntity) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(pEntity.method_5628())) && !this.ignoredEntities.contains(pEntity.method_5628());
    }

    public void method_5652(@NotNull class_2487 pCompound) {
        super.method_5652(pCompound);
        pCompound.method_10575("life", (short)this.life);
        if (this.lastState != null) {
            pCompound.method_10566("inBlockState", (class_2520)class_2512.method_10686((class_2680)this.lastState));
        }
        pCompound.method_10567("shake", (byte)this.shakeTime);
        pCompound.method_10556("inGround", this.inGround);
        pCompound.method_10567("pickup", (byte)this.pickup.ordinal());
        pCompound.method_10549("damage", this.baseDamage);
        pCompound.method_10556("crit", this.isCritArrow());
        pCompound.method_10567("PierceLevel", this.getPierceLevel());
        pCompound.method_10582("SoundEvent", class_7923.field_41172.method_10221((Object)this.soundEvent).toString());
        pCompound.method_10556("ShotFromCrossbow", this.shotFromCrossbow());
    }

    public void method_5749(@NotNull class_2487 pCompound) {
        super.method_5749(pCompound);
        this.life = pCompound.method_10568("life");
        if (pCompound.method_10573("inBlockState", 10)) {
            this.lastState = class_2512.method_10681((class_7871)this.method_37908().method_45448(class_7924.field_41254), (class_2487)pCompound.method_10562("inBlockState"));
        }
        this.shakeTime = pCompound.method_10571("shake") & 0xFF;
        this.inGround = pCompound.method_10577("inGround");
        if (pCompound.method_10573("damage", 99)) {
            this.baseDamage = pCompound.method_10574("damage");
        }
        this.pickup = class_1665.class_1666.method_7458((int)pCompound.method_10571("pickup"));
        this.setCritArrow(pCompound.method_10577("crit"));
        this.setPierceLevel(pCompound.method_10571("PierceLevel"));
        if (pCompound.method_10573("SoundEvent", 8)) {
            this.soundEvent = class_7923.field_41172.method_17966(new class_2960(pCompound.method_10558("SoundEvent"))).orElse(this.getDefaultHitGroundSoundEvent());
        }
        this.setShotFromCrossbow(pCompound.method_10577("ShotFromCrossbow"));
    }

    public void method_7432(@Nullable class_1297 pEntity) {
        super.method_7432(pEntity);
        if (pEntity instanceof class_1657) {
            this.pickup = ((class_1657)pEntity).method_31549().field_7477 ? class_1665.class_1666.field_7594 : class_1665.class_1666.field_7593;
        }
    }

    public void method_5694(@NotNull class_1657 pEntity) {
        if (!this.method_37908().field_9236 && (this.inGround || this.isNoPhysics()) && this.shakeTime <= 0 && this.tryPickup(pEntity)) {
            pEntity.method_6103((class_1297)this, 1);
            this.method_31472();
        }
    }

    protected boolean tryPickup(class_1657 pPlayer) {
        if (Objects.requireNonNull(this.pickup) == class_1665.class_1666.field_7594) {
            return pPlayer.method_31549().field_7477;
        }
        return false;
    }

    @NotNull
    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public boolean method_5732() {
        return false;
    }

    protected float method_18378(@NotNull class_4050 pPose, @NotNull class_4048 pSize) {
        return 0.13f;
    }

    public void setCritArrow(boolean pCritArrow) {
        this.setFlag(1, pCritArrow);
    }

    public void setPierceLevel(byte pPierceLevel) {
        this.field_6011.method_12778(PIERCE_LEVEL, (Object)pPierceLevel);
    }

    private void setFlag(int pId, boolean pValue) {
        byte b0 = (Byte)this.field_6011.method_12789(ID_FLAGS);
        if (pValue) {
            this.field_6011.method_12778(ID_FLAGS, (Object)((byte)(b0 | pId)));
        } else {
            this.field_6011.method_12778(ID_FLAGS, (Object)((byte)(b0 & ~pId)));
        }
    }

    public boolean isCritArrow() {
        byte b0 = (Byte)this.field_6011.method_12789(ID_FLAGS);
        return (b0 & 1) != 0;
    }

    public boolean shotFromCrossbow() {
        byte b0 = (Byte)this.field_6011.method_12789(ID_FLAGS);
        return (b0 & 4) != 0;
    }

    public byte getPierceLevel() {
        return (Byte)this.field_6011.method_12789(PIERCE_LEVEL);
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public boolean isNoPhysics() {
        if (!this.method_37908().field_9236) {
            return this.field_5960;
        }
        return ((Byte)this.field_6011.method_12789(ID_FLAGS) & 2) != 0;
    }

    public void setShotFromCrossbow(boolean pShotFromCrossbow) {
        this.setFlag(4, pShotFromCrossbow);
    }
}

