/*
 * Decompiled with CFR 0.152.
 */
package team.dovecotmc.glasses.util.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.apache.commons.io.FileUtils;
import team.dovecotmc.glasses.Glasses;
import team.dovecotmc.glasses.client.config.DisplayOffset;
import team.dovecotmc.glasses.client.integration.trinkets.GlassesRenderer;
import team.dovecotmc.glasses.client.integration.trinkets.TrinketsClientIntegration;
import team.dovecotmc.glasses.client.keybinding.KeyBindingRef;
import team.dovecotmc.glasses.mixin.client.AccessorKeyMapping;

public class ClientUtilities {
    public static final Path glassesDir = FabricLoader.getInstance().getConfigDir().resolve("glasses");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void modifyOffset4GlassesWorn(class_1657 player, Consumer<GlassesRenderer> modifier) {
        if (!Glasses.isTrinketsLoaded() || player == null) {
            return;
        }
        TrinketsClientIntegration.modifyOffset(player, modifier);
    }

    public static Optional<DisplayOffset> getOffsetConfig(String glassesName) {
        if (!glassesDir.toFile().isDirectory()) {
            try {
                Files.createDirectories(glassesDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                Glasses.LOGGER.error("Failed to create directory for display offset configs!", (Throwable)e);
                return Optional.empty();
            }
        }
        Path cfgPath = ClientUtilities.getGlassesOffsetPath(glassesName);
        DisplayOffset config = new DisplayOffset();
        if (cfgPath.toFile().isFile()) {
            try {
                config = (DisplayOffset)GSON.fromJson(FileUtils.readFileToString((File)cfgPath.toFile(), (Charset)StandardCharsets.UTF_8), DisplayOffset.class);
                return Optional.of(config);
            }
            catch (IOException e) {
                Glasses.LOGGER.error(String.format("Failed to parse display offset config \"%s\"", cfgPath), (Throwable)e);
                FileUtils.deleteQuietly((File)cfgPath.toFile());
                return ClientUtilities.createOffsetConfig(cfgPath, config) ? Optional.of(config) : Optional.empty();
            }
        }
        return ClientUtilities.createOffsetConfig(cfgPath, config) ? Optional.of(config) : Optional.empty();
    }

    public static boolean createOffsetConfig(Path cfgPath, DisplayOffset config) {
        try {
            FileUtils.write((File)cfgPath.toFile(), (CharSequence)GSON.toJson((Object)config), (Charset)StandardCharsets.UTF_8);
            return true;
        }
        catch (IOException e) {
            Glasses.LOGGER.error(String.format("Failed to create display offset config \"%s\"", cfgPath), (Throwable)e);
            return false;
        }
    }

    public static void saveOffsetConfig(Path cfgPath, DisplayOffset config) {
        try {
            FileUtils.write((File)cfgPath.toFile(), (CharSequence)GSON.toJson((Object)config), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Glasses.LOGGER.error(String.format("Failed to save display offset config \"%s\"", cfgPath), (Throwable)e);
        }
    }

    public static Path getGlassesOffsetPath(String glassesName) {
        return glassesDir.resolve(String.format("%s.json", glassesName));
    }

    public static void remindPlayer(class_1657 player, class_1799 stack) {
        player.method_7353((class_2561)class_2561.method_43469((String)"msg.glasses.offset.needs_save", (Object[])new Object[]{class_2561.method_43471((String)stack.method_7909().method_7876()), ((AccessorKeyMapping)KeyBindingRef.GLASSES_OFFSET_SAVE.get()).getKey().method_27445(), ((AccessorKeyMapping)KeyBindingRef.GLASSES_OFFSET_RELOAD.get()).getKey().method_27445()}).method_27692(class_124.field_1075), true);
    }
}

