/*
 * Decompiled with CFR 0.152.
 */
package team.dovecotmc.glasses.common.info;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import team.dovecotmc.glasses.common.ref.ItemRef;

public enum Artisan {
    GREYGOD("greygod", class_2583.field_24360.method_27706(class_124.field_1075), UUID.fromString("6330f713-a08f-4f9e-83ab-4e0d73a8743f"), () -> List.of(ItemRef.GLASSES_7.get().method_7854())),
    TAPIO("tapio", class_2583.field_24360.method_27706(class_124.field_1065), UUID.fromString("932adb0c-597c-482b-ab5a-296a9a9fee65"), () -> List.of(ItemRef.GLASSES_4.get().method_7854())),
    SHOU_ZHANG("shou_zhang", class_2583.field_24360.method_27706(class_124.field_1078), UUID.fromString("941c9a4f-55b0-4201-8d99-60fe3065cbee"), () -> List.of(ItemRef.GLASSES_11.get().method_7854()));

    private final String id;
    private final class_2583 style;
    private final UUID uuid;
    private final Supplier<List<class_1799>> glassesToGive;

    private Artisan(String id, class_2583 style, UUID uuid, Supplier<List<class_1799>> glassesToGive) {
        this.id = id;
        this.style = style;
        this.uuid = uuid;
        this.glassesToGive = glassesToGive;
    }

    public class_2561 getName() {
        return class_2561.method_43471((String)("artisan.glasses." + this.id)).method_27696(this.style);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public List<class_1799> getGlassesToGive() {
        return this.glassesToGive.get();
    }

    public static class Cache {
        private static Map<UUID, List<class_1799>> glassesToGive;

        private static void initGlassesToGive() {
            if (glassesToGive == null) {
                glassesToGive = Arrays.stream(Artisan.values()).collect(Collectors.toMap(a -> a.uuid, Artisan::getGlassesToGive));
            }
        }

        public static List<class_1799> getGlassesToGive(UUID uuid) {
            Cache.initGlassesToGive();
            return glassesToGive.getOrDefault(uuid, Collections.emptyList());
        }

        public static boolean shouldGiveGlasses(UUID uuid) {
            Cache.initGlassesToGive();
            return glassesToGive.containsKey(uuid);
        }
    }
}

