/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.world.gen.structure;

import com.google.common.collect.Maps;
import com.ninni.species.loot.SpeciesLootTables;
import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.registry.SpeciesStructurePieceTypes;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3470;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3793;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import net.minecraft.class_8174;

public class PaleontologyDigSiteGenerator {
    public static final Map<class_2960, Integer> HEIGHT_TO_TEMPLATES = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        map.put(new class_2960("species", "paleontology_dig_site/dig_site_bigger"), 9);
        map.put(new class_2960("species", "paleontology_dig_site/dig_site_crippler"), 6);
        map.put(new class_2960("species", "paleontology_dig_site/dig_site_gripper"), 7);
        map.put(new class_2960("species", "paleontology_dig_site/dig_site_extender"), 3);
        map.put(new class_2960("species", "paleontology_dig_site/dig_site_grinner"), 1);
        map.put(new class_2960("species", "paleontology_dig_site/dig_site_lilypadder"), 7);
        map.put(new class_2960("species", "paleontology_dig_site/dig_site_loser"), 3);
        map.put(new class_2960("species", "paleontology_dig_site/dig_site_shimmer_shell"), 7);
        map.put(new class_2960("species", "paleontology_dig_site/dig_site_shimmer_tail"), 5);
        map.put(new class_2960("species", "paleontology_dig_site/dig_site_stroker"), 2);
        map.put(new class_2960("species", "paleontology_dig_site/dig_site_trampler"), 6);
        map.put(new class_2960("species", "paleontology_dig_site/dig_site_tremor"), 4);
        map.put(new class_2960("species", "paleontology_dig_site/dig_site_zipper"), 10);
    });

    public static void addPieces(class_3485 manager, class_2338 pos, class_6130 holder, class_5819 random) {
        Set<class_2960> resourceLocations = HEIGHT_TO_TEMPLATES.keySet();
        ArrayList templates = new ArrayList(resourceLocations.stream().toList());
        class_2960 randomTemplate = (class_2960)class_156.method_32309(templates, (class_5819)random);
        class_2470 rotation = class_2470.method_16548((class_5819)random);
        holder.method_35462((class_3443)new Piece(manager, randomTemplate, pos, rotation));
    }

    public static class Piece
    extends class_3470 {
        public static final String ROTATION_KEY = "Rotation";

        public Piece(class_3485 manager, class_2960 id, class_2338 pos, class_2470 rotation) {
            super(SpeciesStructurePieceTypes.PALEONTOLOGY_DIG_SITE, HEIGHT_TO_TEMPLATES.get(id).intValue(), manager, id, id.toString(), Piece.createPlacementData(rotation), pos);
        }

        public Piece(class_3485 manager, class_2487 nbt) {
            super(SpeciesStructurePieceTypes.PALEONTOLOGY_DIG_SITE, nbt, manager, id -> Piece.createPlacementData(class_2470.valueOf((String)nbt.method_10558(ROTATION_KEY))));
        }

        private static class_3492 createPlacementData(class_2470 rotation) {
            return new class_3492().method_15123(rotation).method_16184((class_3491)class_3793.field_16718);
        }

        protected void method_14943(class_6625 structurePieceSerializationContext, class_2487 compoundTag) {
            super.method_14943(structurePieceSerializationContext, compoundTag);
            compoundTag.method_10582(ROTATION_KEY, this.field_15434.method_15113().name());
        }

        public void method_14931(class_5281 world, class_5138 structureManager, class_2794 chunkGenerator, class_5819 randomSource, class_3341 boundingBox, class_1923 chunkPos, class_2338 blockPos) {
            class_2338 blockPos1 = this.field_15432;
            this.field_15432 = this.field_15432.method_10087(HEIGHT_TO_TEMPLATES.get(new class_2960(this.field_31664)).intValue());
            super.method_14931(world, structureManager, chunkGenerator, randomSource, boundingBox, chunkPos, blockPos);
            this.field_15432 = blockPos1;
        }

        protected void method_15026(String metadata, class_2338 pos, class_5425 world, class_5819 random, class_3341 boundingBox) {
            if (metadata.equals("COMMON")) {
                this.createRedSuspiciousSand(world, boundingBox, random, pos, SpeciesLootTables.PALEONTOLOGY_DIG_SITE_COMMON);
            }
            if (metadata.equals("RARE")) {
                this.createRedSuspiciousSand(world, boundingBox, random, pos, SpeciesLootTables.PALEONTOLOGY_DIG_SITE_RARE);
            }
            if (metadata.equals("EPIC")) {
                this.createRedSuspiciousSand(world, boundingBox, random, pos, SpeciesLootTables.PALEONTOLOGY_DIG_SITE_EPIC);
            }
        }

        protected void createRedSuspiciousSand(class_5425 serverLevelAccessor, class_3341 boundingBox, class_5819 randomSource, class_2338 blockPos, class_2960 resourceLocation) {
            boolean invalidBelowPos;
            class_2248 redSuspiciousSand = SpeciesBlocks.RED_SUSPICIOUS_SAND;
            boolean outsideBoundingBox = !boundingBox.method_14662((class_2382)blockPos);
            boolean stateIsSelf = serverLevelAccessor.method_8320(blockPos).method_27852(redSuspiciousSand);
            boolean bl = invalidBelowPos = !serverLevelAccessor.method_8320(blockPos.method_10074()).method_26206((class_1922)serverLevelAccessor, blockPos.method_10074(), class_2350.field_11036);
            if (outsideBoundingBox || stateIsSelf || invalidBelowPos) {
                return;
            }
            serverLevelAccessor.method_8652(blockPos, redSuspiciousSand.method_9564(), 2);
            class_2586 blockEntity = serverLevelAccessor.method_8321(blockPos);
            if (blockEntity instanceof class_8174) {
                class_8174 entity = (class_8174)blockEntity;
                entity.method_49216(resourceLocation, randomSource.method_43055());
            }
        }
    }
}

