/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.world.gen.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.ninni.species.registry.SpeciesBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5726;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6019;

public class AlphaceneMushroomFeature
extends class_3031<class_3111> {
    public AlphaceneMushroomFeature(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_3111> featurePlaceContext) {
        class_5281 world = featurePlaceContext.method_33652();
        class_2338 blockPos = featurePlaceContext.method_33655();
        class_5819 random = featurePlaceContext.method_33654();
        class_2680 stemBlock = class_2246.field_10556.method_9564();
        class_2680 mushroomBlock = SpeciesBlocks.ALPHACENE_MUSHROOM_BLOCK.method_9564();
        ArrayList conkPoses = Lists.newArrayList();
        boolean initialFlag = world.method_8320(blockPos.method_10074()).method_26164(class_3481.field_29822);
        if (!initialFlag) {
            return false;
        }
        class_2350 initialDirection = class_2350.class_2353.field_11062.method_10183(random);
        class_2338 initialSprialPos = blockPos.method_10086(2).method_10093(initialDirection);
        int secondLayerCount = class_6019.method_35017((int)6, (int)16).method_35008(random);
        int rotatingIndex = 3;
        int baseSize = 2;
        int elevateIndex = 2;
        int primaryStemLength = 8;
        this.placeStem(primaryStemLength, secondLayerCount, world, blockPos, stemBlock, mushroomBlock);
        this.placeBaseRoof(baseSize, blockPos, world, mushroomBlock, conkPoses);
        this.placeSpiral(initialSprialPos, primaryStemLength, initialDirection, world, mushroomBlock, elevateIndex, secondLayerCount, rotatingIndex, conkPoses);
        this.placeConks(world, random, conkPoses);
        return true;
    }

    private void placeConks(class_5281 worldGenLevel, class_5819 randomSource, List<class_2338> conkPoses) {
        for (class_2338 pos : conkPoses) {
            if (!worldGenLevel.method_22347(pos) || !worldGenLevel.method_8320(pos.method_10084()).method_27852(SpeciesBlocks.ALPHACENE_MUSHROOM_BLOCK) || randomSource.method_43048(10) == 0) continue;
            worldGenLevel.method_8652(pos, SpeciesBlocks.ALPHACENE_MUSHROOM_GROWTH.method_9564(), 2);
        }
    }

    private void placeSpiral(class_2338 initialSprialPos, int primaryStemLength, class_2350 initialDirection, class_5281 world, class_2680 mushroomBlock, int elevateIndex, int secondLayerCount, int rotatingIndex, List<class_2338> conkPoses) {
        int i;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339().method_10101((class_2382)initialSprialPos);
        for (i = 0; i < primaryStemLength; ++i) {
            if (i % 2 != 0) {
                initialDirection = initialDirection.method_10170();
            }
            if (world.method_16358((class_2338)mutableBlockPos, class_5726::method_33014)) {
                world.method_8652((class_2338)mutableBlockPos, mushroomBlock, 2);
                conkPoses.add((class_2338)mutableBlockPos);
            }
            if (i == 7 && world.method_16358(mutableBlockPos.method_10084(), class_5726::method_33014)) {
                world.method_8652(mutableBlockPos.method_10084(), mushroomBlock, 2);
                conkPoses.add((class_2338)mutableBlockPos);
            }
            mutableBlockPos.method_10098(initialDirection.method_10170());
            if (++elevateIndex % 4 != 0) continue;
            if (world.method_16358((class_2338)mutableBlockPos, class_5726::method_33014)) {
                world.method_8652((class_2338)mutableBlockPos, mushroomBlock, 2);
                conkPoses.add(mutableBlockPos.method_10074());
            }
            mutableBlockPos.method_10098(class_2350.field_11036);
        }
        mutableBlockPos.method_10098(class_2350.field_11036);
        for (i = 0; i <= secondLayerCount; ++i) {
            if (rotatingIndex % 4 == 0) {
                initialDirection = initialDirection.method_10170();
                rotatingIndex = 2;
            }
            if (i % 2 == 0 && i >= 2) {
                if (world.method_16358((class_2338)mutableBlockPos, class_5726::method_33014)) {
                    world.method_8652((class_2338)mutableBlockPos, mushroomBlock, 2);
                    conkPoses.add(mutableBlockPos.method_10074());
                }
                mutableBlockPos.method_10098(class_2350.field_11036);
            }
            if (world.method_16358((class_2338)mutableBlockPos, class_5726::method_33014)) {
                world.method_8652((class_2338)mutableBlockPos, mushroomBlock, 2);
                conkPoses.add(mutableBlockPos.method_10074());
            }
            mutableBlockPos.method_10098(initialDirection.method_10170());
            ++rotatingIndex;
        }
    }

    private void placeBaseRoof(int baseSize, class_2338 blockPos, class_5281 world, class_2680 mushroomBlock, List<class_2338> conkPoses) {
        for (int x = -baseSize; x <= baseSize; ++x) {
            for (int z = -baseSize; z <= baseSize; ++z) {
                boolean invalid;
                class_2338 basePos = blockPos.method_10084().method_10069(x, 0, z);
                boolean xCorner = x == -baseSize || x == baseSize;
                boolean zCorner = z == -baseSize || z == baseSize;
                boolean bl = invalid = xCorner && zCorner || !world.method_16358(basePos, class_5726::method_33014);
                if (invalid) continue;
                world.method_8652(basePos, mushroomBlock, 2);
                conkPoses.add(basePos.method_10074());
            }
        }
    }

    private void placeStem(int primaryStemLength, int secondLayerCount, class_5281 world, class_2338 blockPos, class_2680 stemBlock, class_2680 mushroomBlock) {
        class_2680 placeState = stemBlock;
        int length = primaryStemLength / 2 + secondLayerCount / 2;
        for (int i = 0; i < length; ++i) {
            boolean placeable;
            if (i == length - 1) {
                placeState = mushroomBlock;
            }
            boolean bl = placeable = world.method_16358(blockPos.method_10086(i), class_5726::method_33014) || world.method_8320(blockPos).method_27852(SpeciesBlocks.ALPHACENE_MUSHROOM);
            if (!placeable) continue;
            world.method_8652(blockPos.method_10086(i), placeState, 2);
        }
    }
}

