/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.entity.ai.tasks;

import com.google.common.collect.ImmutableMap;
import com.ninni.species.entity.Cruncher;
import com.ninni.species.registry.SpeciesDamageTypes;
import com.ninni.species.registry.SpeciesMemoryModuleTypes;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2183;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5134;

public class StompAttack
extends class_4097<Cruncher> {
    private static final Cruncher.CruncherState cruncherState = Cruncher.CruncherState.STOMP;

    public StompAttack() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, SpeciesMemoryModuleTypes.STOMP_CHARGING, (Object)class_4141.field_18457), cruncherState.getDuration());
    }

    protected boolean checkExtraStartConditions(class_3218 serverLevel, Cruncher livingEntity) {
        return livingEntity.canAttack() && livingEntity.isTargetClose();
    }

    protected boolean canStillUse(class_3218 serverLevel, Cruncher livingEntity, long l) {
        return true;
    }

    protected void start(class_3218 serverLevel, Cruncher livingEntity, long l) {
        if (livingEntity.getState() == Cruncher.CruncherState.IDLE) {
            livingEntity.transitionTo(cruncherState);
        }
        livingEntity.method_5783(SpeciesSoundEvents.CRUNCHER_STOMP, 2.0f, 1.0f);
        livingEntity.method_18868().method_24525(SpeciesMemoryModuleTypes.STOMP_CHARGING, (Object)class_3902.field_17274, 14L);
    }

    protected void tick(class_3218 serverLevel, Cruncher cruncher, long l) {
        int i;
        class_4095<Cruncher> brain = cruncher.method_18868();
        class_1309 target = brain.method_18904(class_4140.field_22355).orElse(null);
        if (target == null) {
            return;
        }
        cruncher.method_5702(class_2183.class_2184.field_9851, target.method_19538());
        brain.method_18875(class_4140.field_18445);
        if (brain.method_18904(SpeciesMemoryModuleTypes.STOMP_CHARGING).isPresent()) {
            return;
        }
        for (class_1309 entity : serverLevel.method_18467(class_1309.class, cruncher.method_5829().method_1014(6.0))) {
            boolean reachable;
            boolean bl = reachable = entity.method_23318() > cruncher.method_23318() && entity.method_5739((class_1297)cruncher) > 6.0f;
            boolean self = entity instanceof Cruncher;
            if (self || reachable) continue;
            float damage = 8.0f / (0.15f * entity.method_5739((class_1297)cruncher));
            class_243 vec3 = cruncher.method_19538().method_1031(0.0, (double)1.6f, 0.0);
            class_243 vec32 = entity.method_33571().method_1020(vec3);
            class_243 vec33 = vec32.method_1029();
            entity.method_5643(serverLevel.method_48963().method_48796(SpeciesDamageTypes.CRUNCH, (class_1297)cruncher), damage);
            double d = 0.35 * (1.0 - entity.method_26825(class_5134.field_23718));
            double e = 2.0 * (1.0 - entity.method_26825(class_5134.field_23718));
            entity.method_5762(vec33.method_10216() * e, vec33.method_10214() * d, vec33.method_10215() * e);
        }
        for (i = 0; i <= cruncher.method_6051().method_43048(50) + 80; ++i) {
            serverLevel.method_14199((class_2394)class_2398.field_11204, cruncher.method_23322(2.0), cruncher.method_23318() + 0.25, cruncher.method_23325(2.0), 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (i = 0; i <= cruncher.method_6051().method_43048(20) + 20; ++i) {
            serverLevel.method_14199((class_2394)SpeciesParticles.ASCENDING_DUST, cruncher.method_23322(2.0), cruncher.method_23318() + 0.25, cruncher.method_23325(2.0), 1, 0.0, 1.0, 0.0, 0.0);
        }
        cruncher.method_18868().method_24525(SpeciesMemoryModuleTypes.STOMP_CHARGING, (Object)class_3902.field_17274, 42L);
    }

    protected void stop(class_3218 serverLevel, Cruncher livingEntity, long l) {
        if (livingEntity.getState() == cruncherState) {
            livingEntity.transitionTo(Cruncher.CruncherState.IDLE);
        }
    }
}

