/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.entity.ai.tasks;

import com.google.common.collect.ImmutableMap;
import com.ninni.species.entity.Cruncher;
import com.ninni.species.entity.CruncherPellet;
import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.registry.SpeciesMemoryModuleTypes;
import com.ninni.species.registry.SpeciesSoundEvents;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class SpitPellet
extends class_4097<Cruncher> {
    private static final int DURATION = 30;

    public SpitPellet() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18444, (Object)class_4141.field_18456, (Object)class_4140.field_18446, (Object)class_4141.field_18458, SpeciesMemoryModuleTypes.SPIT_CHARGING, (Object)class_4141.field_18457), 30);
    }

    protected boolean checkExtraStartConditions(class_3218 serverLevel, Cruncher livingEntity) {
        Optional nearestPlayer = livingEntity.method_18868().method_18904(class_4140.field_18444);
        long day = serverLevel.method_8532() / 24000L;
        long cruncherDay = livingEntity.getDay();
        if (cruncherDay == -1L || day != cruncherDay && day == 0L) {
            livingEntity.setDay(day);
        }
        if (cruncherDay < day) {
            livingEntity.setDay(cruncherDay + 1L);
            return livingEntity.getPelletData() != null && nearestPlayer.isPresent();
        }
        return false;
    }

    protected boolean canStillUse(class_3218 serverLevel, Cruncher livingEntity, long l) {
        return livingEntity.getSpits() <= 10;
    }

    protected void start(class_3218 serverLevel, Cruncher livingEntity, long l) {
        serverLevel.method_8421((class_1297)livingEntity, (byte)4);
        livingEntity.method_5783(SpeciesSoundEvents.CRUNCHER_SPIT, 2.0f, 1.0f);
        livingEntity.method_18868().method_24525(SpeciesMemoryModuleTypes.SPIT_CHARGING, (Object)class_3902.field_17274, 12L);
    }

    protected void tick(class_3218 serverLevel, Cruncher livingEntity, long l) {
        class_4095<Cruncher> brain = livingEntity.method_18868();
        brain.method_18875(class_4140.field_18445);
        if (brain.method_18904(SpeciesMemoryModuleTypes.SPIT_CHARGING).isPresent()) {
            return;
        }
        class_2338 blockPos = livingEntity.method_24515();
        class_2680 blockState = SpeciesBlocks.CRUNCHER_PELLET.method_9564();
        float angle = (float)Math.PI / 180 * livingEntity.field_6283;
        double headX = 3.0f * livingEntity.method_17825() * class_3532.method_15374((float)((float)Math.PI + angle));
        double headZ = 3.0f * livingEntity.method_17825() * class_3532.method_15362((float)angle);
        CruncherPellet pellet = new CruncherPellet((class_1937)serverLevel, (double)blockPos.method_10263() + headX, (float)blockPos.method_10264() + livingEntity.method_5751(), (double)blockPos.method_10260() + headZ, blockState, livingEntity.getPelletData());
        pellet.method_18799(livingEntity.method_5720().method_1021(2.0).method_18805(0.25, 1.0, 0.25));
        serverLevel.method_8649((class_1297)pellet);
        livingEntity.setSpits(livingEntity.getSpits() + 1);
        brain.method_24525(SpeciesMemoryModuleTypes.SPIT_CHARGING, (Object)class_3902.field_17274, 96L);
    }

    protected void stop(class_3218 serverLevel, Cruncher livingEntity, long time) {
        if (livingEntity.getSpits() > 10) {
            long day = serverLevel.method_8532() / 24000L;
            livingEntity.setSpits(0);
            livingEntity.setDay(day);
        }
    }
}

