/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.ninni.species.entity.Cruncher;
import com.ninni.species.entity.ai.tasks.RoarAttack;
import com.ninni.species.entity.ai.tasks.SpitPellet;
import com.ninni.species.entity.ai.tasks.StompAttack;
import com.ninni.species.registry.SpeciesMemoryModuleTypes;
import com.ninni.species.registry.SpeciesSensorTypes;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4818;
import net.minecraft.class_4822;
import net.minecraft.class_4824;

public class CruncherAi {
    public static final ImmutableList<class_4149<? extends class_4148<? super Cruncher>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_18469, SpeciesSensorTypes.CRUNCHER_ATTACK_ENTITY_SENSOR);
    public static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18442, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_39408, (Object)class_4140.field_22357, (Object)class_4140.field_22355, (Object)class_4140.field_18441, (Object)class_4140.field_30243, (Object)class_4140.field_18443, (Object)class_4140.field_18444, (Object[])new class_4140[]{class_4140.field_22354, SpeciesMemoryModuleTypes.ROAR_CHARGING, SpeciesMemoryModuleTypes.STOMP_CHARGING, SpeciesMemoryModuleTypes.SPIT_CHARGING, SpeciesMemoryModuleTypes.ROAR_COOLDOWN});

    public static class_4095<Cruncher> makeBrain(class_4095<Cruncher> brain) {
        CruncherAi.initCoreActivity(brain);
        CruncherAi.initIdleActivity(brain);
        CruncherAi.initFightActivity(brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void initCoreActivity(class_4095<Cruncher> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)new class_4110(45, 90){

            protected boolean checkExtraStartConditions(class_3218 serverLevel, class_1308 mob) {
                Cruncher cruncher;
                if (mob instanceof Cruncher && (cruncher = (Cruncher)mob).getStunnedTicks() > 0) {
                    return false;
                }
                return super.method_18919(serverLevel, (class_1309)mob);
            }
        }, (Object)new class_4112(){

            protected boolean method_18978(class_3218 serverLevel, class_1308 mob) {
                Cruncher cruncher;
                if (mob instanceof Cruncher && (cruncher = (Cruncher)mob).cannotWalk()) {
                    return false;
                }
                return super.method_18978(serverLevel, mob);
            }
        }));
    }

    private static void initIdleActivity(class_4095<Cruncher> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4824.method_47120(Predicate.not(CruncherAi::isPassive), cruncher -> cruncher.method_18868().method_18904(class_4140.field_30243))), (Object)Pair.of((Object)1, (Object)((Object)new SpitPellet())), (Object)Pair.of((Object)2, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)1.0f), (Object)1), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1))))));
    }

    private static void initFightActivity(class_4095<Cruncher> brain) {
        brain.method_24529(class_4168.field_22396, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4822.method_47094((float)1.5f)), (Object)Pair.of((Object)1, (Object)((Object)new RoarAttack())), (Object)Pair.of((Object)2, (Object)((Object)new StompAttack()))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18456)));
    }

    private static boolean isPassive(class_1309 livingEntity) {
        Cruncher cruncher;
        return livingEntity instanceof Cruncher && (cruncher = (Cruncher)livingEntity).getHunger() <= 0;
    }

    public static void updateActivity(Cruncher cruncher) {
        cruncher.method_18868().method_24531((List)ImmutableList.of((Object)class_4168.field_22396, (Object)class_4168.field_18595));
    }
}

