/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.entity;

import com.google.common.annotations.VisibleForTesting;
import com.ninni.species.criterion.SpeciesCriterion;
import com.ninni.species.entity.ai.goal.TreeperPlantGoal;
import com.ninni.species.entity.ai.goal.TreeperUprootGoal;
import com.ninni.species.entity.pose.SpeciesPose;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1333;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class Treeper
extends class_1296 {
    private static final class_2940<Integer> SAPLING_COOLDOWN = class_2945.method_12791(Treeper.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Long> LAST_POSE_CHANGE_TICK = class_2945.method_12791(Treeper.class, (class_2941)class_2943.field_39965);
    private static final class_2940<Boolean> PLANTED = class_2945.method_12791(Treeper.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> BURNED = class_2945.method_12791(Treeper.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_MOB = class_2945.method_12791(Treeper.class, (class_2941)class_2943.field_13323);
    public final class_7094 shakingSuccessAnimationState = new class_7094();
    public final class_7094 shakingFailAnimationState = new class_7094();
    public final class_7094 plantingAnimationState = new class_7094();
    public final class_7094 uprootingAnimationState = new class_7094();

    public Treeper(class_1299<? extends class_1296> entityType, class_1937 level) {
        super(entityType, level);
        this.method_49477(1.0f);
        this.field_6206 = new TreeperLookControl(this);
    }

    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData, @Nullable class_2487 compoundTag) {
        this.setHasMob(this.field_5974.method_43048(10) == 0);
        return super.method_5943(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return null;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new TreeperPlantGoal(this));
        this.field_6201.method_6277(0, (class_1352)new TreeperUprootGoal(this));
        this.field_6201.method_6277(1, (class_1352)new TreeperLookGoal(this, class_1657.class, 6.0f));
        this.field_6201.method_6277(2, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 60.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23719, 0.15);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31573(SpeciesTags.BURNS_TREEPER) && !this.isBurned()) {
            class_3414 soundEvent = itemStack.method_31574(class_1802.field_8814) ? class_3417.field_15013 : class_3417.field_15145;
            this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), soundEvent, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), SpeciesSoundEvents.TREEPER_BURN, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            for (int l = 0; l < 30; ++l) {
                this.method_37908().method_8406((class_2394)class_2398.field_11240, this.method_23322(2.0), this.method_23318() + Math.random(), this.method_23325(2.0), 0.0, 0.0, 0.0);
            }
            this.setBurned(true);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                SpeciesCriterion.BURN_TREEPER_INTO_PLACE.trigger(serverPlayer);
            }
            if (!this.isPlanted()) {
                this.plant();
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (itemStack.method_31573(SpeciesTags.EXTINGUISHES_TREEPER) && this.isBurned()) {
            this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15102, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            this.setBurned(false);
            if (itemStack.method_31574(class_1802.field_8705)) {
                class_1799 itemstack1 = class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)class_1802.field_8550.method_7854());
                if (!player.method_31549().field_7477) {
                    player.method_6122(hand, itemstack1);
                }
            }
            for (int l = 0; l < 30; ++l) {
                this.method_37908().method_8406((class_2394)class_2398.field_11237, this.method_23322(2.0), this.method_23318() + Math.random(), this.method_23325(2.0), 0.0, 0.0, 0.0);
            }
            if (this.isPlanted() && this.method_37908().method_23886() && this.method_24828() && !this.method_5799()) {
                this.uproot();
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public void method_5773() {
        super.method_5773();
        if (this.getSaplingCooldown() > 0) {
            this.setSaplingCooldown(this.getSaplingCooldown() - 1);
        }
        if (this.method_37908().field_9236) {
            if (this.getPoseTime() < 0L != this.isPlanted()) {
                this.uprootingAnimationState.method_41325();
                if (this.isPlanted() && this.getPoseTime() < 80L && this.getPoseTime() >= 0L) {
                    this.plantingAnimationState.method_41324(this.field_6012);
                }
            } else {
                this.plantingAnimationState.method_41325();
                this.uprootingAnimationState.method_45317(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.field_6012);
            }
        }
        if (this.isPlanted()) {
            this.field_6283 = Math.round((double)this.field_6283 / 90.0) * 90L;
            this.method_5814(Math.floor(this.method_19538().field_1352) + (double)0.99f, this.method_23318(), Math.floor(this.method_19538().field_1350) + (double)0.99f);
        }
    }

    public boolean isInPoseTransition() {
        long l = this.getPoseTime();
        return l < (long)(this.isPlanted() ? 80 : 152);
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (field_18064.equals(entityDataAccessor) && this.method_18376() == SpeciesPose.PLANTING.get()) {
            this.plantingAnimationState.method_41322(this.field_6012);
        }
        super.method_5674(entityDataAccessor);
    }

    public void plant() {
        if (this.isPlanted()) {
            return;
        }
        this.method_5783(SpeciesSoundEvents.TREEPER_PLANT, 2.0f, 1.0f);
        this.method_18380(SpeciesPose.PLANTING.get());
        this.setPlanted(true);
        this.resetLastPoseChangeTick(-this.method_37908().method_8510());
    }

    public void uproot() {
        if (!this.isPlanted()) {
            return;
        }
        this.method_5783(SpeciesSoundEvents.TREEPER_UPROOT, 1.0f, 1.0f);
        this.method_18380(class_4050.field_18076);
        this.setPlanted(false);
        this.resetLastPoseChangeTick(this.method_37908().method_8510());
    }

    public long getPoseTime() {
        return this.method_37908().method_8510() - Math.abs((Long)this.field_6011.method_12789(LAST_POSE_CHANGE_TICK));
    }

    public boolean method_30948() {
        return this.isPlanted();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SAPLING_COOLDOWN, (Object)0);
        this.field_6011.method_12784(LAST_POSE_CHANGE_TICK, (Object)0L);
        this.field_6011.method_12784(PLANTED, (Object)false);
        this.field_6011.method_12784(BURNED, (Object)false);
        this.field_6011.method_12784(HAS_MOB, (Object)false);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10544("LastPoseTick", ((Long)this.field_6011.method_12789(LAST_POSE_CHANGE_TICK)).longValue());
        compoundTag.method_10569("SaplingCooldown", this.getSaplingCooldown());
        compoundTag.method_10556("Planted", this.isPlanted());
        compoundTag.method_10556("Burned", this.isBurned());
        compoundTag.method_10556("HasMob", this.hasMob());
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.setSaplingCooldown(compoundTag.method_10550("SaplingCooldown"));
        this.setPlanted(compoundTag.method_10577("Planted"));
        this.setBurned(compoundTag.method_10577("Burned"));
        this.setHasMob(compoundTag.method_10577("HasMob"));
        long l = compoundTag.method_10537("LastPoseTick");
        if (l < 0L) {
            this.method_18380(SpeciesPose.PLANTING.get());
        }
        this.resetLastPoseChangeTick(l);
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long l) {
        this.field_6011.method_12778(LAST_POSE_CHANGE_TICK, (Object)l);
    }

    public Optional<class_1799> getStackInHand(class_1657 player) {
        return Arrays.stream(class_1268.values()).filter(hand -> player.method_5998(hand).method_7909() instanceof class_1743).map(arg_0 -> ((class_1657)player).method_5998(arg_0)).findFirst();
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1937 serverLevel;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            this.method_5783(SpeciesSoundEvents.TREEPER_HURT, 1.0f, 1.0f);
            if (this.getStackInHand(player).isPresent() && this.getStackInHand(player).get().method_7909() instanceof class_1743 && !this.isPlanted()) {
                class_1937 class_19372;
                if (this.getSaplingCooldown() == 0) {
                    this.method_5870((class_1935)SpeciesItems.ANCIENT_PINECONE, 7);
                    if (this.field_5974.method_43048(3) == 0) {
                        this.method_5870((class_1935)SpeciesItems.ANCIENT_PINECONE, 7);
                    }
                    if (this.field_5974.method_43048(3) == 0) {
                        this.method_5870((class_1935)SpeciesItems.ANCIENT_PINECONE, 7);
                    }
                    if (this.field_5974.method_43048(3) == 0) {
                        this.method_5870((class_1935)SpeciesItems.ANCIENT_PINECONE, 7);
                    }
                    this.setSaplingCooldown(this.field_5974.method_39332(2400, 8400));
                    this.shakingSuccessAnimationState.method_41322(this.field_6012);
                    this.method_5783(SpeciesSoundEvents.TREEPER_SHAKE_SUCCESS, 1.0f, 1.0f);
                } else {
                    this.method_5783(SpeciesSoundEvents.TREEPER_SHAKE_FAIL, 0.5f, 1.0f);
                }
                if (this.hasMob() && (class_19372 = this.method_37908()) instanceof class_3218) {
                    serverLevel = (class_3218)class_19372;
                    this.setHasMob(false);
                    class_2338 pos = new class_2338(this.method_24515().method_10263(), this.method_24515().method_10264() + 7, this.method_24515().method_10260());
                    if (this.field_5974.method_43056()) {
                        class_1299.field_17943.method_47821((class_3218)serverLevel, pos, class_3730.field_16459);
                    } else {
                        class_1299.field_6132.method_47821((class_3218)serverLevel, pos, class_3730.field_16459);
                    }
                }
            }
        }
        this.shakingFailAnimationState.method_41322(this.field_6012);
        serverLevel = this.method_37908();
        if (serverLevel instanceof class_3218) {
            class_3218 serverLevel2 = (class_3218)serverLevel;
            if (source.method_5529() instanceof class_1657) {
                for (int i = 0; i < this.field_5974.method_43048(15) + 5; ++i) {
                    serverLevel2.method_14199((class_2394)SpeciesParticles.TREEPER_LEAF, this.method_23322(1.8), this.method_23318() + 7.0, this.method_23325(1.8), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        return (source.method_48789(class_8103.field_42246) || source.method_48789(class_8103.field_42253) || source.method_48789(class_8103.field_42242)) && super.method_5643(source, amount);
    }

    protected float method_18394(class_4050 pose, class_4048 entityDimensions) {
        return pose == SpeciesPose.PLANTING.get() ? entityDimensions.field_18068 * 0.5f : entityDimensions.field_18068 * 0.65f;
    }

    public void method_6091(class_243 movementInput) {
        if (this.isPlanted()) {
            this.method_18799(this.method_18798().method_18805(0.0, 1.0, 0.0));
            movementInput = movementInput.method_18805(0.0, 1.0, 0.0);
        }
        super.method_6091(movementInput);
    }

    public int method_5970() {
        return this.isPlanted() ? 320 : 160;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return SpeciesSoundEvents.TREEPER_HURT;
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.isPlanted() && !this.isBurned() ? SpeciesSoundEvents.TREEPER_IDLE_PLANTED : SpeciesSoundEvents.TREEPER_IDLE;
    }

    @Nullable
    protected class_3414 method_6002() {
        return SpeciesSoundEvents.TREEPER_DEATH;
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
        this.method_5783(SpeciesSoundEvents.TREEPER_STEP, 1.0f, 1.0f);
    }

    protected boolean method_23734() {
        return false;
    }

    public boolean method_5974(double d) {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    public int getSaplingCooldown() {
        return (Integer)this.field_6011.method_12789(SAPLING_COOLDOWN);
    }

    public void setSaplingCooldown(int saplingCooldown) {
        this.field_6011.method_12778(SAPLING_COOLDOWN, (Object)saplingCooldown);
    }

    public boolean isPlanted() {
        return (Boolean)this.field_6011.method_12789(PLANTED);
    }

    public void setPlanted(boolean planted) {
        this.field_6011.method_12778(PLANTED, (Object)planted);
    }

    public boolean isBurned() {
        return (Boolean)this.field_6011.method_12789(BURNED);
    }

    public void setBurned(boolean burned) {
        this.field_6011.method_12778(BURNED, (Object)burned);
    }

    public boolean hasMob() {
        return (Boolean)this.field_6011.method_12789(HAS_MOB);
    }

    public void setHasMob(boolean bl) {
        this.field_6011.method_12778(HAS_MOB, (Object)bl);
    }

    public static boolean canSpawn(class_1299<Treeper> entity, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(SpeciesTags.TREEPER_SPAWNABLE_ON);
    }

    static class TreeperLookControl
    extends class_1333 {
        protected final Treeper mob;

        TreeperLookControl(Treeper mob) {
            super((class_1308)mob);
            this.mob = mob;
        }

        public void method_6231() {
            if (!this.mob.isPlanted()) {
                super.method_6231();
            }
        }
    }

    public static class TreeperLookGoal
    extends class_1361 {
        protected final Treeper mob;

        public TreeperLookGoal(Treeper mob, Class<? extends class_1309> class_, float f) {
            super((class_1308)mob, class_, f);
            this.mob = mob;
        }

        public boolean method_6264() {
            if (this.mob.isPlanted()) {
                return false;
            }
            return super.method_6264();
        }

        public boolean method_6266() {
            if (this.mob.isPlanted()) {
                return false;
            }
            return super.method_6266();
        }
    }
}

