/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ninni.species.entity.pose.SpeciesPose;
import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class Mammutilation
extends class_1314 {
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 coughAnimationState = new class_7094();
    public final class_7094 howlAnimationState = new class_7094();
    public static final class_2940<Integer> COUGH_COOLDOWN = class_2945.method_12791(Mammutilation.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> ICHOR_COUNT = class_2945.method_12791(Mammutilation.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> ICHOR_COOLDOWN = class_2945.method_12791(Mammutilation.class, (class_2941)class_2943.field_13327);
    private static final Map<class_2248, class_3414> SOUNDS_BY_EGG = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        map.put(class_2246.field_10195, class_3417.field_15109);
        map.put(class_2246.field_43230, class_3417.field_43165);
        map.put(SpeciesBlocks.WRAPTOR_EGG, SpeciesSoundEvents.WRAPTOR_EGG_CRACK);
        map.put(SpeciesBlocks.PETRIFIED_EGG, SpeciesSoundEvents.PETRIFIED_EGG_CRACK);
        map.put(SpeciesBlocks.SPRINGLING_EGG, SpeciesSoundEvents.SPRINGLING_EGG_CRACK);
    });
    private int coughTimer;
    private int hatchCooldown;
    private int howlCooldown;
    private int howlTimer;
    private int idleAnimationTimeout = 0;

    public Mammutilation(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.75));
        this.field_6201.method_6277(2, (class_1352)new CoughGoal(this));
        this.field_6201.method_6277(2, (class_1352)new HowlAtMoonGoal(this));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.15).method_26868(class_5134.field_23718, 0.6).method_26868(class_5134.field_23721, 0.0);
    }

    public boolean method_5974(double d) {
        return false;
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            if (this.hatchCooldown > 0) {
                --this.hatchCooldown;
            }
            if (this.coughTimer > 0) {
                --this.coughTimer;
                if (this.coughTimer == 15) {
                    class_2338 blockPos2 = this.method_24515();
                    float angle = (float)Math.PI / 180 * this.field_6283;
                    double headX = 3.0f * this.method_17825() * class_3532.method_15374((float)((float)Math.PI + angle));
                    double headZ = 3.0f * this.method_17825() * class_3532.method_15362((float)angle);
                    class_243 shootingVec = this.method_5720().method_1021(2.0).method_18805(0.5, 1.0, 0.5);
                    double d = shootingVec.method_10216();
                    double e = shootingVec.method_10214();
                    double g = shootingVec.method_10215();
                    double h = Math.sqrt(d * d + g * g);
                    this.method_45319(new class_243(0.0, 0.25, 0.0));
                    class_1937 class_19372 = this.method_37908();
                    if (class_19372 instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)class_19372;
                        serverLevel.method_14199((class_2394)SpeciesParticles.ICHOR, (double)blockPos2.method_10263() + headX, (double)((float)blockPos2.method_10264() + this.method_5751()), (double)blockPos2.method_10260() + headZ, 20, d, e + h * 0.5, g, 8.0);
                    }
                    this.method_45319(this.method_5720().method_1021(2.0).method_18805(-0.5, 0.0, -0.5));
                }
            } else if (this.method_18376() == SpeciesPose.COUGHING.get()) {
                this.method_18380(class_4050.field_18076);
            }
            if (this.howlCooldown > 0) {
                --this.howlCooldown;
            }
            if (this.getIchorCooldown() > 0) {
                this.setIchorCooldown(this.getIchorCooldown() - 1);
            }
            if (this.howlTimer > 0) {
                --this.howlTimer;
            } else if (this.method_18376() == SpeciesPose.HOWLING.get()) {
                this.method_18380(class_4050.field_18076);
            }
            if (this.hatchCooldown == 0) {
                this.getAllEggPositions().stream().filter(blockPos -> this.method_37908().method_8320(blockPos).method_28498((class_2769)class_2741.field_12530)).forEach(this::handleEggHatching);
            }
        }
    }

    protected class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (itemStack.method_31574(class_1802.field_8469) && !this.method_6109() && this.getIchorCount() > 0 && this.getIchorCooldown() == 0) {
            player.method_5783(SpeciesSoundEvents.MAMMUTILATION_BLEED, 1.0f, 1.0f);
            class_1799 itemStack2 = class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)SpeciesItems.ICHOR_BOTTLE.method_7854());
            this.setIchorCount(this.getIchorCount() - 1);
            this.ichorCooldown();
            player.method_6122(interactionHand, itemStack2);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, interactionHand);
    }

    public int method_5978() {
        return 20;
    }

    public boolean method_5753() {
        return true;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COUGH_COOLDOWN, (Object)(600 + this.field_5974.method_43048(2400)));
        this.field_6011.method_12784(ICHOR_COUNT, (Object)5);
        this.field_6011.method_12784(ICHOR_COOLDOWN, (Object)0);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.hatchCooldown = compoundTag.method_10550("HatchCooldown");
        this.howlCooldown = compoundTag.method_10550("HowlCooldown");
        this.coughTimer = compoundTag.method_10550("CoughTimer");
        this.setCoughCooldown(compoundTag.method_10550("CoughCooldown"));
        this.setIchorCount(compoundTag.method_10550("IchorCount"));
        this.setIchorCooldown(compoundTag.method_10550("IchorCooldown"));
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10569("HatchCooldown", this.hatchCooldown);
        compoundTag.method_10569("HowlCooldown", this.howlCooldown);
        compoundTag.method_10569("CoughTimer", this.coughTimer);
        compoundTag.method_10569("CoughCooldown", this.getCoughCooldown());
        compoundTag.method_10569("IchorCount", this.getIchorCount());
        compoundTag.method_10569("IchorCooldown", this.getIchorCooldown());
    }

    public int method_5970() {
        return 200;
    }

    public int getIchorCount() {
        return (Integer)this.field_6011.method_12789(ICHOR_COUNT);
    }

    public void setIchorCount(int count) {
        this.field_6011.method_12778(ICHOR_COUNT, (Object)count);
    }

    public int getIchorCooldown() {
        return (Integer)this.field_6011.method_12789(ICHOR_COOLDOWN);
    }

    public void setIchorCooldown(int cooldown) {
        this.field_6011.method_12778(ICHOR_COOLDOWN, (Object)cooldown);
    }

    public void ichorCooldown() {
        this.field_6011.method_12778(ICHOR_COOLDOWN, (Object)20);
    }

    public int getCoughCooldown() {
        return (Integer)this.field_6011.method_12789(COUGH_COOLDOWN);
    }

    public void setCoughCooldown(int cooldown) {
        this.field_6011.method_12778(COUGH_COOLDOWN, (Object)cooldown);
    }

    public void coughCooldown() {
        this.field_6011.method_12778(COUGH_COOLDOWN, (Object)(600 + this.field_5974.method_43048(2400)));
    }

    public void method_5773() {
        super.method_5773();
        if (this.getCoughCooldown() > 0) {
            this.setCoughCooldown(this.getCoughCooldown() - 1);
        }
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout == 0) {
            this.idleAnimationTimeout = 160;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (field_18064.equals(entityDataAccessor)) {
            if (this.method_18376() == SpeciesPose.COUGHING.get()) {
                this.coughAnimationState.method_41322(this.field_6012);
            }
            if (this.method_18376() == SpeciesPose.HOWLING.get()) {
                this.howlAnimationState.method_41322(this.field_6012);
            }
        }
        super.method_5674(entityDataAccessor);
    }

    private void handleEggHatching(class_2338 blockPos) {
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        int hatch = (Integer)blockState.method_11654((class_2769)class_2741.field_12530);
        this.method_37908().method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)class_2741.field_12530, (Comparable)Integer.valueOf(hatch + 1)), 2);
        if (SOUNDS_BY_EGG.containsKey(blockState.method_26204())) {
            this.method_37908().method_8396(null, blockPos, SOUNDS_BY_EGG.get(blockState.method_26204()), class_3419.field_15245, 0.7f, 0.9f + this.method_6051().method_43057() * 0.2f);
        }
        this.method_37908().method_20290(3009, blockPos, 0);
        this.hatchCooldown = class_6019.method_35017((int)6000, (int)12000).method_35008(this.method_6051());
    }

    public List<class_2338> getAllEggPositions() {
        ArrayList poses = Lists.newArrayList();
        int radius = 8;
        int yRange = radius / 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -yRange; y <= yRange; ++y) {
                    class_2338 blockPos = class_2338.method_49637((double)(this.method_23317() + (double)x), (double)(this.method_23318() + (double)y), (double)(this.method_23321() + (double)z));
                    class_2680 blockState = this.method_37908().method_8320(blockPos);
                    if (!blockState.method_28498((class_2769)class_2741.field_12530) || (Integer)blockState.method_11654((class_2769)class_2741.field_12530) >= 2) continue;
                    poses.add(blockPos);
                    this.handleTallEggs(blockState, blockPos, poses);
                }
            }
        }
        return poses;
    }

    private void handleTallEggs(class_2680 blockState, class_2338 blockPos, List<class_2338> poses) {
        boolean isDoubleBlockTall = blockState.method_28498((class_2769)class_2741.field_12533);
        Arrays.stream(class_2350.values()).filter(direction -> direction.method_10166() == class_2350.class_2351.field_11052).forEach(direction -> {
            boolean hasDoubleBlockInRelativeState;
            class_2680 relativeState = this.method_37908().method_8320(blockPos.method_10093(direction));
            class_2756 doubleBlockHalf = direction == class_2350.field_11033 ? class_2756.field_12607 : class_2756.field_12609;
            boolean bl = hasDoubleBlockInRelativeState = relativeState.method_27852(blockState.method_26204()) && relativeState.method_11654((class_2769)class_2741.field_12533) == doubleBlockHalf && isDoubleBlockTall;
            if (hasDoubleBlockInRelativeState) {
                poses.add(blockPos.method_10093(direction));
            }
        });
    }

    @Nullable
    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData, @Nullable class_2487 compoundTag) {
        this.hatchCooldown = class_6019.method_35017((int)6000, (int)12000).method_35008(this.method_6051());
        return super.method_5943(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    @Nullable
    protected class_3414 method_6002() {
        return SpeciesSoundEvents.MAMMUTILATION_DEATH;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return SpeciesSoundEvents.MAMMUTILATION_HURT;
    }

    @Nullable
    protected class_3414 method_5994() {
        if (this.method_5477().getString().equalsIgnoreCase("mammutiful")) {
            return SpeciesSoundEvents.MAMMUTIFUL_IDLE;
        }
        return SpeciesSoundEvents.MAMMUTILATION_IDLE;
    }

    public static boolean canSpawn(class_1299<Mammutilation> entity, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return false;
    }

    public static class CoughGoal
    extends class_1352 {
        protected final Mammutilation mammutilation;

        public CoughGoal(Mammutilation mammutilation) {
            this.mammutilation = mammutilation;
        }

        public void method_6269() {
            this.mammutilation.coughCooldown();
            this.mammutilation.coughTimer = 25;
            this.mammutilation.method_18380(SpeciesPose.COUGHING.get());
            this.mammutilation.method_5783(SpeciesSoundEvents.MAMMUTILATION_COUGH, 1.0f, 1.0f);
        }

        public boolean method_6264() {
            return this.mammutilation.getCoughCooldown() == 0 && this.mammutilation.method_18376() != SpeciesPose.HOWLING.get();
        }
    }

    public static class HowlAtMoonGoal
    extends class_1352 {
        protected final Mammutilation mammutilation;

        public HowlAtMoonGoal(Mammutilation mammutilation) {
            this.mammutilation = mammutilation;
        }

        public void method_6269() {
            if (this.mammutilation.method_5477().getString().equalsIgnoreCase("mammutiful")) {
                this.mammutilation.method_43077(SpeciesSoundEvents.MAMMUTIFUL_HOWL);
            } else {
                this.mammutilation.method_43077(SpeciesSoundEvents.MAMMUTILATION_HOWL);
            }
            this.mammutilation.howlCooldown = 1000;
            this.mammutilation.howlTimer = 80;
            this.mammutilation.method_18380(SpeciesPose.HOWLING.get());
            this.mammutilation.setIchorCount(5);
        }

        public boolean method_6264() {
            return this.mammutilation.method_37908().method_23886() && this.mammutilation.howlCooldown == 0 && this.mammutilation.method_18376() != SpeciesPose.COUGHING.get();
        }
    }
}

