/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.entity;

import com.google.common.annotations.VisibleForTesting;
import com.ninni.species.criterion.SpeciesCriterion;
import com.ninni.species.entity.GooberGoo;
import com.ninni.species.entity.ai.goal.GooberLayDownGoal;
import com.ninni.species.entity.ai.goal.GooberRearUpGoal;
import com.ninni.species.entity.ai.goal.GooberYawnGoal;
import com.ninni.species.entity.enums.GooberBehavior;
import com.ninni.species.entity.pose.SpeciesPose;
import com.ninni.species.registry.SpeciesEntities;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1330;
import net.minecraft.class_1333;
import net.minecraft.class_1335;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class Goober
extends class_1429 {
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 layDownIdleAnimationState = new class_7094();
    public final class_7094 layDownAnimationState = new class_7094();
    public final class_7094 standUpAnimationState = new class_7094();
    public final class_7094 yawnAnimationState = new class_7094();
    public final class_7094 layDownYawnAnimationState = new class_7094();
    public final class_7094 sneezeAnimationState = new class_7094();
    public final class_7094 layDownSneezeAnimationState = new class_7094();
    public final class_7094 rearUpAnimationState = new class_7094();
    public static final class_2940<Long> LAST_POSE_CHANGE_TICK = class_2945.method_12791(Goober.class, (class_2941)class_2943.field_39965);
    private static final class_2940<String> BEHAVIOR = class_2945.method_12791(Goober.class, (class_2941)class_2943.field_13326);
    public static final class_2940<Integer> LAY_DOWN_COOLDOWN = class_2945.method_12791(Goober.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> YAWN_COOLDOWN = class_2945.method_12791(Goober.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> YAWN_TIMER = class_2945.method_12791(Goober.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> REAR_UP_COOLDOWN = class_2945.method_12791(Goober.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> REAR_UP_TIMER = class_2945.method_12791(Goober.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> SNEEZE_COOLDOWN = class_2945.method_12791(Goober.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> SNEEZE_TIMER = class_2945.method_12791(Goober.class, (class_2941)class_2943.field_13327);
    private static final class_4048 SITTING_DIMENSIONS = class_4048.method_18384((float)2.0f, (float)1.4f);
    private int idleAnimationTimeout = 0;

    public Goober(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new GooberMoveControl();
        this.field_6206 = new GooberLookControl(this);
        this.method_49477(1.0f);
    }

    protected class_1330 method_5963() {
        return new GooberBodyRotationControl(this);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 2.0));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.2, class_1856.method_8106(SpeciesTags.GOOBER_BREED_ITEMS), false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(7, (class_1352)new GooberYawnGoal(this));
        this.field_6201.method_6277(7, (class_1352)new GooberRearUpGoal(this));
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(9, (class_1352)new GooberLayDownGoal(this));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23718, 0.5).method_26868(class_5134.field_23719, 0.15);
    }

    public class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        boolean bl = this.method_6481(itemStack);
        class_1269 interactionResult = super.method_5992(player, interactionHand);
        if (interactionResult.method_23665() && bl) {
            if (this.isGooberLayingDown()) {
                this.standUp();
            }
            this.method_37908().method_43129(null, (class_1297)this, SpeciesSoundEvents.GOOBER_EAT, class_3419.field_15254, 1.0f, class_3532.method_32750((class_5819)this.method_37908().field_9229, (float)0.8f, (float)1.2f));
        }
        if ((itemStack.method_31574(class_1802.field_8153) || itemStack.method_31574(class_1802.field_42716)) && this.getSneezeCooldown() == 0 && this.getBehavior().equals(GooberBehavior.IDLE.getName())) {
            this.setSneezeTimer(GooberBehavior.SNEEZING.getLength());
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                SpeciesCriterion.TICKLE_GOOBER.trigger(serverPlayer);
            }
            this.method_18380(this.isGooberLayingDown() ? SpeciesPose.SNEEZING_LAYING_DOWN.get() : SpeciesPose.SNEEZING.get());
            this.sneezeCooldown();
            this.method_5783(SpeciesSoundEvents.GOOBER_SNEEZE, 2.0f, 1.0f);
            return class_1269.field_5812;
        }
        return interactionResult;
    }

    public void method_24650(class_3218 serverLevel, class_1429 animal) {
        class_1799 itemStack = new class_1799((class_1935)SpeciesItems.PETRIFIED_EGG);
        class_1542 itemEntity = new class_1542((class_1937)serverLevel, this.method_19538().method_10216(), this.method_19538().method_10214(), this.method_19538().method_10215(), itemStack);
        itemEntity.method_6988();
        this.method_49794(serverLevel, animal, null);
        this.method_5783(SpeciesSoundEvents.PETRIFIED_EGG_PLOP, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 0.5f);
        serverLevel.method_8649((class_1297)itemEntity);
    }

    public boolean method_6481(class_1799 itemStack) {
        return itemStack.method_31573(SpeciesTags.GOOBER_BREED_ITEMS);
    }

    public void method_5773() {
        super.method_5773();
        if (this.getLayDownCooldown() > 0) {
            this.setLayDownCooldown(this.getLayDownCooldown() - 1);
        }
        if (this.getRearUpCooldown() > 0) {
            if (this.getBehavior().equals(GooberBehavior.REAR_UP.getName())) {
                this.setBehavior(GooberBehavior.IDLE.getName());
            }
            this.setRearUpCooldown(this.getRearUpCooldown() - 1);
        }
        if (this.getYawnCooldown() > 0) {
            if (this.getBehavior().equals(GooberBehavior.YAWN.getName())) {
                this.setBehavior(GooberBehavior.IDLE.getName());
            }
            this.setYawnCooldown(this.getYawnCooldown() - 1);
        }
        if (this.getSneezeCooldown() > 0) {
            if (this.getBehavior().equals(GooberBehavior.SNEEZING.getName())) {
                this.setBehavior(GooberBehavior.IDLE.getName());
            }
            this.setSneezeCooldown(this.getSneezeCooldown() - 1);
        }
        if (this.getRearUpTimer() > 0) {
            this.setRearUpTimer(this.getRearUpTimer() - 1);
            if (this.getRearUpTimer() == 0) {
                this.method_18380(class_4050.field_18076);
                this.setBehavior(GooberBehavior.IDLE.getName());
                this.rearUpCooldown();
            }
        }
        if (this.getYawnTimer() > 0) {
            this.setYawnTimer(this.getYawnTimer() - 1);
            if (this.getYawnTimer() == 0) {
                if (this.isGooberLayingDown()) {
                    this.method_18380(SpeciesPose.LAYING_DOWN.get());
                } else {
                    this.method_18380(class_4050.field_18076);
                }
                this.setBehavior(GooberBehavior.IDLE.getName());
                this.yawnCooldown();
            }
        }
        if (this.getSneezeTimer() > 0) {
            this.setBehavior(GooberBehavior.SNEEZING.getName());
            this.setSneezeTimer(this.getSneezeTimer() - 1);
            if (this.getSneezeTimer() == 35) {
                class_2338 blockPos = this.method_24515();
                float angle = (float)Math.PI / 180 * this.field_6283;
                double headX = 3.0f * this.method_17825() * class_3532.method_15374((float)((float)Math.PI + angle));
                double headZ = 3.0f * this.method_17825() * class_3532.method_15362((float)angle);
                class_243 shootingVec = this.method_5720().method_1021(2.0).method_18805(0.25, 1.0, 0.25);
                GooberGoo goo = new GooberGoo(this.method_37908(), (double)blockPos.method_10263() + headX, (float)blockPos.method_10264() + this.method_5751() + (this.isGooberLayingDown() ? 0.0f : 0.35f), (double)blockPos.method_10260() + headZ);
                double d = shootingVec.method_10216();
                double e = shootingVec.method_10214();
                double g = shootingVec.method_10215();
                double h = Math.sqrt(d * d + g * g);
                goo.method_7485(d, e + h * (double)0.1f, g, 0.8f, 14 - this.method_37908().method_8407().method_5461() * 4);
                this.method_37908().method_8649((class_1297)goo);
                if (!this.isGooberLayingDown()) {
                    this.method_45319(new class_243(0.0, 0.25, 0.0));
                    this.method_45319(this.method_5720().method_1021(2.0).method_18805(-0.5, 0.0, -0.5));
                }
            }
            if (this.getSneezeTimer() == 1) {
                if (this.isGooberLayingDown()) {
                    this.method_18380(SpeciesPose.LAYING_DOWN.get());
                } else {
                    this.method_18380(class_4050.field_18076);
                }
                this.setBehavior(GooberBehavior.IDLE.getName());
            }
        }
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates();
        }
        if (this.isGooberLayingDown() && this.method_5799()) {
            this.standUpInstantly();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout == 0) {
            this.idleAnimationTimeout = 80;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isGooberVisuallyLayingDown()) {
            this.standUpAnimationState.method_41325();
            this.yawnAnimationState.method_41325();
            this.sneezeAnimationState.method_41325();
            this.rearUpAnimationState.method_41325();
            if (this.isVisuallyLayingDown()) {
                this.layDownAnimationState.method_41324(this.field_6012);
                this.layDownIdleAnimationState.method_41325();
            } else {
                this.layDownAnimationState.method_41325();
                this.layDownIdleAnimationState.method_41324(this.field_6012);
            }
        } else {
            this.layDownAnimationState.method_41325();
            this.layDownIdleAnimationState.method_41325();
            this.standUpAnimationState.method_45317(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.field_6012);
        }
    }

    public class_4048 method_18377(class_4050 pose) {
        return pose == SpeciesPose.LAYING_DOWN.get() || pose == SpeciesPose.YAWNING_LAYING_DOWN.get() || pose == SpeciesPose.SNEEZING_LAYING_DOWN.get() ? SITTING_DIMENSIONS.method_18383(this.method_17825()) : super.method_18377(pose);
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (field_18064.equals(entityDataAccessor)) {
            if (this.method_18376() == SpeciesPose.SNEEZING.get()) {
                this.sneezeAnimationState.method_41322(this.field_6012);
            }
            if (this.method_18376() == SpeciesPose.SNEEZING_LAYING_DOWN.get()) {
                this.layDownSneezeAnimationState.method_41322(this.field_6012);
            }
            if (this.method_18376() == SpeciesPose.YAWNING.get()) {
                this.yawnAnimationState.method_41322(this.field_6012);
            }
            if (this.method_18376() == SpeciesPose.YAWNING_LAYING_DOWN.get()) {
                this.layDownYawnAnimationState.method_41322(this.field_6012);
            }
            if (this.method_18376() == SpeciesPose.REARING_UP.get()) {
                this.rearUpAnimationState.method_41322(this.field_6012);
            }
        }
        super.method_5674(entityDataAccessor);
    }

    public boolean method_5753() {
        return this.method_6109();
    }

    public boolean method_30948() {
        return this.isGooberLayingDown();
    }

    public void method_6091(class_243 vec3) {
        if (this.refuseToMove() && this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(0.0, 1.0, 0.0));
            vec3 = vec3.method_18805(0.0, 1.0, 0.0);
        }
        super.method_6091(vec3);
    }

    protected void method_6074(class_1282 damageSource, float f) {
        this.standUpInstantly();
        super.method_6074(damageSource, f);
    }

    public boolean refuseToMove() {
        return this.isGooberLayingDown() || this.isInPoseTransition();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(LAST_POSE_CHANGE_TICK, (Object)0L);
        this.field_6011.method_12784(BEHAVIOR, (Object)GooberBehavior.IDLE.getName());
        this.field_6011.method_12784(LAY_DOWN_COOLDOWN, (Object)(240 + this.field_5974.method_43048(600)));
        this.field_6011.method_12784(YAWN_COOLDOWN, (Object)(40 + this.field_5974.method_43048(240)));
        this.field_6011.method_12784(REAR_UP_COOLDOWN, (Object)(1200 + this.field_5974.method_43048(4800)));
        this.field_6011.method_12784(SNEEZE_TIMER, (Object)0);
        this.field_6011.method_12784(REAR_UP_TIMER, (Object)0);
        this.field_6011.method_12784(YAWN_TIMER, (Object)0);
        this.field_6011.method_12784(SNEEZE_COOLDOWN, (Object)0);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10544("LastPoseTick", ((Long)this.field_6011.method_12789(LAST_POSE_CHANGE_TICK)).longValue());
        compoundTag.method_10582("Behavior", this.getBehavior());
        compoundTag.method_10569("LayDownCooldown", this.getLayDownCooldown());
        compoundTag.method_10569("YawnCooldown", this.getYawnCooldown());
        compoundTag.method_10569("RearUpCooldown", this.getRearUpCooldown());
        compoundTag.method_10569("YawnTimer", this.getYawnTimer());
        compoundTag.method_10569("RearUpTimer", this.getRearUpTimer());
        compoundTag.method_10569("SneezeTimer", this.getSneezeTimer());
        compoundTag.method_10569("SneezeCooldown", this.getSneezeCooldown());
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.setLayDownCooldown(compoundTag.method_10550("LayDownCooldown"));
        this.setYawnCooldown(compoundTag.method_10550("YawnCooldown"));
        this.setRearUpCooldown(compoundTag.method_10550("RearUpCooldown"));
        this.setYawnTimer(compoundTag.method_10550("YawnTimer"));
        this.setRearUpTimer(compoundTag.method_10550("RearUpTimer"));
        this.setSneezeTimer(compoundTag.method_10550("SneezeTimer"));
        this.setSneezeCooldown(compoundTag.method_10550("SneezeCooldown"));
        this.setBehavior(compoundTag.method_10558("Behavior"));
        long l = compoundTag.method_10537("LastPoseTick");
        if (l < 0L) {
            this.method_18380(SpeciesPose.LAYING_DOWN.get());
        }
        this.resetLastPoseChangeTick(l);
    }

    public String getBehavior() {
        return (String)this.field_6011.method_12789(BEHAVIOR);
    }

    public void setBehavior(String behavior) {
        this.field_6011.method_12778(BEHAVIOR, (Object)behavior);
    }

    public int getLayDownCooldown() {
        return (Integer)this.field_6011.method_12789(LAY_DOWN_COOLDOWN);
    }

    public void setLayDownCooldown(int cooldown) {
        this.field_6011.method_12778(LAY_DOWN_COOLDOWN, (Object)cooldown);
    }

    public void layDownCooldown() {
        this.field_6011.method_12778(LAY_DOWN_COOLDOWN, (Object)(600 + this.field_5974.method_43048(2400)));
    }

    public void standUpCooldown() {
        this.field_6011.method_12778(LAY_DOWN_COOLDOWN, (Object)(1200 + this.field_5974.method_43048(2400)));
    }

    public int getYawnTimer() {
        return (Integer)this.field_6011.method_12789(YAWN_TIMER);
    }

    public void setYawnTimer(int timer) {
        this.field_6011.method_12778(YAWN_TIMER, (Object)timer);
    }

    public int getYawnCooldown() {
        return (Integer)this.field_6011.method_12789(YAWN_COOLDOWN);
    }

    public void setYawnCooldown(int cooldown) {
        this.field_6011.method_12778(YAWN_COOLDOWN, (Object)cooldown);
    }

    public void yawnCooldown() {
        this.field_6011.method_12778(YAWN_COOLDOWN, (Object)(120 + this.field_5974.method_43048(2400)));
    }

    public int getSneezeTimer() {
        return (Integer)this.field_6011.method_12789(SNEEZE_TIMER);
    }

    public void setSneezeTimer(int timer) {
        this.field_6011.method_12778(SNEEZE_TIMER, (Object)timer);
    }

    public int getSneezeCooldown() {
        return (Integer)this.field_6011.method_12789(SNEEZE_COOLDOWN);
    }

    public void setSneezeCooldown(int cooldown) {
        this.field_6011.method_12778(SNEEZE_COOLDOWN, (Object)cooldown);
    }

    public void sneezeCooldown() {
        this.field_6011.method_12778(SNEEZE_COOLDOWN, (Object)(2400 + this.field_5974.method_43048(9600)));
    }

    public int getRearUpTimer() {
        return (Integer)this.field_6011.method_12789(REAR_UP_TIMER);
    }

    public void setRearUpTimer(int timer) {
        this.field_6011.method_12778(REAR_UP_TIMER, (Object)timer);
    }

    public int getRearUpCooldown() {
        return (Integer)this.field_6011.method_12789(REAR_UP_COOLDOWN);
    }

    public void setRearUpCooldown(int cooldown) {
        this.field_6011.method_12778(REAR_UP_COOLDOWN, (Object)cooldown);
    }

    public void rearUpCooldown() {
        this.field_6011.method_12778(REAR_UP_COOLDOWN, (Object)(2400 + this.field_5974.method_43048(9600)));
    }

    public boolean isGooberLayingDown() {
        return (Long)this.field_6011.method_12789(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isGooberVisuallyLayingDown() {
        return this.getPoseTime() < 0L != this.isGooberLayingDown();
    }

    public boolean isInPoseTransition() {
        long l = this.getPoseTime();
        return l < (long)(this.isGooberLayingDown() ? 40 : 52);
    }

    private boolean isVisuallyLayingDown() {
        return this.isGooberLayingDown() && this.getPoseTime() < 40L && this.getPoseTime() >= 0L;
    }

    public void layDown() {
        if (this.isGooberLayingDown()) {
            return;
        }
        this.method_5783(SpeciesSoundEvents.GOOBER_LAY_DOWN, 1.0f, 1.0f);
        this.method_18380(SpeciesPose.LAYING_DOWN.get());
        this.resetLastPoseChangeTick(-this.method_37908().method_8510());
        this.method_18382();
    }

    public void standUp() {
        if (!this.isGooberLayingDown()) {
            return;
        }
        this.method_18380(class_4050.field_18076);
        this.resetLastPoseChangeTick(this.method_37908().method_8510());
        this.method_18382();
    }

    public void standUpInstantly() {
        this.method_18380(class_4050.field_18076);
        this.resetLastPoseChangeTickToFullStand(this.method_37908().method_8510());
        this.method_18382();
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long l) {
        this.field_6011.method_12778(LAST_POSE_CHANGE_TICK, (Object)l);
    }

    private void resetLastPoseChangeTickToFullStand(long l) {
        this.resetLastPoseChangeTick(Math.max(0L, l - 52L - 1L));
    }

    public long getPoseTime() {
        return this.method_37908().method_8510() - Math.abs((Long)this.field_6011.method_12789(LAST_POSE_CHANGE_TICK));
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.getBehavior().equals(GooberBehavior.IDLE.getName()) ? (this.isGooberLayingDown() ? SpeciesSoundEvents.GOOBER_IDLE_RESTING : SpeciesSoundEvents.GOOBER_IDLE) : class_3417.field_42593;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return SpeciesSoundEvents.GOOBER_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return SpeciesSoundEvents.GOOBER_DEATH;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(SpeciesSoundEvents.GOOBER_STEP, 0.35f, 1.0f);
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return (class_1296)SpeciesEntities.GOOBER.method_5883((class_1937)serverLevel);
    }

    public static boolean canSpawn(class_1299<Goober> entity, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return false;
    }

    class GooberMoveControl
    extends class_1335 {
        public GooberMoveControl() {
            super((class_1308)Goober.this);
        }

        public void method_6240() {
            if (!Goober.this.refuseToMove()) {
                if (this.field_6374 == class_1335.class_1336.field_6378 && !Goober.this.method_5934() && Goober.this.isGooberLayingDown() && !Goober.this.isInPoseTransition()) {
                    Goober.this.standUp();
                }
                super.method_6240();
            }
        }
    }

    static class GooberLookControl
    extends class_1333 {
        protected final Goober mob;

        GooberLookControl(Goober mob) {
            super((class_1308)mob);
            this.mob = mob;
        }

        public void method_6231() {
            if (!this.mob.refuseToMove()) {
                super.method_6231();
            }
        }
    }

    class GooberBodyRotationControl
    extends class_1330 {
        public GooberBodyRotationControl(Goober goober) {
            super((class_1308)goober);
        }

        public void method_6224() {
            if (!Goober.this.refuseToMove()) {
                super.method_6224();
            }
        }
    }
}

