/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.ninni.species.client.inventory.CruncherInventoryMenu;
import com.ninni.species.criterion.SpeciesCriterion;
import com.ninni.species.data.CruncherPelletManager;
import com.ninni.species.entity.ai.CruncherAi;
import com.ninni.species.mixin.ServerPlayerAccessor;
import com.ninni.species.registry.SpeciesDamageTypes;
import com.ninni.species.registry.SpeciesEntityDataSerializers;
import com.ninni.species.registry.SpeciesNetwork;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1259;
import net.minecraft.class_1263;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1429;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6067;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_7248;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Cruncher
extends class_1429
implements class_6067,
class_7248 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2940<CruncherState> CRUNCHER_STATE = class_2945.method_12791(Cruncher.class, SpeciesEntityDataSerializers.CRUNCHER_STATE);
    private static final class_2940<Integer> STUNNED_TICKS = class_2945.method_12791(Cruncher.class, (class_2941)class_2943.field_13327);
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 roarAnimationState = new class_7094();
    public final class_7094 spitAnimationState = new class_7094();
    public final class_7094 attackAnimationState = new class_7094();
    public final class_7094 stunAnimationState = new class_7094();
    private final class_3213 bossEvent = (class_3213)new class_3213((class_2561)class_2561.method_43469((String)"bar.species.cruncher", (Object[])new Object[]{this.method_5476().getString()}), class_1259.class_1260.field_5780, class_1259.class_1261.field_5796).method_5406(true).method_5410(true);
    private final int maxHunger = 3;
    @Nullable
    private CruncherPelletManager.CruncherPelletData pelletData = null;
    private int hunger;
    private int idleAnimationTimeout = 0;
    private int spits;
    private long day = -1L;
    public final class_1277 inventory = new class_1277(1);

    public Cruncher(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 500.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23718, 0.75).method_26868(class_5134.field_23721, 10.0);
    }

    protected class_4095.class_5303<Cruncher> method_28306() {
        return class_4095.method_28311(CruncherAi.MEMORY_TYPES, CruncherAi.SENSOR_TYPES);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return CruncherAi.makeBrain((class_4095<Cruncher>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<Cruncher> method_18868() {
        return super.method_18868();
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_5805()) {
            if (this.getHunger() > 0) {
                if (this.method_5944(class_7.field_6) != 0.0f) {
                    this.method_5941(class_7.field_6, 0.0f);
                }
                if (this.bossEvent.method_5420() != this.getBarColor()) {
                    this.bossEvent.method_5416(this.getBarColor());
                }
                if (this.field_5976 && this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
                    boolean bl = false;
                    class_238 aABB = this.method_5829().method_1014(0.2);
                    Iterator var8 = class_2338.method_10094((int)class_3532.method_15357((double)aABB.field_1323), (int)class_3532.method_15357((double)aABB.field_1322), (int)class_3532.method_15357((double)aABB.field_1321), (int)class_3532.method_15357((double)aABB.field_1320), (int)class_3532.method_15357((double)aABB.field_1325), (int)class_3532.method_15357((double)aABB.field_1324)).iterator();
                    while (true) {
                        if (!var8.hasNext()) {
                            if (!bl && this.method_24828()) {
                                this.method_6043();
                            }
                            break;
                        }
                        class_2338 blockPos = (class_2338)var8.next();
                        class_2680 blockState = this.method_37908().method_8320(blockPos);
                        class_2248 block = blockState.method_26204();
                        if (!(block instanceof class_2397)) continue;
                        bl = this.method_37908().method_8651(blockPos, true, (class_1297)this) || bl;
                    }
                }
            } else if (this.method_5944(class_7.field_6) == 0.0f) {
                this.method_5941(class_7.field_6, -1.0f);
            }
        }
    }

    protected void method_5958() {
        boolean flag;
        this.method_37908().method_16107().method_15396("cruncherBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("cruncherActivityUpdate");
        CruncherAi.updateActivity(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
        boolean bl = flag = this.getHunger() <= 0;
        if (flag && !this.bossEvent.method_14092().isEmpty()) {
            this.bossEvent.method_14094();
            this.method_18868().method_18875(class_4140.field_22355);
        }
        if (flag) {
            return;
        }
        float f = this.getHunger();
        Objects.requireNonNull(this);
        this.bossEvent.method_5408(f / 3.0f);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CRUNCHER_STATE, (Object)CruncherState.IDLE);
        this.field_6011.method_12784(STUNNED_TICKS, (Object)0);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (this.method_16914()) {
            this.bossEvent.method_5413((class_2561)class_2561.method_43469((String)"bar.species.cruncher", (Object[])new Object[]{this.method_5476().getString()}));
        }
        this.bossEvent.method_5416(this.getBarColor());
        if (compoundTag.method_10573("PelletData", 10)) {
            CruncherPelletManager.CruncherPelletData.CODEC.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)compoundTag.method_10562("PelletData"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::setPelletData);
        }
        if (compoundTag.method_10573("PelletFuel", 10)) {
            this.inventory.method_5447(0, class_1799.method_7915((class_2487)compoundTag.method_10562("PelletFuel")));
        }
        this.setSpits(compoundTag.method_10550("Spit"));
        this.setHunger(compoundTag.method_10550("Hunger"));
        this.setStunnedTicks(compoundTag.method_10550("StunnedTicks"));
        this.setDay(compoundTag.method_10537("Day"));
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.bossEvent.method_5413((class_2561)class_2561.method_43469((String)"bar.species.cruncher", (Object[])new Object[]{this.method_5476().getString()}));
        this.bossEvent.method_5416(this.getBarColor());
        if (this.pelletData != null) {
            CruncherPelletManager.CruncherPelletData.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.getPelletData()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.method_10566("PelletData", tag));
        }
        if (!this.inventory.method_5438(0).method_7960()) {
            compoundTag.method_10566("PelletFuel", (class_2520)this.inventory.method_5438(0).method_7953(new class_2487()));
        }
        compoundTag.method_10569("Spit", this.getSpits());
        compoundTag.method_10569("Hunger", this.getHunger());
        compoundTag.method_10569("StunnedTicks", this.getStunnedTicks());
        compoundTag.method_10544("Day", this.getDay());
    }

    public class_1259.class_1260 getBarColor() {
        return switch (this.getHunger()) {
            case 3 -> class_1259.class_1260.field_5780;
            case 2 -> class_1259.class_1260.field_5783;
            case 1 -> class_1259.class_1260.field_5784;
            default -> class_1259.class_1260.field_5780;
        };
    }

    @Nullable
    public CruncherPelletManager.CruncherPelletData getPelletData() {
        return this.pelletData;
    }

    public void setPelletData(CruncherPelletManager.CruncherPelletData data) {
        this.pelletData = data;
    }

    public long getDay() {
        return this.day;
    }

    public void setDay(long day) {
        this.day = day;
    }

    public int getSpits() {
        return this.spits;
    }

    public void setSpits(int spits) {
        this.spits = spits;
    }

    public boolean method_42149() {
        return true;
    }

    public class_1282 crunch(class_1309 livingEntity) {
        return this.method_48923().method_48796(SpeciesDamageTypes.CRUNCH, (class_1297)livingEntity);
    }

    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        if (this.getHunger() > 0) {
            this.bossEvent.method_14088(serverPlayer);
        }
    }

    public void method_5742(class_3222 serverPlayer) {
        super.method_5742(serverPlayer);
        this.bossEvent.method_14089(serverPlayer);
    }

    public class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (this.getHunger() == 0 && !this.method_37908().field_9236) {
            this.method_6722(player);
            return class_1269.field_5812;
        }
        if (itemStack.method_31573(SpeciesTags.CRUNCHER_EATS) && this.getStunnedTicks() > 0) {
            itemStack.method_7934(1);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                SpeciesCriterion.FEED_CRUNCHER.trigger(serverPlayer);
            }
            this.setHunger(this.getHunger() - 1);
            this.bossEvent.method_5416(this.getBarColor());
            if (this.getHunger() == 0) {
                this.bossEvent.method_5408(0.0f);
                this.bossEvent.method_14091(false);
                this.method_18868().method_18875(class_4140.field_22355);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            }
            this.transitionTo(CruncherState.IDLE);
            this.method_5783(class_3417.field_20614, 2.0f, 1.0f);
            this.method_6033(this.method_6063());
            this.setStunnedTicks(0);
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    protected void method_16078() {
        super.method_16078();
        this.inventory.method_24514().forEach(arg_0 -> ((Cruncher)this).method_5775(arg_0));
        class_1799 itemStack = this.method_6118(class_1304.field_6173);
        if (!itemStack.method_7960() && !class_1890.method_8221((class_1799)itemStack)) {
            this.method_5775(itemStack);
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
    }

    public class_1277 method_35199() {
        return this.inventory;
    }

    public void method_6722(class_1657 player) {
        if (!this.method_37908().field_9236 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ServerPlayerAccessor accessor = (ServerPlayerAccessor)serverPlayer;
            if (serverPlayer.field_7512 != serverPlayer.field_7498) {
                serverPlayer.method_7346();
            }
            accessor.callNextContainerCounter();
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(this.method_5628());
            buf.writeInt(this.inventory.method_5439());
            buf.writeInt(accessor.getContainerCounter());
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)SpeciesNetwork.OPEN_CRUNCHER_SCREEN, (class_2540)buf);
            serverPlayer.field_7512 = new CruncherInventoryMenu(accessor.getContainerCounter(), serverPlayer.method_31548(), (class_1263)this.inventory, this);
            accessor.callInitMenu(serverPlayer.field_7512);
        }
    }

    public boolean method_5643(class_1282 damageSource, float f) {
        if (this.getState() == CruncherState.ROAR) {
            f = (f - 1.0f) / 2.0f;
        }
        return super.method_5643(damageSource, f);
    }

    protected void method_6074(class_1282 damageSource, float f) {
        boolean flag = (double)(this.method_6032() / this.method_6063()) <= 0.75;
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            this.method_18868().method_18878(class_4140.field_22355, (Object)livingEntity);
        }
        if (this.getHunger() > 0 && flag && this.getState() != CruncherState.STUNNED) {
            this.method_5783(SpeciesSoundEvents.CRUNCHER_STUN, 2.0f, 1.0f);
            this.transitionTo(CruncherState.STUNNED);
            this.setStunnedTicks(320);
        }
        super.method_6074(damageSource, f);
    }

    public void method_5773() {
        super.method_5773();
        float angle = (float)Math.PI / 180 * this.field_6283;
        double headX = 2.0f * this.method_17825() * class_3532.method_15374((float)((float)Math.PI + angle));
        double headZ = 2.0f * this.method_17825() * class_3532.method_15362((float)angle);
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates();
        } else {
            class_1937 class_19372;
            if (this.getState() == CruncherState.STUNNED) {
                int ticks;
                class_19372 = this.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 world = (class_3218)class_19372;
                    if (this.field_6012 % 6 == 1) {
                        world.method_14199((class_2394)SpeciesParticles.FOOD, this.method_23317() + headX, this.method_23320() + 1.5, this.method_23321() + headZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                if ((ticks = this.getStunnedTicks()) > 0) {
                    this.setStunnedTicks(ticks - 1);
                    this.method_6025(1.0f);
                } else {
                    this.transitionTo(CruncherState.IDLE);
                }
            }
            if (this.getHunger() > 0 && (class_19372 = this.method_37908()) instanceof class_3218) {
                class_3218 world = (class_3218)class_19372;
                if (this.field_5974.method_43057() < 0.1f) {
                    world.method_14199((class_2394)SpeciesParticles.FALLING_PELLET_DRIP, this.method_23322(0.4) + headX, this.method_23320(), this.method_23325(0.4) + headZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public int getHunger() {
        return this.hunger;
    }

    public void setHunger(int hunger) {
        this.hunger = hunger;
    }

    private void setupAnimationStates() {
        switch (this.getState()) {
            case IDLE: {
                if (this.idleAnimationTimeout <= 0) {
                    this.idleAnimationTimeout = 80;
                    this.idleAnimationState.method_41322(this.field_6012);
                } else {
                    --this.idleAnimationTimeout;
                }
                this.roarAnimationState.method_41325();
                this.attackAnimationState.method_41325();
                this.stunAnimationState.method_41325();
                break;
            }
            case ROAR: {
                this.stunAnimationState.method_41325();
                this.attackAnimationState.method_41325();
                this.spitAnimationState.method_41325();
                this.roarAnimationState.method_41324(this.field_6012);
                break;
            }
            case STOMP: {
                this.stunAnimationState.method_41325();
                this.roarAnimationState.method_41325();
                this.spitAnimationState.method_41325();
                this.attackAnimationState.method_41324(this.field_6012);
                break;
            }
            case STUNNED: {
                this.stunAnimationState.method_41324(this.field_6012);
            }
        }
    }

    public void method_5711(byte b) {
        if (b == 4) {
            this.spitAnimationState.method_41322(this.field_6012);
        } else {
            super.method_5711(b);
        }
    }

    public boolean canAttack() {
        CruncherState state = this.getState();
        return this.getHunger() > 0 && state == CruncherState.IDLE;
    }

    public boolean isTargetClose() {
        class_1309 entity = (class_1309)this.method_18868().method_18904(class_4140.field_22355).get();
        if (entity.method_31481()) {
            this.method_18868().method_18875(class_4140.field_22355);
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            return player.field_13974.method_14267() && player.method_5739((class_1297)this) <= 9.0f;
        }
        return entity.method_5739((class_1297)this) <= 9.0f;
    }

    public Optional<class_1309> getHurtBy() {
        if (this.getHunger() == 0) {
            return Optional.empty();
        }
        return this.method_18868().method_18904(class_4140.field_18451).map(class_1282::method_5529).filter(class_1309.class::isInstance).map(class_1309.class::cast);
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
        this.method_5783(SpeciesSoundEvents.CRUNCHER_STEP, 1.0f, this.method_6017());
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.getState() == CruncherState.IDLE ? SpeciesSoundEvents.CRUNCHER_IDLE : class_3417.field_42593;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return SpeciesSoundEvents.CRUNCHER_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return SpeciesSoundEvents.CRUNCHER_DEATH;
    }

    public void transitionTo(CruncherState cruncherState) {
        switch (cruncherState) {
            case IDLE: {
                this.setState(CruncherState.IDLE);
                break;
            }
            case ROAR: {
                this.setState(CruncherState.ROAR);
                break;
            }
            case STOMP: {
                this.setState(CruncherState.STOMP);
                break;
            }
            case STUNNED: {
                this.setState(CruncherState.STUNNED);
            }
        }
    }

    public CruncherState getState() {
        return (CruncherState)((Object)this.field_6011.method_12789(CRUNCHER_STATE));
    }

    public void setState(CruncherState cruncherState) {
        this.field_6011.method_12778(CRUNCHER_STATE, (Object)cruncherState);
    }

    public int getStunnedTicks() {
        return (Integer)this.field_6011.method_12789(STUNNED_TICKS);
    }

    public void setStunnedTicks(int stunnedTicks) {
        this.field_6011.method_12778(STUNNED_TICKS, (Object)stunnedTicks);
    }

    public boolean cannotWalk() {
        CruncherState state = this.getState();
        return state != CruncherState.IDLE;
    }

    public boolean hasInventoryChanged(class_1263 container) {
        return this.inventory != container;
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return null;
    }

    public static boolean canSpawn(class_1299<Cruncher> entity, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8407() != class_1267.field_5801 && class_1588.method_20679((class_5425)world, (class_2338)pos, (class_5819)random) && class_1588.method_20636(entity, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random);
    }

    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData, @Nullable class_2487 compoundTag) {
        this.setHunger(3);
        return super.method_5943(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public static enum CruncherState implements class_3542
    {
        IDLE("idle", class_3417.field_42593, 0),
        ROAR("roar", class_3417.field_42593, 80),
        STOMP("stomp", class_3417.field_42593, 20),
        STUNNED("stunned", class_3417.field_42593, 0);

        private final String name;
        private final class_3414 soundEvent;
        private final int duration;

        private CruncherState(String name, class_3414 soundEvents, int duration) {
            this.name = name;
            this.soundEvent = soundEvents;
            this.duration = duration;
        }

        public String method_15434() {
            return this.name;
        }

        public class_3414 getSoundEvent() {
            return this.soundEvent;
        }

        public int getDuration() {
            return this.duration;
        }
    }
}

