/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.entity;

import com.google.common.collect.Lists;
import com.ninni.species.block.entity.BirtDwellingBlockEntity;
import com.ninni.species.entity.ai.goal.BirtCommunicatingGoal;
import com.ninni.species.entity.ai.goal.SendMessageTicksGoal;
import com.ninni.species.registry.SpeciesBlockEntities;
import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_11;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1331;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1856;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4538;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5530;
import net.minecraft.class_5531;
import net.minecraft.class_5533;
import net.minecraft.class_5698;
import net.minecraft.class_5709;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5715;
import net.minecraft.class_5716;
import net.minecraft.class_5745;
import net.minecraft.class_5819;
import net.minecraft.class_5996;
import net.minecraft.class_6019;
import net.minecraft.class_6862;
import net.minecraft.class_7094;
import net.minecraft.class_8514;
import org.jetbrains.annotations.Nullable;

public class Birt
extends class_1429
implements class_5354,
class_1432,
class_8514 {
    public final class_7094 flyingAnimationState = new class_7094();
    public float flapProgress;
    public float maxWingDeviation;
    public float prevMaxWingDeviation;
    public float prevFlapProgress;
    public float flap = 1.0f;
    public int antennaTicks;
    private float flapSpeed = 1.0f;
    public int groundTicks;
    public int messageTicks = 0;
    private static final class_2940<Byte> BIRT_FLAGS = class_2945.method_12791(Birt.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> ANGER = class_2945.method_12791(Birt.class, (class_2941)class_2943.field_13327);
    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)39);
    @Nullable
    private UUID angryAt;
    private int cannotEnterDwellingTicks;
    int ticksLeftToFindDwelling;
    @Nullable
    class_2338 dwellingPos;
    MoveToDwellingGoal moveToDwellingGoal;
    private final VibrationUser vibrationUser;
    private final class_5715<LoudVibrationListener> loudVibrationListener;
    private class_8514.class_8515 vibrationData;

    public Birt(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331((class_1308)this, 20, false);
        this.vibrationUser = new VibrationUser();
        this.vibrationData = new class_8514.class_8515();
        this.loudVibrationListener = new class_5715((class_5714)new LoudVibrationListener(this.vibrationUser.method_51300(), class_5712.field_39485.method_32941()));
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(0, (class_1352)new FindDwellingGoal());
        this.field_6201.method_6277(1, (class_1352)new EnterDwellingGoal());
        this.moveToDwellingGoal = new MoveToDwellingGoal();
        this.field_6201.method_6277(2, (class_1352)this.moveToDwellingGoal);
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.25, class_1856.method_8106((class_6862)class_3489.field_20344), false));
        this.field_6201.method_6277(4, (class_1352)new SendMessageTicksGoal(this));
        this.field_6201.method_6277(5, (class_1352)new BirtCommunicatingGoal(this));
        this.field_6201.method_6277(8, (class_1352)new BirtWanderAroundGoal());
        this.field_6201.method_6277(9, (class_1352)new BirtLookAroundGoal());
    }

    public void method_42147(BiConsumer<class_5715<?>, class_3218> biConsumer) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            biConsumer.accept(this.loudVibrationListener, serverLevel);
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23720, (double)0.6f).method_26868(class_5134.field_23721, 2.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(BIRT_FLAGS, (Object)0);
        this.field_6011.method_12784(ANGER, (Object)0);
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (field_18064.equals(entityDataAccessor)) {
            class_4050 entityPose = this.method_18376();
            if (entityPose == class_4050.field_18077) {
                this.flyingAnimationState.method_41322(this.field_5950);
            } else {
                this.flyingAnimationState.method_41325();
            }
        }
        super.method_5674(entityDataAccessor);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10569("canMessage", this.messageTicks);
        compoundTag.method_10569("CannotEnterDwellingTicks", this.cannotEnterDwellingTicks);
        if (this.hasDwelling()) {
            assert (this.getDwellingPos() != null);
            compoundTag.method_10566("DwellingPos", (class_2520)class_2512.method_10692((class_2338)this.getDwellingPos()));
        }
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.messageTicks = compoundTag.method_10550("canMessage");
        this.cannotEnterDwellingTicks = compoundTag.method_10550("CannotEnterDwellingTicks");
        if (compoundTag.method_10545("DwellingPos")) {
            this.dwellingPos = class_2512.method_10691((class_2487)compoundTag.method_10562("DwellingPos"));
        }
    }

    public void method_6007() {
        super.method_6007();
        class_243 vec3d = this.method_18798();
        if (this.antennaTicks > 0) {
            --this.antennaTicks;
        }
        if (!this.method_24828() && vec3d.field_1351 < 0.0 && this.method_5968() == null) {
            this.method_18799(vec3d.method_18805(1.0, 0.6, 1.0));
        }
        if (this.method_6581()) {
            this.groundTicks = this.field_5974.method_43048(300) + 20;
            this.method_18380(class_4050.field_18077);
        } else {
            --this.groundTicks;
            this.method_18380(class_4050.field_18076);
        }
        if (this.cannotEnterDwellingTicks > 0) {
            --this.cannotEnterDwellingTicks;
        }
        if (this.ticksLeftToFindDwelling > 0) {
            --this.ticksLeftToFindDwelling;
        }
        boolean bl = this.method_29511() && this.method_5968() != null && this.method_5968().method_5858((class_1297)this) < 4.0;
        this.setNearTarget(bl);
        if (this.field_5950 % 20 == 0 && !this.isDwellingValid()) {
            this.dwellingPos = null;
        }
        if (this.messageTicks > 0) {
            --this.messageTicks;
        }
        this.flapWings();
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            class_8514.class_8517.method_51406((class_1937)this.method_37908(), (class_8514.class_8515)this.vibrationData, (class_8514.class_5719)this.vibrationUser);
        }
    }

    void startMovingTo(class_2338 pos) {
        class_243 vec3d2;
        class_243 vec3d = class_243.method_24955((class_2382)pos);
        int i = 0;
        class_2338 blockPos = this.method_24515();
        int j = (int)vec3d.field_1351 - blockPos.method_10264();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int m = blockPos.method_19455((class_2382)pos);
        if (m < 15) {
            k = m / 2;
            l = m / 2;
        }
        if ((vec3d2 = class_5531.method_31508((class_1314)this, (int)k, (int)l, (int)i, (class_243)vec3d, (double)0.3141592741012573)) != null) {
            this.field_6189.method_23964(0.5f);
            this.field_6189.method_6337(vec3d2.field_1352, vec3d2.field_1351, vec3d2.field_1350, 1.0);
        }
    }

    @Nullable
    public Birt findReciever() {
        List list = this.method_37908().method_18466(Birt.class, class_4051.field_18092, (class_1309)this, this.method_5829().method_1014(8.0));
        double d = Double.MAX_VALUE;
        Birt birt = null;
        for (Birt birt2 : list) {
            if (!(this.method_5858((class_1297)birt2) < d)) continue;
            birt = birt2;
            d = this.method_5858((class_1297)birt2);
        }
        return birt;
    }

    public boolean canSendMessage() {
        return this.messageTicks > 0 && this.method_5968() == null;
    }

    public void setMessageTicks(int messageTicks) {
        this.messageTicks = messageTicks;
    }

    public void resetMessageTicks() {
        this.messageTicks = 0;
    }

    public void method_5711(byte status) {
        if (status == 10) {
            this.antennaTicks = 60;
        } else {
            super.method_5711(status);
        }
    }

    public void sendMessage(class_3218 world, Birt other) {
        this.resetMessageTicks();
        other.resetMessageTicks();
        class_5709 positionSource = new class_5709((class_1297)this, 0.75f);
        world.method_8396(null, other.method_24515(), SpeciesSoundEvents.ENTITY_BIRT_MESSAGE, class_3419.field_15254, 1.0f, 0.6f / (world.method_8409().method_43057() * 0.4f + 0.8f));
        world.method_14199((class_2394)new class_5745((class_5716)positionSource, 20), other.method_23317(), other.method_23318() + 0.75, other.method_23321(), 0, 0.0, 0.0, 0.0, 0.0);
    }

    private void flapWings() {
        this.prevFlapProgress = this.flapProgress;
        this.prevMaxWingDeviation = this.maxWingDeviation;
        this.maxWingDeviation += (float)(this.method_24828() || this.method_5765() ? -1 : 4) * 0.3f;
        this.maxWingDeviation = class_3532.method_15363((float)this.maxWingDeviation, (float)0.0f, (float)1.0f);
        if (!this.method_24828() && this.flapSpeed < 1.0f) {
            this.flapSpeed = 1.0f;
        }
        this.flapSpeed *= 0.9f;
        class_243 vec3d = this.method_18798();
        if (!this.method_24828() && vec3d.field_1351 < 0.0) {
            this.method_18799(vec3d.method_18805(1.0, 0.6, 1.0));
        }
        this.flapProgress += this.flapSpeed * 2.0f;
    }

    protected boolean method_5776() {
        return this.field_28627 > this.flap;
    }

    protected void method_5801() {
        this.method_5783(SpeciesSoundEvents.ENTITY_BIRT_FLY, 0.15f, 1.0f);
        this.flap = this.field_28627 + this.maxWingDeviation / 2.0f;
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(ANGER);
    }

    public void method_29514(int angerTime) {
        this.field_6011.method_12778(ANGER, (Object)angerTime);
    }

    @Nullable
    public UUID method_29508() {
        return this.angryAt;
    }

    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    boolean canEnterDwelling() {
        if (this.cannotEnterDwellingTicks <= 0 && this.method_5968() == null) {
            return this.method_37908().method_8530();
        }
        return false;
    }

    public void setCannotEnterDwellingTicks(int cannotEnterDwellingTicks) {
        this.cannotEnterDwellingTicks = cannotEnterDwellingTicks;
    }

    private boolean doesDwellingHaveSpace(class_2338 pos) {
        class_2586 blockEntity = this.method_37908().method_8321(pos);
        if (blockEntity instanceof BirtDwellingBlockEntity) {
            return !((BirtDwellingBlockEntity)blockEntity).isFullOfBirts();
        }
        return false;
    }

    boolean isDwellingValid() {
        if (!this.hasDwelling()) {
            return false;
        }
        class_2586 blockEntity = this.method_37908().method_8321(this.dwellingPos);
        return blockEntity != null && blockEntity.method_11017() == SpeciesBlockEntities.BIRT_DWELLING;
    }

    private void setNearTarget(boolean nearTarget) {
        this.setBirtFlag(2, nearTarget);
    }

    boolean isTooFar(class_2338 pos) {
        return !this.isWithinDistance(pos, 32);
    }

    private void setBirtFlag(int bit, boolean value) {
        if (value) {
            this.field_6011.method_12778(BIRT_FLAGS, (Object)((byte)((Byte)this.field_6011.method_12789(BIRT_FLAGS) | bit)));
        } else {
            this.field_6011.method_12778(BIRT_FLAGS, (Object)((byte)((Byte)this.field_6011.method_12789(BIRT_FLAGS) & ~bit)));
        }
    }

    @class_5996
    public boolean hasDwelling() {
        return this.dwellingPos != null;
    }

    @Nullable
    @class_5996
    public class_2338 getDwellingPos() {
        return this.dwellingPos;
    }

    boolean isWithinDistance(class_2338 pos, int distance) {
        return pos.method_19771((class_2382)this.method_24515(), (double)distance);
    }

    public float method_6144(class_2338 blockPos, class_4538 levelReader) {
        return levelReader.method_8320(blockPos).method_26215() ? 10.0f : 0.0f;
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return null;
    }

    public boolean method_5747(float f, float g, class_1282 damageSource) {
        return false;
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
    }

    protected void method_5623(double d, boolean bl, class_2680 blockState, class_2338 blockPos) {
    }

    protected class_1408 method_5965(class_1937 level) {
        class_1407 flyingPathNavigation = new class_1407((class_1308)this, level){

            public boolean method_6333(class_2338 blockPos) {
                return !this.field_6677.method_8320(blockPos.method_10074()).method_26215();
            }
        };
        flyingPathNavigation.method_6332(false);
        flyingPathNavigation.method_6354(false);
        flyingPathNavigation.method_6331(true);
        return flyingPathNavigation;
    }

    public static boolean canSpawn(class_1299<? extends class_1429> type, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return false;
    }

    @Nullable
    protected class_3414 method_5994() {
        return SpeciesSoundEvents.ENTITY_BIRT_IDLE;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return SpeciesSoundEvents.ENTITY_BIRT_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return SpeciesSoundEvents.ENTITY_BIRT_DEATH;
    }

    public class_8514.class_8515 method_51298() {
        return this.vibrationData;
    }

    public class_8514.class_5719 method_51299() {
        return this.vibrationUser;
    }

    public static boolean isLoudNoise(class_5712 gameEvent, class_3218 serverLevel, class_2338 blockPos) {
        return gameEvent == class_5712.field_28178 || gameEvent == class_5712.field_39415 || gameEvent == class_5712.field_39485 || gameEvent == class_5712.field_28733 && serverLevel.method_8320(blockPos).method_27852(class_2246.field_16332);
    }

    public class VibrationUser
    implements class_8514.class_5719 {
        private static final int VIBRATION_EVENT_LISTENER_RANGE = 16;
        private final class_5716 positionSource;

        VibrationUser() {
            this.positionSource = new class_5709((class_1297)Birt.this, Birt.this.method_5751());
        }

        public int method_49797() {
            return 16;
        }

        public class_5716 method_51300() {
            return this.positionSource;
        }

        public boolean method_32970(class_3218 serverLevel, class_2338 blockPos, class_5712 gameEvent, class_5712.class_7397 context) {
            if (Birt.this.method_5987()) {
                return false;
            }
            return Birt.this.method_5968() != null;
        }

        public void method_32969(class_3218 serverLevel, class_2338 blockPos, class_5712 gameEvent, @Nullable class_1297 entity, @Nullable class_1297 entity2, float f) {
        }

        public class_6862<class_5712> method_42210() {
            return class_5698.field_39031;
        }
    }

    public class LoudVibrationListener
    implements class_5714 {
        private final class_5716 listenerSource;
        private final int listenerRadius;

        public LoudVibrationListener(class_5716 positionSource, int i) {
            this.listenerSource = positionSource;
            this.listenerRadius = i;
        }

        public class_5716 method_32946() {
            return this.listenerSource;
        }

        public int method_32948() {
            return this.listenerRadius;
        }

        public boolean method_32947(class_3218 serverLevel, class_5712 gameEvent, class_5712.class_7397 context, class_243 vec3) {
            class_2338 blockPos = class_2338.method_49638((class_2374)vec3);
            if (Birt.isLoudNoise(gameEvent, serverLevel, blockPos)) {
                Birt.this.method_5980(null);
                return true;
            }
            return false;
        }
    }

    private class FindDwellingGoal
    extends NotAngryGoal {
        FindDwellingGoal() {
        }

        @Override
        public boolean canBirtStart() {
            return Birt.this.ticksLeftToFindDwelling == 0 && !Birt.this.hasDwelling() && Birt.this.canEnterDwelling();
        }

        @Override
        public boolean canBirtContinue() {
            return false;
        }

        public void method_6269() {
            Birt.this.ticksLeftToFindDwelling = 200;
            List<class_2338> list = this.getNearbyFreeDwellings();
            if (!list.isEmpty()) {
                class_2338 blockPos;
                Iterator<class_2338> var2 = list.iterator();
                do {
                    if (var2.hasNext()) continue;
                    Birt.this.moveToDwellingGoal.clearPossibleDwellings();
                    Birt.this.dwellingPos = list.get(0);
                    return;
                } while (Birt.this.moveToDwellingGoal.isPossibleDwelling(blockPos = var2.next()));
                Birt.this.dwellingPos = blockPos;
            }
        }

        private List<class_2338> getNearbyFreeDwellings() {
            class_2338 blockPos = Birt.this.method_24515();
            class_4153 pointOfInterestStorage = ((class_3218)Birt.this.method_37908()).method_19494();
            Stream stream = pointOfInterestStorage.method_19125(poiType -> poiType.method_40220(SpeciesTags.BIRT_HOME), blockPos, 20, class_4153.class_4155.field_18489);
            return stream.map(class_4156::method_19141).filter(Birt.this::doesDwellingHaveSpace).sorted(Comparator.comparingDouble(blockPos2 -> blockPos2.method_10262((class_2382)blockPos))).collect(Collectors.toList());
        }
    }

    class EnterDwellingGoal
    extends NotAngryGoal {
        EnterDwellingGoal() {
        }

        @Override
        public boolean canBirtStart() {
            if (Birt.this.hasDwelling() && Birt.this.canEnterDwelling()) {
                class_2586 blockEntity;
                assert (Birt.this.dwellingPos != null);
                if (Birt.this.dwellingPos.method_19769((class_2374)Birt.this.method_19538(), 2.0) && (blockEntity = Birt.this.method_37908().method_8321(Birt.this.dwellingPos)) instanceof BirtDwellingBlockEntity) {
                    BirtDwellingBlockEntity blockEntity1 = (BirtDwellingBlockEntity)blockEntity;
                    if (!blockEntity1.isFullOfBirts()) {
                        return true;
                    }
                    Birt.this.dwellingPos = null;
                }
            }
            return false;
        }

        @Override
        public boolean canBirtContinue() {
            return false;
        }

        public void method_6269() {
            class_2586 blockEntity = Birt.this.method_37908().method_8321(Birt.this.dwellingPos);
            if (blockEntity instanceof BirtDwellingBlockEntity) {
                BirtDwellingBlockEntity birtDwellingBlockEntity = (BirtDwellingBlockEntity)blockEntity;
                birtDwellingBlockEntity.tryEnterDwelling((class_1297)Birt.this);
            }
        }
    }

    @class_5996
    public class MoveToDwellingGoal
    extends NotAngryGoal {
        int ticks;
        final List<class_2338> possibleDwellings;
        @Nullable
        private class_11 path;
        private int ticksUntilLost;

        MoveToDwellingGoal() {
            this.ticks = Birt.this.method_37908().field_9229.method_43048(10);
            this.possibleDwellings = Lists.newArrayList();
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        @Override
        public boolean canBirtStart() {
            return Birt.this.dwellingPos != null && !Birt.this.method_18410() && Birt.this.canEnterDwelling() && !this.isCloseEnough(Birt.this.dwellingPos) && Birt.this.method_37908().method_8320(Birt.this.dwellingPos).method_27852(SpeciesBlocks.BIRT_DWELLING);
        }

        @Override
        public boolean canBirtContinue() {
            return this.canBirtStart();
        }

        public void method_6269() {
            this.ticks = 0;
            this.ticksUntilLost = 0;
            super.method_6269();
        }

        public void method_6270() {
            this.ticks = 0;
            this.ticksUntilLost = 0;
            Birt.this.field_6189.method_6340();
            Birt.this.field_6189.method_23965();
        }

        public void method_6268() {
            if (Birt.this.dwellingPos != null) {
                ++this.ticks;
                if (this.ticks > this.method_38847(600)) {
                    this.makeChosenDwellingPossibleDwelling();
                } else if (!Birt.this.field_6189.method_23966()) {
                    if (!Birt.this.isWithinDistance(Birt.this.dwellingPos, 16)) {
                        if (Birt.this.isTooFar(Birt.this.dwellingPos)) {
                            this.setLost();
                        } else {
                            Birt.this.startMovingTo(Birt.this.dwellingPos);
                        }
                    } else {
                        boolean bl = this.startMovingToFar(Birt.this.dwellingPos);
                        if (!bl) {
                            this.makeChosenDwellingPossibleDwelling();
                        } else if (this.path != null && Objects.requireNonNull(Birt.this.field_6189.method_6345()).method_41(this.path)) {
                            ++this.ticksUntilLost;
                            if (this.ticksUntilLost > 60) {
                                this.setLost();
                                this.ticksUntilLost = 0;
                            }
                        } else {
                            this.path = Birt.this.field_6189.method_6345();
                        }
                    }
                }
            }
        }

        private boolean startMovingToFar(class_2338 pos) {
            Birt.this.field_6189.method_23964(10.0f);
            Birt.this.field_6189.method_6337((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 1.0);
            return Birt.this.field_6189.method_6345() != null && Birt.this.field_6189.method_6345().method_21655();
        }

        boolean isPossibleDwelling(class_2338 pos) {
            return this.possibleDwellings.contains(pos);
        }

        private void addPossibleDwelling(class_2338 pos) {
            this.possibleDwellings.add(pos);
            while (this.possibleDwellings.size() > 3) {
                this.possibleDwellings.remove(0);
            }
        }

        void clearPossibleDwellings() {
            this.possibleDwellings.clear();
        }

        private void makeChosenDwellingPossibleDwelling() {
            if (Birt.this.dwellingPos != null) {
                this.addPossibleDwelling(Birt.this.dwellingPos);
            }
            this.setLost();
        }

        private void setLost() {
            Birt.this.dwellingPos = null;
            Birt.this.ticksLeftToFindDwelling = 200;
        }

        private boolean isCloseEnough(class_2338 pos) {
            if (Birt.this.isWithinDistance(pos, 2)) {
                return true;
            }
            class_11 path = Birt.this.field_6189.method_6345();
            return path != null && path.method_48().equals((Object)pos) && path.method_21655() && path.method_46();
        }
    }

    class BirtWanderAroundGoal
    extends class_1352 {
        BirtWanderAroundGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (Birt.this.groundTicks < 0) {
                return true;
            }
            if (Birt.this.method_6581()) {
                return Birt.this.field_6189.method_6357() && Birt.this.field_5974.method_43048(10) == 0;
            }
            return false;
        }

        public boolean method_6266() {
            return Birt.this.field_6189.method_23966();
        }

        public void method_6269() {
            class_243 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                Birt.this.field_6189.method_6334(Birt.this.field_6189.method_6348(new class_2338((int)vec3d.field_1352, (int)vec3d.field_1351, (int)vec3d.field_1350), 1), 1.0);
            }
        }

        @Nullable
        private class_243 getRandomLocation() {
            class_243 vec3d2;
            assert (Birt.this.dwellingPos != null);
            if (Birt.this.isDwellingValid() && !Birt.this.isWithinDistance(Birt.this.dwellingPos, 22)) {
                class_243 vec3d = class_243.method_24953((class_2382)Birt.this.dwellingPos);
                vec3d2 = vec3d.method_1020(Birt.this.method_19538()).method_1029();
            } else {
                vec3d2 = Birt.this.method_5828(0.0f);
            }
            class_243 vec3d3 = class_5533.method_31524((class_1314)Birt.this, (int)12, (int)5, (double)vec3d2.field_1352, (double)vec3d2.field_1350, (float)1.5707964f, (int)3, (int)1);
            return vec3d3 != null ? vec3d3 : class_5530.method_31504((class_1314)Birt.this, (int)12, (int)2, (int)-2, (double)vec3d2.field_1352, (double)vec3d2.field_1350, (double)1.5707963705062866);
        }
    }

    class BirtLookAroundGoal
    extends class_1376 {
        BirtLookAroundGoal() {
            super((class_1308)Birt.this);
        }

        public boolean method_6264() {
            return Birt.this.method_24828() && super.method_6264();
        }

        public boolean method_6266() {
            return Birt.this.method_24828() && super.method_6266();
        }
    }

    private abstract class NotAngryGoal
    extends class_1352 {
        NotAngryGoal() {
        }

        public abstract boolean canBirtStart();

        public abstract boolean canBirtContinue();

        public boolean method_6264() {
            return this.canBirtStart() && !Birt.this.method_29511();
        }

        public boolean method_6266() {
            return this.canBirtContinue() && !Birt.this.method_29511();
        }
    }
}

