/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.block;

import com.ninni.species.block.property.BoneSpikeThickness;
import com.ninni.species.block.property.SpeciesProperties;
import com.ninni.species.registry.SpeciesBlocks;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BoneSpikeBlock
extends class_2248
implements class_3737 {
    public static final class_2753 TIP_DIRECTION = class_2741.field_28062;
    public static final class_2754<BoneSpikeThickness> THICKNESS = SpeciesProperties.BONE_SPIKE_THICKNESS;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 TIP_SHAPE_UP = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final class_265 TIP_SHAPE_DOWN = class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 MIDDLE_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_265 BASE_SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public BoneSpikeBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)TIP_DIRECTION, (Comparable)class_2350.field_11036)).method_11657(THICKNESS, (Comparable)((Object)BoneSpikeThickness.TIP))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean method_9558(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        return BoneSpikeBlock.isValidSpikePlacement(levelReader, blockPos, (class_2350)blockState.method_11654((class_2769)TIP_DIRECTION));
    }

    public class_2680 method_9559(class_2680 blockState, class_2350 direction, class_2680 blockState2, class_1936 levelAccessor, class_2338 blockPos, class_2338 blockPos2) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            levelAccessor.method_39281(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)levelAccessor));
        }
        if (direction != class_2350.field_11036 && direction != class_2350.field_11033) {
            return blockState;
        }
        class_2350 direction2 = (class_2350)blockState.method_11654((class_2769)TIP_DIRECTION);
        if (direction2 == class_2350.field_11033 && levelAccessor.method_8397().method_8674(blockPos, (Object)this)) {
            return blockState;
        }
        if (direction == direction2.method_10153() && !this.method_9558(blockState, (class_4538)levelAccessor, blockPos)) {
            if (direction2 == class_2350.field_11033) {
                levelAccessor.method_39279(blockPos, (class_2248)this, 2);
            } else {
                levelAccessor.method_39279(blockPos, (class_2248)this, 1);
            }
            return blockState;
        }
        BoneSpikeThickness BoneSpikeThickness2 = BoneSpikeBlock.calculateBoneSpikeThickness((class_4538)levelAccessor, blockPos, direction2);
        return (class_2680)blockState.method_11657(THICKNESS, (Comparable)((Object)BoneSpikeThickness2));
    }

    public void method_9554(class_1937 level, class_2680 blockState, class_2338 blockPos, class_1297 entity, float f) {
        super.method_9554(level, blockState, blockPos, entity, f);
    }

    public void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (!this.method_9558(blockState, (class_4538)serverLevel, blockPos)) {
            serverLevel.method_22352(blockPos, true);
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        class_2338 blockPos;
        class_1937 levelAccessor = blockPlaceContext.method_8045();
        class_2350 direction2 = BoneSpikeBlock.calculateTipDirection((class_4538)levelAccessor, blockPos = blockPlaceContext.method_8037(), blockPlaceContext.method_32760().method_10153());
        if (direction2 == null) {
            return null;
        }
        BoneSpikeThickness BoneSpikeThickness2 = BoneSpikeBlock.calculateBoneSpikeThickness((class_4538)levelAccessor, blockPos, direction2);
        if (BoneSpikeThickness2 == null) {
            return null;
        }
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)TIP_DIRECTION, (Comparable)direction2)).method_11657(THICKNESS, (Comparable)((Object)BoneSpikeThickness2))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.method_8316(blockPos).method_15772() == class_3612.field_15910));
    }

    public class_3610 method_9545(class_2680 blockState) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(blockState);
    }

    public class_265 method_9571(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return class_259.method_1073();
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        BoneSpikeThickness thickness = (BoneSpikeThickness)((Object)blockState.method_11654(THICKNESS));
        class_265 voxelShape = thickness == BoneSpikeThickness.TIP ? (blockState.method_11654((class_2769)TIP_DIRECTION) == class_2350.field_11033 ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (thickness == BoneSpikeThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE);
        class_243 vec3 = blockState.method_26226(blockGetter, blockPos);
        return voxelShape.method_1096(vec3.field_1352, 0.0, vec3.field_1350);
    }

    public boolean method_37403(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return false;
    }

    @Nullable
    private static class_2350 calculateTipDirection(class_4538 levelReader, class_2338 blockPos, class_2350 direction) {
        class_2350 direction2;
        if (BoneSpikeBlock.isValidSpikePlacement(levelReader, blockPos, direction)) {
            direction2 = direction;
        } else if (BoneSpikeBlock.isValidSpikePlacement(levelReader, blockPos, direction.method_10153())) {
            direction2 = direction.method_10153();
        } else {
            return null;
        }
        return direction2;
    }

    private static BoneSpikeThickness calculateBoneSpikeThickness(class_4538 levelReader, class_2338 blockPos, class_2350 direction) {
        class_2350 direction2 = direction.method_10153();
        class_2680 blockState = levelReader.method_8320(blockPos.method_10093(direction));
        if (BoneSpikeBlock.isBoneSpikeWithDirection(blockState, direction2)) {
            return BoneSpikeThickness.TIP;
        }
        if (!BoneSpikeBlock.isBoneSpikeWithDirection(blockState, direction)) {
            return BoneSpikeThickness.TIP;
        }
        class_2680 blockState2 = levelReader.method_8320(blockPos.method_10093(direction2));
        if (!BoneSpikeBlock.isBoneSpikeWithDirection(blockState2, direction)) {
            return BoneSpikeThickness.BASE;
        }
        return BoneSpikeThickness.MIDDLE;
    }

    private static boolean isValidSpikePlacement(class_4538 levelReader, class_2338 blockPos, class_2350 direction) {
        class_2338 blockPos2 = blockPos.method_10093(direction.method_10153());
        class_2680 blockState = levelReader.method_8320(blockPos2);
        return blockState.method_26206((class_1922)levelReader, blockPos2, direction) || BoneSpikeBlock.isBoneSpikeWithDirection(blockState, direction);
    }

    public boolean method_9516(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_10 pathComputationType) {
        return false;
    }

    private static boolean isBoneSpikeWithDirection(class_2680 blockState, class_2350 direction) {
        return blockState.method_27852(SpeciesBlocks.BONE_SPIKE) && blockState.method_11654((class_2769)TIP_DIRECTION) == direction;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }
}

