/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.typewriter;

import com.mojang.datafixers.util.Pair;
import org.jetbrains.annotations.Nullable;
import snownee.textanimator.effect.Effect;
import snownee.textanimator.effect.EffectSettings;
import snownee.textanimator.effect.params.Params;

public class TypewriterEffect
implements Effect {
    public TypewriterEffect(Params params) {
    }

    @Nullable
    public static Pair<TypewriterEffect, Integer> find(String text) {
        if (!text.startsWith("<typewriter")) {
            return null;
        }
        int endIndex = text.indexOf(62);
        if (endIndex == -1) {
            return null;
        }
        try {
            Effect effect = Effect.create(text.substring(1, endIndex), true);
            if (effect instanceof TypewriterEffect) {
                return Pair.of((Object)((TypewriterEffect)effect), (Object)(endIndex + 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void apply(EffectSettings settings) {
        if (settings.typewriterTrack == null) {
            return;
        }
        if (settings.typingIndex >= settings.typewriterTrack.index) {
            settings.a = 0.0f;
        }
    }

    @Override
    public String getName() {
        return "typewriter";
    }
}

