/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.effect;

import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import snownee.textanimator.effect.EffectFactory;
import snownee.textanimator.effect.EffectSettings;
import snownee.textanimator.effect.params.EmptyParams;
import snownee.textanimator.effect.params.Params;
import snownee.textanimator.effect.params.TypedParams;

public interface Effect {
    @NotNull
    public static Effect create(String[] split, boolean allowTypewriter) {
        if (split.length == 0) {
            throw new IllegalArgumentException("Empty input");
        }
        if (!allowTypewriter && "typewriter".equals(split[0])) {
            throw new IllegalArgumentException("Typewriter effect is not allowed here");
        }
        Params params = EmptyParams.INSTANCE;
        if (split.length > 1) {
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)(split.length - 1));
            for (int i = 1; i < split.length; ++i) {
                String[] kv = StringUtils.split((String)split[i], (String)"=", (int)2);
                if (kv.length < 2) continue;
                if ("true".equals(kv[1]) || "false".equals(kv[1])) {
                    builder.put((Object)kv[0], (Object)Boolean.parseBoolean(kv[1]));
                    continue;
                }
                try {
                    builder.put((Object)kv[0], (Object)Double.parseDouble(kv[1]));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid effect parameter: " + kv[0] + "=" + kv[1]);
                }
            }
            params = new TypedParams((ImmutableMap<String, Object>)builder.build());
        }
        return EffectFactory.create(split[0], params);
    }

    @NotNull
    public static Effect create(String tagContent, boolean allowTypewriter) {
        return Effect.create(StringUtils.split((String)tagContent, (char)' '), allowTypewriter);
    }

    public void apply(EffectSettings var1);

    public String getName();

    default public String serialize() {
        return this.getName();
    }
}

