/*
 * Decompiled with CFR 0.152.
 */
package snownee.textanimator.compat;

import com.google.common.collect.ImmutableList;
import earth.terrarium.hermes.api.TagElement;
import earth.terrarium.hermes.api.TagElementSerializer;
import earth.terrarium.hermes.api.text.StyledTagElement;
import earth.terrarium.hermes.api.text.TextTagProvider;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import snownee.textanimator.duck.TAStyle;
import snownee.textanimator.effect.Effect;
import snownee.textanimator.effect.EffectFactory;
import snownee.textanimator.effect.params.EmptyParams;
import snownee.textanimator.effect.params.Params;
import snownee.textanimator.effect.params.StringPairParams;
import snownee.textanimator.typewriter.TypewriterTracks;
import snownee.textanimator.util.CommonProxy;

public class HermesCompat {
    public static void onEffectTypeRegistered(String type, Function<Params, Effect> factory) {
        TextTagProvider.INSTANCE.addSerializer(type, (TagElementSerializer)new AdditionSerializer(type, factory));
        TextTagProvider.INSTANCE.addSerializer("!" + type, (TagElementSerializer)new RemovalSerializer(type));
    }

    public record AdditionSerializer(String type, Function<Params, Effect> factory) implements TagElementSerializer
    {
        public TagElement deserialize(Map<String, String> parameters) {
            Effect effect;
            Params params = EmptyParams.INSTANCE;
            if (!parameters.isEmpty()) {
                params = new StringPairParams(parameters);
            }
            if ((effect = EffectFactory.create(this.type, params)) == null) {
                return new StyledTagElement(UnaryOperator.identity());
            }
            return new StyledTagElement(style -> {
                style = CommonProxy.clone(style);
                TAStyle taStyle = (TAStyle)style;
                taStyle.textanimator$addEffect(effect);
                if ("typewriter".equals(this.type)) {
                    taStyle.textanimator$setTypewriterTrack(TypewriterTracks.getInstance().get(new Object()));
                }
                return style;
            });
        }
    }

    public record RemovalSerializer(String type) implements TagElementSerializer
    {
        public TagElement deserialize(Map<String, String> parameters) {
            return new StyledTagElement(style -> {
                TAStyle taStyle = (TAStyle)(style = CommonProxy.clone(style));
                ImmutableList<Effect> effects = taStyle.textanimator$getEffects();
                if (!effects.isEmpty() && ((Effect)effects.get(effects.size() - 1)).getName().equals(this.type)) {
                    taStyle.textanimator$setEffects((ImmutableList<Effect>)effects.subList(0, effects.size() - 1));
                    if ("typewriter".equals(this.type)) {
                        taStyle.textanimator$setTypewriterTrack(null);
                    }
                }
                return style;
            });
        }
    }
}

