/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdar.api;

import chronosacaria.mcdar.api.AbilityHelper;
import chronosacaria.mcdar.api.CleanlinessHelper;
import chronosacaria.mcdar.mixin.CreeperEntityAccessor;
import chronosacaria.mcdar.registries.StatusEffectInit;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1438;
import net.minecraft.class_1452;
import net.minecraft.class_1481;
import net.minecraft.class_1538;
import net.minecraft.class_1548;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class AOEHelper {
    public static List<class_1309> getEntitiesByPredicate(class_1309 center, float distance, Predicate<? super class_1309> predicate) {
        return center.method_5770().method_8390(class_1309.class, new class_238(center.method_24515()).method_1014((double)distance), predicate);
    }

    public static List<? extends class_1309> getEntitiesByPredicate(Class<? extends class_1309> entityType, class_1309 center, float distance, Predicate<? super class_1309> predicate) {
        return center.method_5770().method_8390(entityType, new class_238(center.method_24515()).method_1014((double)distance), predicate);
    }

    public static void afflictNearbyEntities(class_1309 user, class_1293 ... statusEffectInstances) {
        for (class_1309 nearbyEntity2 : AOEHelper.getEntitiesByPredicate(user, 5.0f, nearbyEntity -> nearbyEntity != user && !AbilityHelper.isPetOf(nearbyEntity, user) && nearbyEntity.method_5805())) {
            for (class_1293 instance : statusEffectInstances) {
                nearbyEntity2.method_6092(instance);
            }
        }
    }

    public static void afflictNearbyEntities(Class<? extends class_1309> entityType, class_1309 user, float distance, Predicate<? super class_1309> predicate, class_1293 ... statusEffectInstances) {
        for (class_1309 class_13092 : AOEHelper.getEntitiesByPredicate(entityType, user, distance, predicate)) {
            for (class_1293 instance : statusEffectInstances) {
                class_13092.method_6092(instance);
            }
        }
    }

    public static void affectNearbyEntities(class_1309 user, Consumer<class_1309> method) {
        for (class_1309 nearbyEntity2 : AOEHelper.getEntitiesByPredicate(user, 5.0f, nearbyEntity -> nearbyEntity != user && !AbilityHelper.isPetOf(nearbyEntity, user) && nearbyEntity.method_5805())) {
            method.accept(nearbyEntity2);
        }
    }

    public static void affectNearbyEntities(class_1309 user, float distance, Predicate<? super class_1309> predicate, Consumer<class_1309> method) {
        for (class_1309 nearbyEntity : AOEHelper.getEntitiesByPredicate(user, distance, predicate)) {
            method.accept(nearbyEntity);
        }
    }

    public static void affectNearbyEntities(Class<? extends class_1309> entityType, class_1309 user, float distance, Predicate<? super class_1309> predicate, Consumer<class_1309> method) {
        for (class_1309 class_13092 : AOEHelper.getEntitiesByPredicate(entityType, user, distance, predicate)) {
            method.accept(class_13092);
        }
    }

    public static void summonLightningBoltOnEntity(class_1297 target) {
        class_2940<Boolean> charged = CreeperEntityAccessor.getCHARGED();
        class_1937 world = target.method_5770();
        class_1538 lightningEntity = (class_1538)class_1299.field_6112.method_5883(world);
        if (lightningEntity != null) {
            lightningEntity.method_24203(target.method_23317(), target.method_23318(), target.method_23321());
            lightningEntity.method_29498(true);
            if (target instanceof class_1548) {
                class_1548 creeperEntity = (class_1548)target;
                creeperEntity.method_5841().method_12778(charged, (Object)true);
            }
            if (target instanceof class_1438) {
                class_1438 mooshroomEntity = (class_1438)target;
                mooshroomEntity.method_5800((class_3218)world, lightningEntity);
            }
            if (target instanceof class_1452) {
                class_1452 pigEntity = (class_1452)target;
                pigEntity.method_5800((class_3218)world, lightningEntity);
            }
            if (target instanceof class_1481) {
                class_1481 turtleEntity = (class_1481)target;
                turtleEntity.method_5800((class_3218)world, lightningEntity);
            }
            if (target instanceof class_1646) {
                class_1646 villagerEntity = (class_1646)target;
                villagerEntity.method_5800((class_3218)world, lightningEntity);
            }
            world.method_8649((class_1297)lightningEntity);
        }
    }

    public static void electrocute(class_1309 victim, float damageAmount) {
        AOEHelper.summonLightningBoltOnEntity((class_1297)victim);
        victim.method_5643(victim.method_37908().method_48963().method_48809(), damageAmount);
    }

    public static void electrocuteNearbyEnemies(class_1309 user, float distance, float damageAmount, int limit) {
        CleanlinessHelper.playCenteredSound(user, class_3417.field_14865, class_3419.field_15252, 1.0f, 1.0f);
        CleanlinessHelper.playCenteredSound(user, class_3417.field_14956, class_3419.field_15252, 1.0f, 1.0f);
        for (class_1309 nearbyEntity2 : AOEHelper.getEntitiesByPredicate(user, distance, nearbyEntity -> AbilityHelper.isAoeTarget(nearbyEntity, user, user))) {
            AOEHelper.electrocute(nearbyEntity2, damageAmount);
            if (--limit > 0) continue;
            break;
        }
    }

    public static void causeExplosion(class_1309 user, class_1309 target, float damageAmount, float distance) {
        for (class_1309 nearbyEntity2 : AOEHelper.getEntitiesByPredicate(target, distance, nearbyEntity -> AbilityHelper.isAoeTarget(nearbyEntity, user, target))) {
            nearbyEntity2.method_5643(nearbyEntity2.method_37908().method_48963().method_48819((class_1297)target, (class_1297)user), damageAmount);
        }
    }

    public static void knockbackNearbyEnemies(class_1657 user, class_1309 nearbyEntity, float knockbackMultiplier) {
        double xRatio = user.method_23317() - nearbyEntity.method_23317();
        double zRatio = user.method_23321() - nearbyEntity.method_23321();
        while (xRatio * xRatio + zRatio < 1.0E-4) {
            xRatio = (CleanlinessHelper.RANDOM.method_43058() - CleanlinessHelper.RANDOM.method_43058()) * 0.01;
            zRatio = (CleanlinessHelper.RANDOM.method_43058() - CleanlinessHelper.RANDOM.method_43058()) * 0.01;
        }
        nearbyEntity.method_6005((double)(0.4f * knockbackMultiplier), xRatio, zRatio);
    }

    public static void satchelOfElementsEffects(class_1657 user) {
        int effectInt = CleanlinessHelper.RANDOM.method_43048(3);
        if (effectInt == 0) {
            for (class_1309 nearbyEntity2 : AOEHelper.getEntitiesByPredicate((class_1309)user, 5.0f, nearbyEntity -> nearbyEntity != user && !AbilityHelper.isPetOf(nearbyEntity, (class_1309)user) && nearbyEntity.method_5805())) {
                nearbyEntity2.method_5639(3);
            }
        }
        if (effectInt == 1) {
            AOEHelper.afflictNearbyEntities((class_1309)user, new class_1293(StatusEffectInit.STUNNED, 100), new class_1293(class_1294.field_5916, 100), new class_1293(class_1294.field_5909, 100, 4));
        }
        if (effectInt == 2) {
            for (class_1309 nearbyEntity2 : AOEHelper.getEntitiesByPredicate((class_1309)user, 5.0f, nearbyEntity -> nearbyEntity != user && !AbilityHelper.isPetOf(nearbyEntity, (class_1309)user) && nearbyEntity.method_5805())) {
                AOEHelper.summonLightningBoltOnEntity((class_1297)nearbyEntity2);
                nearbyEntity2.method_5643(nearbyEntity2.method_37908().method_48963().method_48809(), 5.0f);
            }
        }
    }

    private static void addParticles(class_3218 world, class_1309 nearbyEntity, class_2394 particleEffect) {
        double velX = 0.0;
        double velY = 1.0;
        double velZ = 0.0;
        double startX = nearbyEntity.method_23317() - (double)0.275f;
        double startY = nearbyEntity.method_23318();
        double startZ = nearbyEntity.method_23321() - (double)0.275f;
        for (int i = 0; i < 10; ++i) {
            double frontX = 0.5 * world.method_8409().method_43058();
            world.method_14199(particleEffect, startX + frontX, startY + world.method_8409().method_43058() * 0.5, startZ + 0.5, 1, velX, velY, velZ, 0.0);
            double backX = 0.5 * world.method_8409().method_43058();
            world.method_14199(particleEffect, startX + backX, startY + world.method_8409().method_43058() * 0.5, startZ, 1, velX, velY, velZ, 0.0);
            double leftZ = 0.5 * world.method_8409().method_43058();
            world.method_14199(particleEffect, startX, startY + world.method_8409().method_43058() * 0.5, startZ + leftZ, 1, velX, velY, velZ, 0.0);
            double rightZ = 0.5 * world.method_8409().method_43058();
            world.method_14199(particleEffect, startX + 0.5, startY + world.method_8409().method_43058() * 0.5, startZ + rightZ, 1, velX, velY, velZ, 0.0);
        }
    }
}

