/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.network;

import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.network.IMessage;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class BossTypeSyncMessage
implements IMessage {
    public static final class_2960 ID = new class_2960("brutalbosses", "bosstypes");
    private Collection<BossType> bossTypes = new HashSet<BossType>();

    public BossTypeSyncMessage(Collection<BossType> values) {
        this.bossTypes = values;
    }

    public BossTypeSyncMessage() {
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.writeInt(this.bossTypes.size());
        for (BossType type : this.bossTypes) {
            buffer.method_10794(type.serializeToClient());
        }
    }

    @Override
    public BossTypeSyncMessage read(class_2540 buffer) {
        int count = buffer.readInt();
        this.bossTypes = new ArrayList<BossType>();
        for (int i = 0; i < count; ++i) {
            BossType type = BossType.deserializeAtClient(buffer.method_10798());
            if (type == null) continue;
            this.bossTypes.add(type);
        }
        return this;
    }

    @Override
    public void handle(class_634 handler, class_310 client) {
        ImmutableMap.Builder bossTypesImm = ImmutableMap.builder();
        for (BossType type : this.bossTypes) {
            bossTypesImm.put((Object)type.getID(), (Object)type);
        }
        BossTypeManager.instance.bosses = bossTypesImm.build();
    }

    @Override
    public class_2960 getID() {
        return ID;
    }
}

