/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1603;
import net.minecraft.class_1617;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5425;
import net.minecraft.class_7923;

public class SummonMobsGoal
extends class_1352 {
    public static class_2960 ID = new class_2960("brutalbosses:summonmobs");
    private final class_1308 mob;
    private class_1309 target = null;
    private final SummonParams params;
    private final List<class_1309> summonedMobs = new ArrayList<class_1309>();
    private int ticksToNextUpdate = 0;

    public SummonMobsGoal(class_1308 mob, IAIParams params) {
        this.mob = mob;
        this.params = (SummonParams)params;
        class_268 team = mob.method_37908().method_8428().method_1153("bb:bossteam");
        if (team == null) {
            team = mob.method_37908().method_8428().method_1171("bb:bossteam");
        }
        mob.method_37908().method_8428().method_1172(mob.method_5820(), team);
    }

    public boolean method_6264() {
        class_1309 target = this.mob.method_5968();
        if (target != null && target.method_5805() && this.params.entityIDs.size() > 0) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void method_6269() {
        this.ticksToNextUpdate = Math.max(50, this.ticksToNextUpdate);
    }

    public void method_6270() {
        this.target = null;
    }

    public void method_6268() {
        this.summonedMobs.removeIf(summoned -> {
            if (!summoned.method_5805()) {
                if (this.params.ownerdamage > 0.0f && this.mob.method_6032() > this.mob.method_6063() * 0.1f) {
                    this.mob.method_6033(Math.max(this.mob.method_6063() * 0.1f, this.mob.method_6032() - this.mob.method_6063() * this.params.ownerdamage));
                }
                return true;
            }
            return false;
        });
        if (--this.ticksToNextUpdate > 0) {
            if (this.ticksToNextUpdate < 30 && this.mob instanceof class_1617) {
                ((class_1617)this.mob).method_7138(class_1617.class_1618.field_7381);
            }
            return;
        }
        if (this.mob instanceof class_1617) {
            ((class_1617)this.mob).method_7138(class_1617.class_1618.field_7377);
        }
        this.ticksToNextUpdate = this.params.interval;
        for (int i = 0; i < this.params.count; ++i) {
            this.trySummonMob();
        }
    }

    private void trySummonMob() {
        class_1309 summoned;
        if (this.summonedMobs.size() >= this.params.maxcount) {
            return;
        }
        class_1299<? extends class_1309> entityType = this.params.entityIDs.get(BrutalBosses.rand.nextInt(this.params.entityIDs.size()));
        try {
            summoned = (class_1309)entityType.method_5883(this.mob.method_37908());
            if (this.params.entityNBTData.containsKey(class_7923.field_41177.method_10221(entityType))) {
                class_2487 nbt = this.params.entityNBTData.get(class_7923.field_41177.method_10221(entityType));
                if (nbt.method_10545("Pos")) {
                    summoned.method_5651(nbt);
                } else {
                    summoned.method_5749(nbt);
                }
                summoned.method_5826(UUID.randomUUID());
            } else if (summoned instanceof class_1603) {
                summoned.method_6122(class_1268.field_5808, class_1802.field_8102.method_7854());
            }
        }
        catch (Exception e) {
            BossCapability bossCapability = ((BossCapEntity)this.mob).getBossCap();
            if (bossCapability != null) {
                BrutalBosses.LOGGER.warn("Failed summoning add for boss:" + bossCapability.getBossType().getID(), (Throwable)e);
                return;
            }
            BrutalBosses.LOGGER.warn("Failed summoning add for boss:", (Throwable)e);
            return;
        }
        class_2338 spawnPos = BossSpawnHandler.findSpawnPosForBoss((class_5425)((class_3218)this.mob.method_37908()), (class_1297)summoned, this.mob.method_24515());
        if (spawnPos == null) {
            return;
        }
        ((class_3218)this.mob.method_37908()).method_14199((class_2394)class_2398.field_11204, (double)spawnPos.method_10263(), (double)(spawnPos.method_10264() + 1), (double)spawnPos.method_10260(), 20, 0.0, 0.0, 0.0, 0.0);
        if (summoned instanceof class_1308) {
            class_268 team = this.mob.method_37908().method_8428().method_1153("bb:bossteam");
            if (team == null) {
                team = this.mob.method_37908().method_8428().method_1171("bb:bossteam");
            }
            this.mob.method_37908().method_8428().method_1172(summoned.method_5820(), team);
            ((class_1308)summoned).method_5980(this.target);
        }
        summoned.method_5814((double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260());
        this.mob.method_37908().method_8649((class_1297)summoned);
        this.summonedMobs.add(summoned);
    }

    public static class SummonParams
    extends IAIParams.DefaultParams {
        private int interval = 500;
        private List<class_1299<? extends class_1309>> entityIDs = new ArrayList<class_1299<? extends class_1309>>();
        private int count = 1;
        private int maxcount = 2;
        private float ownerdamage = 0.0f;
        private Map<class_2960, class_2487> entityNBTData = new HashMap<class_2960, class_2487>();
        private static final String SUMM_INTERVAL = "interval";
        private static final String SUMM_MAX = "maxcount";
        private static final String SUMM_COUNT = "count";
        private static final String ENTITY_ID = "entityid";
        private static final String ENTITIES = "entities";
        private static final String OWNERDAMAGE = "ownerdamagepct";
        private static final String SUMM_ENTITY_NBT = "entitynbt";

        public SummonParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            HashMap<class_2960, class_2487> entityData = new HashMap<class_2960, class_2487>();
            ArrayList<class_1299<? extends class_1309>> types = new ArrayList<class_1299<? extends class_1309>>();
            for (JsonElement entityEntry : jsonElement.get(ENTITIES).getAsJsonArray()) {
                class_2960 entityID = new class_2960(((JsonObject)entityEntry).get(ENTITY_ID).getAsString());
                types.add((class_1299<? extends class_1309>)((class_1299)class_7923.field_41177.method_10223(entityID)));
                if (!((JsonObject)entityEntry).has(SUMM_ENTITY_NBT)) continue;
                try {
                    entityData.put(entityID, class_2522.method_10718((String)((JsonObject)entityEntry).get(SUMM_ENTITY_NBT).getAsString()));
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            this.entityIDs = types;
            this.entityNBTData = entityData;
            if (jsonElement.has(SUMM_INTERVAL)) {
                this.interval = jsonElement.get(SUMM_INTERVAL).getAsInt();
            }
            if (jsonElement.has(SUMM_COUNT)) {
                this.count = jsonElement.get(SUMM_COUNT).getAsInt();
            }
            if (jsonElement.has(SUMM_MAX)) {
                this.maxcount = jsonElement.get(SUMM_MAX).getAsInt();
            }
            if (jsonElement.has(OWNERDAMAGE)) {
                this.ownerdamage = jsonElement.get(OWNERDAMAGE).getAsFloat() / 100.0f;
            }
            return this;
        }
    }
}

