/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.capability.BossCapEntity;
import java.util.EnumSet;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_2960;

public class MeleeShieldAttackGoal
extends class_1352 {
    public static class_2960 ID = new class_2960("brutalbosses:shieldmelee");
    private final BossType bossType;
    protected final class_1308 mob;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private class_11 path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final double attackInterval;
    private long lastCanUseCheck;
    int shieldTicks = 0;

    public MeleeShieldAttackGoal(class_1308 entity, double speed) {
        this.mob = entity;
        this.speedModifier = speed;
        this.followingTargetEvenIfNotSeen = true;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18408));
        this.bossType = ((BossCapEntity)this.mob).getBossCap().getBossType();
        this.attackInterval = this.bossType.getCustomAttributeValueOrDefault("attack_speed", 1.0f);
    }

    public boolean method_6264() {
        long timeDiff = this.mob.method_37908().method_8510();
        if (timeDiff - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = timeDiff;
        class_1309 livingentity = this.mob.method_5968();
        if (livingentity == null || !livingentity.method_5805()) {
            return false;
        }
        this.path = this.mob.method_5942().method_6349((class_1297)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.mob.method_5649(livingentity.method_23317(), livingentity.method_23318(), livingentity.method_23321());
    }

    public boolean method_6266() {
        class_1309 livingentity = this.mob.method_5968();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.method_5805()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.method_5942().method_6357();
        }
        if (!this.mob.method_18407(livingentity.method_24515())) {
            return false;
        }
        return !(livingentity instanceof class_1657) || !livingentity.method_7325() && !((class_1657)livingentity).method_7337();
    }

    public void method_6269() {
        this.mob.method_5942().method_6334(this.path, this.speedModifier);
        this.mob.method_19540(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void method_6270() {
        this.mob.method_19540(false);
        this.mob.method_5942().method_6340();
        this.mob.method_6019(class_1268.field_5808);
    }

    public void method_6268() {
        class_1309 livingentity = this.mob.method_5968();
        if (livingentity == null) {
            return;
        }
        this.mob.method_5988().method_6226((class_1297)livingentity, 30.0f, 30.0f);
        double d0 = this.mob.method_5649(livingentity.method_23317(), livingentity.method_23318(), livingentity.method_23321());
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if ((this.followingTargetEvenIfNotSeen || this.mob.method_5985().method_6369((class_1297)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.method_5649(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.method_6051().method_43057() < 0.05f)) {
            this.pathedTargetX = livingentity.method_23317();
            this.pathedTargetY = livingentity.method_23318();
            this.pathedTargetZ = livingentity.method_23321();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.method_6051().method_43048(7);
            if (d0 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d0 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.method_5942().method_6335((class_1297)livingentity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(livingentity, d0);
    }

    protected void checkAndPerformAttack(class_1309 target, double dist) {
        double d0 = this.getAttackReachSqr(target);
        if (dist <= d0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.mob.method_6104(class_1268.field_5808);
            this.mob.method_6121((class_1297)target);
        }
        if (this.shieldTicks == -20 && BrutalBosses.rand.nextInt(20) == 0) {
            this.mob.method_6019(class_1268.field_5810);
            this.shieldTicks = BrutalBosses.rand.nextInt(10) + 20;
        }
        if (this.shieldTicks > -20) {
            --this.shieldTicks;
            if (this.shieldTicks == 0) {
                this.mob.method_6021();
            }
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = (int)(20.0 / this.attackInterval);
    }

    protected double getAttackReachSqr(class_1309 entity) {
        return (double)(this.mob.method_17681() * 2.0f * this.mob.method_17681() * 2.0f) * (double)this.bossType.getVisualScale();
    }
}

