/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_7923;

public class MeleeHitGoal
extends class_1352 {
    public static class_2960 ID = new class_2960("brutalbosses:meleehit");
    private final class_1308 mob;
    private class_1309 target = null;
    private MeleeHitParams params;
    private int attackTimer = 0;

    public MeleeHitGoal(class_1308 mob, IAIParams params) {
        this.params = (MeleeHitParams)params;
        this.mob = mob;
    }

    public boolean method_6264() {
        class_1309 target = this.mob.method_5968();
        if (target != null && target.method_5805()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void method_6270() {
        this.target = null;
        this.attackTimer = 0;
    }

    public void method_6268() {
        if (--this.attackTimer > 0) {
            return;
        }
        double distSqr = this.mob.method_5649(this.target.method_23317(), this.target.method_23318(), this.target.method_23321());
        if (distSqr < (double)this.params.attackDistance) {
            this.attackTimer = (int)((double)this.params.cooldown * ((double)BrutalBosses.rand.nextFloat() * 0.5 + 0.75));
            this.mob.method_6104(class_1268.field_5808);
            float damage = this.params.extraDamage;
            if (this.mob.method_6127().method_27306(class_5134.field_23721)) {
                damage = (float)((double)damage + this.mob.method_26825(class_5134.field_23721));
            }
            if (this.target.method_5643(this.mob.method_48923().method_48812((class_1309)this.mob), damage += class_1890.method_8218((class_1799)this.mob.method_6047(), (class_1310)this.target.method_6046()))) {
                int fireAspect = class_1890.method_8199((class_1309)this.mob);
                if (fireAspect > 0) {
                    this.target.method_5639(fireAspect * 4);
                }
                if (this.params.onHitMobEffect != null) {
                    this.target.method_6092(new class_1293(this.params.onHitMobEffect, this.params.potionduration, this.params.potionlevel));
                }
                float knockBack = this.params.knockback;
                if (this.mob.method_6127().method_27306(class_5134.field_23722)) {
                    knockBack += (float)this.mob.method_26825(class_5134.field_23722);
                }
                if ((knockBack += (float)class_1890.method_8205((class_1309)this.mob)) > 0.0f) {
                    this.target.method_6005((double)(knockBack * 0.5f), (double)class_3532.method_15374((float)(this.mob.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.mob.method_36454() * ((float)Math.PI / 180)))));
                }
                this.mob.method_5723((class_1309)this.mob, (class_1297)this.target);
                this.mob.method_6114((class_1297)this.target);
            }
        }
    }

    public static class MeleeHitParams
    extends IAIParams.DefaultParams {
        private float attackDistance = 2.0f;
        private float extraDamage = 2.0f;
        private class_1291 onHitMobEffect = null;
        private float knockback = 0.0f;
        private int cooldown = 30;
        private int potionlevel = 1;
        private int potionduration = 60;
        private static final String ATKDIST = "attackdist";
        private static final String EXTDMG = "damage";
        private static final String POTION = "potiononhit";
        private static final String POTION_STR = "potionlevel";
        private static final String POTION_DUR = "potionduration";
        private static final String KNOCK = "knockback";
        private static final String COOLDOWN = "cooldown";

        public MeleeHitParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ATKDIST)) {
                this.attackDistance = jsonElement.get(ATKDIST).getAsFloat();
                this.attackDistance *= this.attackDistance;
            }
            if (jsonElement.has(EXTDMG)) {
                this.extraDamage = jsonElement.get(EXTDMG).getAsFloat();
            }
            if (jsonElement.has(POTION_STR)) {
                this.potionlevel = jsonElement.get(POTION_STR).getAsInt();
            }
            if (jsonElement.has(POTION_DUR)) {
                this.potionduration = jsonElement.get(POTION_DUR).getAsInt();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.cooldown = jsonElement.get(COOLDOWN).getAsInt();
            }
            if (jsonElement.has(KNOCK)) {
                this.knockback = jsonElement.get(KNOCK).getAsFloat();
            }
            if (jsonElement.has(POTION)) {
                class_2960 MobEffectID = new class_2960(jsonElement.get(POTION).getAsString());
                this.onHitMobEffect = (class_1291)class_7923.field_41174.method_10223(MobEffectID);
            }
            return this;
        }
    }
}

