/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.data.PotionData;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_7923;

public class JumpAttackGoal
extends class_1352 {
    public static class_2960 ID = new class_2960("brutalbosses:jumpattack");
    private final class_1308 mob;
    private JumpAttackParams params;
    private class_1309 target = null;
    private class_243 end;
    private int animationTick = 0;
    private double distance = 10.0;
    private int ticksToNextUpdate = 0;
    private boolean isCharging = false;

    public JumpAttackGoal(class_1308 mob, IAIParams params) {
        this.params = (JumpAttackParams)params;
        this.mob = mob;
    }

    public boolean method_6264() {
        class_1309 target = this.mob.method_5968();
        if (target != null && target.method_5805()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void method_6270() {
        this.target = null;
    }

    public void method_6268() {
        class_11 path;
        if (--this.ticksToNextUpdate > 0) {
            this.mob.method_5660(true);
            return;
        }
        double dist = Math.sqrt(this.mob.method_5649(this.target.method_23317(), this.target.method_23318(), this.target.method_23321()));
        if (dist >= (double)this.params.minDistance && dist <= (double)this.params.maxDistance && !this.isCharging && this.mob.method_5985().method_6369((class_1297)this.target) && (float)Math.abs(this.mob.method_31478() - this.target.method_31478()) < this.params.maxJumpHeight && (path = this.mob.method_5942().method_6345()) != null) {
            this.isCharging = true;
            this.end = this.target.method_19538();
            this.distance = this.mob.method_19538().method_1022(this.end);
            this.animationTick = 0;
            this.mob.method_37908().method_43128(null, this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321(), class_3417.field_15013, this.mob.method_5634(), 2.0f, 1.0f);
            this.mob.method_37908().method_43128(null, this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321(), class_3417.field_15152, this.mob.method_5634(), 1.5f, 1.0f);
            this.mob.method_6092(new class_1293(class_1294.field_5906, 100, 1));
            double d0 = -class_3532.method_15374((float)(this.mob.method_36454() * ((float)Math.PI / 180)));
            double d1 = class_3532.method_15362((float)(this.mob.method_36454() * ((float)Math.PI / 180)));
            if (this.mob.method_37908() instanceof class_3218) {
                ((class_3218)this.mob.method_37908()).method_14199((class_2394)class_2398.field_11203, this.mob.method_23317() + d0, this.mob.method_23323(0.5), this.mob.method_23321() + d1, 30, d0, 0.0, d1, 0.0);
                ((class_3218)this.mob.method_37908()).method_14199((class_2394)class_2398.field_28479, this.mob.method_23317() + d0, this.mob.method_23323(0.5), this.mob.method_23321() + d1, 500, d0, 0.1, d1, 10.0);
            }
        }
        if (!this.isCharging) {
            return;
        }
        this.params.duration = 20;
        this.mob.method_5988().method_35111((class_1297)this.target);
        this.mob.method_5988().method_6231();
        if ((double)this.animationTick <= (double)this.params.duration * 0.1) {
            double distanceModifier = this.distance / (double)this.params.duration;
            direction = this.end.method_1020(this.mob.method_19538()).method_18805(1.0, 0.0, 1.0).method_1029().method_18805(distanceModifier, 1.0, distanceModifier);
            this.mob.method_18799(direction);
            this.mob.method_5660(true);
        } else if ((double)this.animationTick <= (double)this.params.duration * 0.1 + 4.0) {
            this.mob.method_6100(true);
            this.mob.method_5660(false);
            this.mob.method_5993().method_6233();
            double distanceModifier = this.distance / (double)this.params.duration;
            direction = this.end.method_1020(this.mob.method_19538()).method_18805(1.0, 0.0, 1.0).method_1029().method_1031(0.0, 0.75, 0.0).method_18805(distanceModifier, distanceModifier, distanceModifier);
            this.mob.method_18799(direction);
        } else if (this.animationTick <= this.params.duration && this.mob.method_19538().method_1022(this.end) >= 2.0) {
            double distanceModifier = this.distance / (double)this.params.duration;
            direction = this.end.method_1020(this.mob.method_19538()).method_18805(1.0, 1.0, 1.0).method_1029().method_18805(distanceModifier, distanceModifier, distanceModifier);
            this.mob.method_18799(direction);
        }
        if (this.mob.method_24828() && this.mob.method_19538().method_1022(this.end) < 2.0 || this.animationTick == this.params.duration) {
            this.isCharging = false;
            this.ticksToNextUpdate = (int)(this.params.interval + (float)(BrutalBosses.rand.nextInt(20) - 10));
            this.ticksToNextUpdate = 100;
            this.mob.method_6092(new class_1293(class_1294.field_5909, 30, 3));
            this.mob.method_18799(class_243.field_1353.method_1031(0.0, -0.8, 0.0));
            this.mob.method_37908().method_43128(null, this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321(), class_3417.field_14833, this.mob.method_5634(), 100.0f, 0.1f);
            this.mob.method_37908().method_43128(null, this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321(), class_3417.field_21076, this.mob.method_5634(), 100.0f, 0.1f);
            double d0 = 3.0;
            double d1 = 3.0;
            if (this.mob.method_37908() instanceof class_3218) {
                ((class_3218)this.mob.method_37908()).method_14199((class_2394)class_2398.field_11237, this.mob.method_23317() + d0, this.mob.method_23318(), this.mob.method_23321() + d1, 300, d0, 0.0, d1, 0.0);
                ((class_3218)this.mob.method_37908()).method_14199((class_2394)class_2398.field_11251, this.mob.method_23317() + d0, this.mob.method_23318(), this.mob.method_23321() + d1, 300, d0, 0.0, d1, 0.0);
                ((class_3218)this.mob.method_37908()).method_14199((class_2394)class_2398.field_11248, this.mob.method_23317() + d0, this.mob.method_23318(), this.mob.method_23321() + d1, 300, d0, 0.0, d1, 0.0);
                ((class_3218)this.mob.method_37908()).method_14199((class_2394)class_2398.field_22246, this.mob.method_23317() + d0, this.mob.method_23318(), this.mob.method_23321() + d1, 300, d0, 0.0, d1, 0.0);
            }
            if (this.mob.method_5739((class_1297)this.target) <= this.params.attackDistance) {
                this.mob.method_6104(class_1268.field_5808);
                float damage = this.params.extraDamage;
                if (this.mob.method_6127().method_27306(class_5134.field_23721)) {
                    damage = (float)((double)damage + this.mob.method_26825(class_5134.field_23721));
                }
                this.target.method_5643(this.mob.method_48923().method_48812((class_1309)this.mob), damage);
            }
            for (PotionData potionData : this.params.potions) {
                class_1295 areaeffectcloudentity = new class_1295(this.mob.method_37908(), this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321());
                areaeffectcloudentity.method_5607((class_1309)this.mob);
                areaeffectcloudentity.method_5608((class_2394)(potionData.particleType() instanceof class_2394 ? (class_2394)potionData.particleType() : class_2398.field_22246));
                areaeffectcloudentity.method_5603((float)this.params.potionRadius);
                areaeffectcloudentity.method_5604(200);
                areaeffectcloudentity.method_5610(new class_1293(potionData.effect(), potionData.duration(), potionData.amplifier()));
                this.mob.method_37908().method_8649((class_1297)areaeffectcloudentity);
            }
        } else if (this.mob.method_37908() instanceof class_3218) {
            ((class_3218)this.mob.method_37908()).method_14199((class_2394)class_2398.field_11204, this.mob.method_23317(), this.mob.method_23323(0.5), this.mob.method_23321(), 10, 0.1, 0.0, 0.1, 0.05);
        }
        ++this.animationTick;
    }

    public static class JumpAttackParams
    extends IAIParams.DefaultParams {
        private float maxDistance = 15.0f;
        private float minDistance = 3.0f;
        private float maxJumpHeight = 4.0f;
        private int duration = 10;
        private float interval = 200.0f;
        private float extraDamage = 2.0f;
        private float attackDistance = 4.0f;
        private List<PotionData> potions = new ArrayList<PotionData>();
        private int potionRadius = 5;
        private static final String ATKDIST = "attackdist";
        private static final String MAXHEIGHT = "maxheight";
        private static final String EXTDMG = "extradamage";
        public static final String MINDIST = "mindist";
        public static final String MAXDIST = "maxdist";
        public static final String DURATION = "duration";
        public static final String COOLDOWN = "interval";
        public static final String POTIONS = "potions";
        public static final String POTIONRADIUS = "potionradius";
        public static final String POTIONDURATION = "duration";
        public static final String POTIONAMPLIFIER = "amplifier";
        public static final String POTIONPARTICLE = "particle";

        public JumpAttackParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ATKDIST)) {
                this.attackDistance = jsonElement.get(ATKDIST).getAsFloat();
            }
            if (jsonElement.has(EXTDMG)) {
                this.extraDamage = jsonElement.get(EXTDMG).getAsFloat();
            }
            if (jsonElement.has(MINDIST)) {
                this.minDistance = jsonElement.get(MINDIST).getAsFloat();
            }
            if (jsonElement.has(MAXDIST)) {
                this.maxDistance = jsonElement.get(MAXDIST).getAsFloat();
            }
            if (jsonElement.has("duration")) {
                this.duration = jsonElement.get("duration").getAsInt();
            }
            if (jsonElement.has(POTIONRADIUS)) {
                this.potionRadius = jsonElement.get(POTIONRADIUS).getAsInt();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.interval = jsonElement.get(COOLDOWN).getAsFloat();
            }
            if (jsonElement.has(MAXHEIGHT)) {
                this.maxJumpHeight = jsonElement.get(MAXHEIGHT).getAsFloat();
            }
            if (jsonElement.has(POTIONS)) {
                this.potions = new ArrayList<PotionData>();
                for (Map.Entry data : jsonElement.get(POTIONS).getAsJsonObject().entrySet()) {
                    JsonObject potionData = ((JsonElement)data.getValue()).getAsJsonObject();
                    class_2396 particleType = null;
                    if (potionData.has(POTIONPARTICLE)) {
                        particleType = (class_2396)class_7923.field_41180.method_10223(class_2960.method_12829((String)potionData.get(POTIONPARTICLE).getAsString()));
                    }
                    this.potions.add(new PotionData((class_1291)class_7923.field_41174.method_10223(class_2960.method_12829((String)((String)data.getKey()))), potionData.get("duration").getAsInt(), potionData.get(POTIONAMPLIFIER).getAsInt(), particleType));
                }
            }
            return this;
        }
    }
}

