/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.config.CommonConfiguration;
import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.ai.SimpleRangedAttackGoal;
import com.brutalbosses.entity.thrownentity.ThrownItemEntity;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5425;

public class ItemThrowAttackGoal
extends SimpleRangedAttackGoal {
    public static class_2960 ID = new class_2960("brutalbosses:itemshootgoal");

    public ItemThrowAttackGoal(class_1308 mob, IAIParams params) {
        super(mob, params);
    }

    @Override
    protected class_2960 getID() {
        return ID;
    }

    @Override
    protected void doRangedAttack(class_1676 Projectile, class_1309 target) {
        Projectile.method_5650(class_1297.class_5529.field_26999);
        double xDiff = target.method_23317() - this.mob.method_23317();
        double yDiff = target.method_23323(0.5) - (this.mob.method_23318() + (double)this.mob.method_5751() - 0.5);
        double zDiff = target.method_23321() - this.mob.method_23321();
        ThrownItemEntity pearlEntity = new ThrownItemEntity(this.mob.method_37908(), this.mob);
        pearlEntity.method_5814(this.mob.method_23317(), this.mob.method_23318() + (double)this.mob.method_5751() - 0.5, this.mob.method_23321());
        pearlEntity.method_7485(xDiff, yDiff, zDiff, 0.8f * this.params.speed, 3.0f);
        pearlEntity.method_16940(((ItemThrowParams)this.params).item);
        pearlEntity.method_5875(true);
        if (pearlEntity instanceof IOnProjectileHit) {
            ((IOnProjectileHit)((Object)pearlEntity)).setMaxLifeTime(this.mob.method_37908().method_8510() + 400L);
            ((IOnProjectileHit)((Object)pearlEntity)).setOnHitAction(rayTraceResult -> {
                if (!this.mob.method_5805()) {
                    return;
                }
                if (rayTraceResult instanceof class_3966) {
                    class_1297 hitEntity = ((class_3966)rayTraceResult).method_17782();
                    if (hitEntity instanceof class_1309 && hitEntity != this.mob) {
                        if (((ItemThrowParams)this.params).damage > 0.0f) {
                            hitEntity.method_5643(this.mob.method_48923().method_48815(hitEntity, (class_1297)this.mob), ((ItemThrowParams)this.params).damage);
                        }
                        if (((ItemThrowParams)this.params).lighting) {
                            class_1538 lightningboltentity = (class_1538)class_1299.field_6112.method_5883(hitEntity.method_37908());
                            lightningboltentity.method_24203(hitEntity.method_23317(), hitEntity.method_23318(), hitEntity.method_23321());
                            lightningboltentity.method_29498(false);
                            this.mob.method_37908().method_8649((class_1297)lightningboltentity);
                        }
                        if (((ItemThrowParams)this.params).explode) {
                            hitEntity.method_37908().method_8454(null, this.mob.method_48923().method_48815((class_1297)((class_1309)hitEntity), (class_1297)this.mob), null, hitEntity.method_23317(), hitEntity.method_23318(), hitEntity.method_23321(), (float)(1.0 * ((CommonConfiguration)BrutalBosses.config.getCommonConfig()).globalDifficultyMultiplier) * pearlEntity.getScale(), false, class_1937.class_7867.field_40890);
                        }
                        if (((ItemThrowParams)this.params).teleport) {
                            double d0 = -class_3532.method_15374((float)(this.mob.method_36454() * ((float)Math.PI / 180)));
                            double d1 = class_3532.method_15362((float)(this.mob.method_36454() * ((float)Math.PI / 180)));
                            if (this.mob.method_37908() instanceof class_3218) {
                                ((class_3218)this.mob.method_37908()).method_14199((class_2394)class_2398.field_11214, this.mob.method_23317() + d0, this.mob.method_23323(0.5), this.mob.method_23321() + d1, 20, d0, 0.0, d1, 0.0);
                            }
                            this.mob.method_37908().method_43128((class_1657)null, this.mob.field_6014, this.mob.field_6036, this.mob.field_5969, class_3417.field_14879, this.mob.method_5634(), 1.0f, 1.0f);
                            this.mob.method_5783(class_3417.field_14879, 1.0f, 1.0f);
                            this.mob.method_5859(pearlEntity.method_23317(), hitEntity.method_23318(), pearlEntity.method_23321());
                        }
                    }
                } else if (rayTraceResult instanceof class_3965) {
                    class_2338 tpPos;
                    class_2338 hitPos = ((class_3965)rayTraceResult).method_17777();
                    if (((ItemThrowParams)this.params).lighting) {
                        class_1538 lightningboltentity = (class_1538)class_1299.field_6112.method_5883(this.mob.method_37908());
                        lightningboltentity.method_24203((double)hitPos.method_10263(), (double)hitPos.method_10264(), (double)hitPos.method_10260());
                        lightningboltentity.method_29498(false);
                        this.mob.method_37908().method_8649((class_1297)lightningboltentity);
                    }
                    if (((ItemThrowParams)this.params).explode) {
                        this.mob.method_37908().method_8454(null, this.mob.method_48923().method_48815((class_1297)this.mob, (class_1297)this.mob), null, (double)hitPos.method_10263(), (double)hitPos.method_10264(), (double)hitPos.method_10260(), (float)(1.0 * ((CommonConfiguration)BrutalBosses.config.getCommonConfig()).globalDifficultyMultiplier), false, class_1937.class_7867.field_40890);
                    }
                    if (((ItemThrowParams)this.params).teleport && (tpPos = BossSpawnHandler.findSpawnPosForBoss((class_5425)((class_3218)this.mob.method_37908()), (class_1297)this.mob, hitPos)) != null) {
                        double d0 = -class_3532.method_15374((float)(this.mob.method_36454() * ((float)Math.PI / 180)));
                        double d1 = class_3532.method_15362((float)(this.mob.method_36454() * ((float)Math.PI / 180)));
                        if (this.mob.method_37908() instanceof class_3218) {
                            ((class_3218)this.mob.method_37908()).method_14199((class_2394)class_2398.field_11214, this.mob.method_23317() + d0, this.mob.method_23323(0.5), this.mob.method_23321() + d1, 20, d0, 0.0, d1, 0.0);
                        }
                        this.mob.method_37908().method_43128((class_1657)null, this.mob.field_6014, this.mob.field_6036, this.mob.field_5969, class_3417.field_14879, this.mob.method_5634(), 1.0f, 1.0f);
                        this.mob.method_5783(class_3417.field_14879, 1.0f, 1.0f);
                        this.mob.method_5859((double)tpPos.method_10263(), (double)tpPos.method_10264(), (double)tpPos.method_10260());
                    }
                }
            });
        }
        this.mob.method_37908().method_8649((class_1297)pearlEntity);
    }

    @Override
    protected class_1676 createProjectile() {
        ThrownItemEntity pearlEntity = new ThrownItemEntity(this.mob.method_37908(), this.mob);
        pearlEntity.method_16940(((ItemThrowParams)this.params).item);
        pearlEntity.setScale(((ItemThrowParams)this.params).projectilesize);
        return pearlEntity;
    }

    public static class ItemThrowParams
    extends SimpleRangedAttackGoal.RangedParams {
        private class_1799 item = class_1802.field_8634.method_7854();
        private float damage = 0.0f;
        private boolean teleport = false;
        private boolean lighting = false;
        private boolean explode = false;
        private float projectilesize = 1.0f;
        private static final String ITEM = "item";
        private static final String DAMAGE = "damage";
        private static final String TELEPORT = "teleport";
        private static final String LIGHTNING = "lightning";
        private static final String EXPLODE = "explode";
        private static final String PR_SIZE = "projectilesize";

        public ItemThrowParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ITEM)) {
                try {
                    this.item = class_1799.method_7915((class_2487)class_2522.method_10718((String)jsonElement.get(ITEM).getAsString()));
                }
                catch (CommandSyntaxException e) {
                    BrutalBosses.LOGGER.warn("Could not parse item of: " + jsonElement.get(ITEM).getAsString(), (Throwable)e);
                }
            }
            if (jsonElement.has(DAMAGE)) {
                this.damage = jsonElement.get(DAMAGE).getAsFloat();
            }
            if (jsonElement.has(TELEPORT)) {
                this.teleport = jsonElement.get(TELEPORT).getAsBoolean();
            }
            if (jsonElement.has(LIGHTNING)) {
                this.lighting = jsonElement.get(LIGHTNING).getAsBoolean();
            }
            if (jsonElement.has(EXPLODE)) {
                this.explode = jsonElement.get(EXPLODE).getAsBoolean();
            }
            if (jsonElement.has(PR_SIZE)) {
                this.projectilesize = jsonElement.get(PR_SIZE).getAsFloat();
            }
            return this;
        }
    }
}

