/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.class_1309;

public interface IAIParams {
    public static final DefaultParams EMPTY = new DefaultParams();

    public IAIParams parse(JsonObject var1);

    public static class DefaultParams
    implements IAIParams {
        public Predicate<class_1309> healthPhaseCheck = e -> true;
        private static final String HEAL_INTERVAL = "healthinterval";

        public DefaultParams(JsonObject jsonData) {
            this.parse(jsonData);
        }

        private DefaultParams() {
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            if (jsonElement.has(HEAL_INTERVAL)) {
                String[] intervals;
                this.healthPhaseCheck = e -> true;
                String rawData = jsonElement.get(HEAL_INTERVAL).getAsString();
                for (String interval : intervals = rawData.split(";")) {
                    int boundary2;
                    String[] intervalBoundaries = interval.split("-");
                    if (intervalBoundaries.length != 2) {
                        BrutalBosses.LOGGER.warn("Could not parse AI health requirements, needs exactly two numbers seperated by - for: " + interval);
                        throw new UnsupportedOperationException();
                    }
                    int boundary1 = Integer.parseInt(intervalBoundaries[0]);
                    this.healthPhaseCheck = boundary1 < (boundary2 = Integer.parseInt(intervalBoundaries[1])) ? this.healthPhaseCheck.and(e -> e.method_6032() / e.method_6063() * 100.0f >= (float)boundary1 && e.method_6032() / e.method_6063() * 100.0f <= (float)boundary2) : this.healthPhaseCheck.and(e -> e.method_6032() / e.method_6063() * 100.0f <= (float)boundary1 && e.method_6032() / e.method_6063() * 100.0f >= (float)boundary2);
                }
            }
            return this;
        }
    }
}

